/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetJobEntityRequest extends DeadlineRequest implements
        ToCopyableBuilder<BatchGetJobEntityRequest.Builder, BatchGetJobEntityRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(BatchGetJobEntityRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(BatchGetJobEntityRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("fleetId").build()).build();

    private static final SdkField<String> WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerId").getter(getter(BatchGetJobEntityRequest::workerId)).setter(setter(Builder::workerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workerId").build()).build();

    private static final SdkField<List<JobEntityIdentifiersUnion>> IDENTIFIERS_FIELD = SdkField
            .<List<JobEntityIdentifiersUnion>> builder(MarshallingType.LIST)
            .memberName("identifiers")
            .getter(getter(BatchGetJobEntityRequest::identifiers))
            .setter(setter(Builder::identifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobEntityIdentifiersUnion> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobEntityIdentifiersUnion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, FLEET_ID_FIELD,
            WORKER_ID_FIELD, IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String farmId;

    private final String fleetId;

    private final String workerId;

    private final List<JobEntityIdentifiersUnion> identifiers;

    private BatchGetJobEntityRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.workerId = builder.workerId;
        this.identifiers = builder.identifiers;
    }

    /**
     * <p>
     * The farm ID of the worker that's fetching job details. The worker must have an assignment on a job to fetch job
     * details.
     * </p>
     * 
     * @return The farm ID of the worker that's fetching job details. The worker must have an assignment on a job to
     *         fetch job details.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The fleet ID of the worker that's fetching job details. The worker must have an assignment on a job to fetch job
     * details.
     * </p>
     * 
     * @return The fleet ID of the worker that's fetching job details. The worker must have an assignment on a job to
     *         fetch job details.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The worker ID of the worker containing the job details to get.
     * </p>
     * 
     * @return The worker ID of the worker containing the job details to get.
     */
    public final String workerId() {
        return workerId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identifiers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdentifiers() {
        return identifiers != null && !(identifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The job identifiers to include within the job entity batch details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentifiers} method.
     * </p>
     * 
     * @return The job identifiers to include within the job entity batch details.
     */
    public final List<JobEntityIdentifiersUnion> identifiers() {
        return identifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentifiers() ? identifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetJobEntityRequest)) {
            return false;
        }
        BatchGetJobEntityRequest other = (BatchGetJobEntityRequest) obj;
        return Objects.equals(farmId(), other.farmId()) && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(workerId(), other.workerId()) && hasIdentifiers() == other.hasIdentifiers()
                && Objects.equals(identifiers(), other.identifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetJobEntityRequest").add("FarmId", farmId()).add("FleetId", fleetId())
                .add("WorkerId", workerId()).add("Identifiers", hasIdentifiers() ? identifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "workerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "identifiers":
            return Optional.ofNullable(clazz.cast(identifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("farmId", FARM_ID_FIELD);
        map.put("fleetId", FLEET_ID_FIELD);
        map.put("workerId", WORKER_ID_FIELD);
        map.put("identifiers", IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetJobEntityRequest, T> g) {
        return obj -> g.apply((BatchGetJobEntityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetJobEntityRequest> {
        /**
         * <p>
         * The farm ID of the worker that's fetching job details. The worker must have an assignment on a job to fetch
         * job details.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the worker that's fetching job details. The worker must have an assignment on a job to
         *        fetch job details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The fleet ID of the worker that's fetching job details. The worker must have an assignment on a job to fetch
         * job details.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID of the worker that's fetching job details. The worker must have an assignment on a job to
         *        fetch job details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The worker ID of the worker containing the job details to get.
         * </p>
         * 
         * @param workerId
         *        The worker ID of the worker containing the job details to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * The job identifiers to include within the job entity batch details.
         * </p>
         * 
         * @param identifiers
         *        The job identifiers to include within the job entity batch details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(Collection<JobEntityIdentifiersUnion> identifiers);

        /**
         * <p>
         * The job identifiers to include within the job entity batch details.
         * </p>
         * 
         * @param identifiers
         *        The job identifiers to include within the job entity batch details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(JobEntityIdentifiersUnion... identifiers);

        /**
         * <p>
         * The job identifiers to include within the job entity batch details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.JobEntityIdentifiersUnion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.JobEntityIdentifiersUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.JobEntityIdentifiersUnion.Builder#build()} is called
         * immediately and its result is passed to {@link #identifiers(List<JobEntityIdentifiersUnion>)}.
         * 
         * @param identifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.JobEntityIdentifiersUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identifiers(java.util.Collection<JobEntityIdentifiersUnion>)
         */
        Builder identifiers(Consumer<JobEntityIdentifiersUnion.Builder>... identifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String farmId;

        private String fleetId;

        private String workerId;

        private List<JobEntityIdentifiersUnion> identifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetJobEntityRequest model) {
            super(model);
            farmId(model.farmId);
            fleetId(model.fleetId);
            workerId(model.workerId);
            identifiers(model.identifiers);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getWorkerId() {
            return workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final List<JobEntityIdentifiersUnion.Builder> getIdentifiers() {
            List<JobEntityIdentifiersUnion.Builder> result = JobEntityIdentifiersCopier.copyToBuilder(this.identifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentifiers(Collection<JobEntityIdentifiersUnion.BuilderImpl> identifiers) {
            this.identifiers = JobEntityIdentifiersCopier.copyFromBuilder(identifiers);
        }

        @Override
        public final Builder identifiers(Collection<JobEntityIdentifiersUnion> identifiers) {
            this.identifiers = JobEntityIdentifiersCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(JobEntityIdentifiersUnion... identifiers) {
            identifiers(Arrays.asList(identifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(Consumer<JobEntityIdentifiersUnion.Builder>... identifiers) {
            identifiers(Stream.of(identifiers).map(c -> JobEntityIdentifiersUnion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetJobEntityRequest build() {
            return new BatchGetJobEntityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
