/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The budget action to add.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BudgetActionToAdd implements SdkPojo, Serializable,
        ToCopyableBuilder<BudgetActionToAdd.Builder, BudgetActionToAdd> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(BudgetActionToAdd::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Float> THRESHOLD_PERCENTAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("thresholdPercentage").getter(getter(BudgetActionToAdd::thresholdPercentage))
            .setter(setter(Builder::thresholdPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercentage").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BudgetActionToAdd::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            THRESHOLD_PERCENTAGE_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Float thresholdPercentage;

    private final String description;

    private BudgetActionToAdd(BuilderImpl builder) {
        this.type = builder.type;
        this.thresholdPercentage = builder.thresholdPercentage;
        this.description = builder.description;
    }

    /**
     * <p>
     * The type of budget action to add.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BudgetActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of budget action to add.
     * @see BudgetActionType
     */
    public final BudgetActionType type() {
        return BudgetActionType.fromValue(type);
    }

    /**
     * <p>
     * The type of budget action to add.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BudgetActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of budget action to add.
     * @see BudgetActionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The percentage threshold for the budget action to add.
     * </p>
     * 
     * @return The percentage threshold for the budget action to add.
     */
    public final Float thresholdPercentage() {
        return thresholdPercentage;
    }

    /**
     * <p>
     * A description for the budget action to add.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return A description for the budget action to add.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetActionToAdd)) {
            return false;
        }
        BudgetActionToAdd other = (BudgetActionToAdd) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(thresholdPercentage(), other.thresholdPercentage())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BudgetActionToAdd").add("Type", typeAsString())
                .add("ThresholdPercentage", thresholdPercentage())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "thresholdPercentage":
            return Optional.ofNullable(clazz.cast(thresholdPercentage()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("thresholdPercentage", THRESHOLD_PERCENTAGE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BudgetActionToAdd, T> g) {
        return obj -> g.apply((BudgetActionToAdd) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BudgetActionToAdd> {
        /**
         * <p>
         * The type of budget action to add.
         * </p>
         * 
         * @param type
         *        The type of budget action to add.
         * @see BudgetActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetActionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of budget action to add.
         * </p>
         * 
         * @param type
         *        The type of budget action to add.
         * @see BudgetActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BudgetActionType
         */
        Builder type(BudgetActionType type);

        /**
         * <p>
         * The percentage threshold for the budget action to add.
         * </p>
         * 
         * @param thresholdPercentage
         *        The percentage threshold for the budget action to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdPercentage(Float thresholdPercentage);

        /**
         * <p>
         * A description for the budget action to add.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param description
         *        A description for the budget action to add.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Float thresholdPercentage;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetActionToAdd model) {
            type(model.type);
            thresholdPercentage(model.thresholdPercentage);
            description(model.description);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BudgetActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Float getThresholdPercentage() {
            return thresholdPercentage;
        }

        public final void setThresholdPercentage(Float thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Float thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public BudgetActionToAdd build() {
            return new BudgetActionToAdd(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
