/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The start and end time of the budget.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BudgetSchedule implements SdkPojo, Serializable, ToCopyableBuilder<BudgetSchedule.Builder, BudgetSchedule> {
    private static final SdkField<FixedBudgetSchedule> FIXED_FIELD = SdkField
            .<FixedBudgetSchedule> builder(MarshallingType.SDK_POJO).memberName("fixed").getter(getter(BudgetSchedule::fixed))
            .setter(setter(Builder::fixed)).constructor(FixedBudgetSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIXED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FixedBudgetSchedule fixed;

    private final Type type;

    private BudgetSchedule(BuilderImpl builder) {
        this.fixed = builder.fixed;
        this.type = builder.type;
    }

    /**
     * <p>
     * The fixed start and end time of the budget's schedule.
     * </p>
     * 
     * @return The fixed start and end time of the budget's schedule.
     */
    public final FixedBudgetSchedule fixed() {
        return fixed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fixed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetSchedule)) {
            return false;
        }
        BudgetSchedule other = (BudgetSchedule) obj;
        return Objects.equals(fixed(), other.fixed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BudgetSchedule").add("Fixed", fixed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fixed":
            return Optional.ofNullable(clazz.cast(fixed()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #fixed()} initialized to the given value.
     *
     * <p>
     * The fixed start and end time of the budget's schedule.
     * </p>
     * 
     * @param fixed
     *        The fixed start and end time of the budget's schedule.
     */
    public static BudgetSchedule fromFixed(FixedBudgetSchedule fixed) {
        return builder().fixed(fixed).build();
    }

    /**
     * Create an instance of this class with {@link #fixed()} initialized to the given value.
     *
     * <p>
     * The fixed start and end time of the budget's schedule.
     * </p>
     * 
     * @param fixed
     *        The fixed start and end time of the budget's schedule.
     */
    public static BudgetSchedule fromFixed(Consumer<FixedBudgetSchedule.Builder> fixed) {
        FixedBudgetSchedule.Builder builder = FixedBudgetSchedule.builder();
        fixed.accept(builder);
        return fromFixed(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fixed", FIXED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BudgetSchedule, T> g) {
        return obj -> g.apply((BudgetSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BudgetSchedule> {
        /**
         * <p>
         * The fixed start and end time of the budget's schedule.
         * </p>
         * 
         * @param fixed
         *        The fixed start and end time of the budget's schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixed(FixedBudgetSchedule fixed);

        /**
         * <p>
         * The fixed start and end time of the budget's schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link FixedBudgetSchedule.Builder} avoiding the
         * need to create one manually via {@link FixedBudgetSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FixedBudgetSchedule.Builder#build()} is called immediately and
         * its result is passed to {@link #fixed(FixedBudgetSchedule)}.
         * 
         * @param fixed
         *        a consumer that will call methods on {@link FixedBudgetSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fixed(FixedBudgetSchedule)
         */
        default Builder fixed(Consumer<FixedBudgetSchedule.Builder> fixed) {
            return fixed(FixedBudgetSchedule.builder().applyMutation(fixed).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FixedBudgetSchedule fixed;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetSchedule model) {
            fixed(model.fixed);
        }

        public final FixedBudgetSchedule.Builder getFixed() {
            return fixed != null ? fixed.toBuilder() : null;
        }

        public final void setFixed(FixedBudgetSchedule.BuilderImpl fixed) {
            Object oldValue = this.fixed;
            this.fixed = fixed != null ? fixed.build() : null;
            handleUnionValueChange(Type.FIXED, oldValue, this.fixed);
        }

        @Override
        public final Builder fixed(FixedBudgetSchedule fixed) {
            Object oldValue = this.fixed;
            this.fixed = fixed;
            handleUnionValueChange(Type.FIXED, oldValue, this.fixed);
            return this;
        }

        @Override
        public BudgetSchedule build() {
            return new BudgetSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see BudgetSchedule#type()
     */
    public enum Type {
        FIXED,

        UNKNOWN_TO_SDK_VERSION
    }
}
