/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The host property details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostPropertiesResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<HostPropertiesResponse.Builder, HostPropertiesResponse> {
    private static final SdkField<IpAddresses> IP_ADDRESSES_FIELD = SdkField.<IpAddresses> builder(MarshallingType.SDK_POJO)
            .memberName("ipAddresses").getter(getter(HostPropertiesResponse::ipAddresses)).setter(setter(Builder::ipAddresses))
            .constructor(IpAddresses::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddresses").build()).build();

    private static final SdkField<String> HOST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostName").getter(getter(HostPropertiesResponse::hostName)).setter(setter(Builder::hostName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostName").build()).build();

    private static final SdkField<String> EC2_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceArn").getter(getter(HostPropertiesResponse::ec2InstanceArn))
            .setter(setter(Builder::ec2InstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceArn").build()).build();

    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceType").getter(getter(HostPropertiesResponse::ec2InstanceType))
            .setter(setter(Builder::ec2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESSES_FIELD,
            HOST_NAME_FIELD, EC2_INSTANCE_ARN_FIELD, EC2_INSTANCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IpAddresses ipAddresses;

    private final String hostName;

    private final String ec2InstanceArn;

    private final String ec2InstanceType;

    private HostPropertiesResponse(BuilderImpl builder) {
        this.ipAddresses = builder.ipAddresses;
        this.hostName = builder.hostName;
        this.ec2InstanceArn = builder.ec2InstanceArn;
        this.ec2InstanceType = builder.ec2InstanceType;
    }

    /**
     * <p>
     * The IP address of the host.
     * </p>
     * 
     * @return The IP address of the host.
     */
    public final IpAddresses ipAddresses() {
        return ipAddresses;
    }

    /**
     * <p>
     * The host name.
     * </p>
     * 
     * @return The host name.
     */
    public final String hostName() {
        return hostName;
    }

    /**
     * <p>
     * The ARN of the host EC2 instance.
     * </p>
     * 
     * @return The ARN of the host EC2 instance.
     */
    public final String ec2InstanceArn() {
        return ec2InstanceArn;
    }

    /**
     * <p>
     * The instance type of the host EC2 instance.
     * </p>
     * 
     * @return The instance type of the host EC2 instance.
     */
    public final String ec2InstanceType() {
        return ec2InstanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(hostName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostPropertiesResponse)) {
            return false;
        }
        HostPropertiesResponse other = (HostPropertiesResponse) obj;
        return Objects.equals(ipAddresses(), other.ipAddresses()) && Objects.equals(hostName(), other.hostName())
                && Objects.equals(ec2InstanceArn(), other.ec2InstanceArn())
                && Objects.equals(ec2InstanceType(), other.ec2InstanceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostPropertiesResponse").add("IpAddresses", ipAddresses()).add("HostName", hostName())
                .add("Ec2InstanceArn", ec2InstanceArn()).add("Ec2InstanceType", ec2InstanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipAddresses":
            return Optional.ofNullable(clazz.cast(ipAddresses()));
        case "hostName":
            return Optional.ofNullable(clazz.cast(hostName()));
        case "ec2InstanceArn":
            return Optional.ofNullable(clazz.cast(ec2InstanceArn()));
        case "ec2InstanceType":
            return Optional.ofNullable(clazz.cast(ec2InstanceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ipAddresses", IP_ADDRESSES_FIELD);
        map.put("hostName", HOST_NAME_FIELD);
        map.put("ec2InstanceArn", EC2_INSTANCE_ARN_FIELD);
        map.put("ec2InstanceType", EC2_INSTANCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostPropertiesResponse, T> g) {
        return obj -> g.apply((HostPropertiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostPropertiesResponse> {
        /**
         * <p>
         * The IP address of the host.
         * </p>
         * 
         * @param ipAddresses
         *        The IP address of the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(IpAddresses ipAddresses);

        /**
         * <p>
         * The IP address of the host.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpAddresses.Builder} avoiding the need to
         * create one manually via {@link IpAddresses#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpAddresses.Builder#build()} is called immediately and its result
         * is passed to {@link #ipAddresses(IpAddresses)}.
         * 
         * @param ipAddresses
         *        a consumer that will call methods on {@link IpAddresses.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipAddresses(IpAddresses)
         */
        default Builder ipAddresses(Consumer<IpAddresses.Builder> ipAddresses) {
            return ipAddresses(IpAddresses.builder().applyMutation(ipAddresses).build());
        }

        /**
         * <p>
         * The host name.
         * </p>
         * 
         * @param hostName
         *        The host name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * <p>
         * The ARN of the host EC2 instance.
         * </p>
         * 
         * @param ec2InstanceArn
         *        The ARN of the host EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceArn(String ec2InstanceArn);

        /**
         * <p>
         * The instance type of the host EC2 instance.
         * </p>
         * 
         * @param ec2InstanceType
         *        The instance type of the host EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceType(String ec2InstanceType);
    }

    static final class BuilderImpl implements Builder {
        private IpAddresses ipAddresses;

        private String hostName;

        private String ec2InstanceArn;

        private String ec2InstanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(HostPropertiesResponse model) {
            ipAddresses(model.ipAddresses);
            hostName(model.hostName);
            ec2InstanceArn(model.ec2InstanceArn);
            ec2InstanceType(model.ec2InstanceType);
        }

        public final IpAddresses.Builder getIpAddresses() {
            return ipAddresses != null ? ipAddresses.toBuilder() : null;
        }

        public final void setIpAddresses(IpAddresses.BuilderImpl ipAddresses) {
            this.ipAddresses = ipAddresses != null ? ipAddresses.build() : null;
        }

        @Override
        public final Builder ipAddresses(IpAddresses ipAddresses) {
            this.ipAddresses = ipAddresses;
            return this;
        }

        public final String getHostName() {
            return hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getEc2InstanceArn() {
            return ec2InstanceArn;
        }

        public final void setEc2InstanceArn(String ec2InstanceArn) {
            this.ec2InstanceArn = ec2InstanceArn;
        }

        @Override
        public final Builder ec2InstanceArn(String ec2InstanceArn) {
            this.ec2InstanceArn = ec2InstanceArn;
            return this;
        }

        public final String getEc2InstanceType() {
            return ec2InstanceType;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public HostPropertiesResponse build() {
            return new HostPropertiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
