/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The updated session action information as it relates to completion and progress of the session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatedSessionActionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdatedSessionActionInfo.Builder, UpdatedSessionActionInfo> {
    private static final SdkField<String> COMPLETED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("completedStatus").getter(getter(UpdatedSessionActionInfo::completedStatusAsString))
            .setter(setter(Builder::completedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedStatus").build()).build();

    private static final SdkField<Integer> PROCESS_EXIT_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("processExitCode").getter(getter(UpdatedSessionActionInfo::processExitCode))
            .setter(setter(Builder::processExitCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processExitCode").build()).build();

    private static final SdkField<String> PROGRESS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("progressMessage").getter(getter(UpdatedSessionActionInfo::progressMessage))
            .setter(setter(Builder::progressMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressMessage").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(UpdatedSessionActionInfo::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(UpdatedSessionActionInfo::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(UpdatedSessionActionInfo::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Float> PROGRESS_PERCENT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("progressPercent").getter(getter(UpdatedSessionActionInfo::progressPercent))
            .setter(setter(Builder::progressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercent").build()).build();

    private static final SdkField<List<TaskRunManifestPropertiesRequest>> MANIFESTS_FIELD = SdkField
            .<List<TaskRunManifestPropertiesRequest>> builder(MarshallingType.LIST)
            .memberName("manifests")
            .getter(getter(UpdatedSessionActionInfo::manifests))
            .setter(setter(Builder::manifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskRunManifestPropertiesRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskRunManifestPropertiesRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_STATUS_FIELD,
            PROCESS_EXIT_CODE_FIELD, PROGRESS_MESSAGE_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, UPDATED_AT_FIELD,
            PROGRESS_PERCENT_FIELD, MANIFESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String completedStatus;

    private final Integer processExitCode;

    private final String progressMessage;

    private final Instant startedAt;

    private final Instant endedAt;

    private final Instant updatedAt;

    private final Float progressPercent;

    private final List<TaskRunManifestPropertiesRequest> manifests;

    private UpdatedSessionActionInfo(BuilderImpl builder) {
        this.completedStatus = builder.completedStatus;
        this.processExitCode = builder.processExitCode;
        this.progressMessage = builder.progressMessage;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.updatedAt = builder.updatedAt;
        this.progressPercent = builder.progressPercent;
        this.manifests = builder.manifests;
    }

    /**
     * <p>
     * The status of the session upon completion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #completedStatus}
     * will return {@link CompletedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #completedStatusAsString}.
     * </p>
     * 
     * @return The status of the session upon completion.
     * @see CompletedStatus
     */
    public final CompletedStatus completedStatus() {
        return CompletedStatus.fromValue(completedStatus);
    }

    /**
     * <p>
     * The status of the session upon completion.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #completedStatus}
     * will return {@link CompletedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #completedStatusAsString}.
     * </p>
     * 
     * @return The status of the session upon completion.
     * @see CompletedStatus
     */
    public final String completedStatusAsString() {
        return completedStatus;
    }

    /**
     * <p>
     * The process exit code. The default Deadline Cloud worker agent converts unsigned 32-bit exit codes to signed
     * 32-bit exit codes.
     * </p>
     * 
     * @return The process exit code. The default Deadline Cloud worker agent converts unsigned 32-bit exit codes to
     *         signed 32-bit exit codes.
     */
    public final Integer processExitCode() {
        return processExitCode;
    }

    /**
     * <p>
     * A message to indicate the progress of the updated session action.
     * </p>
     * 
     * @return A message to indicate the progress of the updated session action.
     */
    public final String progressMessage() {
        return progressMessage;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The updated time.
     * </p>
     * 
     * @return The updated time.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The percentage completed.
     * </p>
     * 
     * @return The percentage completed.
     */
    public final Float progressPercent() {
        return progressPercent;
    }

    /**
     * For responses, this returns true if the service returned a value for the Manifests property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasManifests() {
        return manifests != null && !(manifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of output manifest properties reported by the worker agent, with each entry corresponding to a manifest
     * property in the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManifests} method.
     * </p>
     * 
     * @return A list of output manifest properties reported by the worker agent, with each entry corresponding to a
     *         manifest property in the job.
     */
    public final List<TaskRunManifestPropertiesRequest> manifests() {
        return manifests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(processExitCode());
        hashCode = 31 * hashCode + Objects.hashCode(progressMessage());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(hasManifests() ? manifests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatedSessionActionInfo)) {
            return false;
        }
        UpdatedSessionActionInfo other = (UpdatedSessionActionInfo) obj;
        return Objects.equals(completedStatusAsString(), other.completedStatusAsString())
                && Objects.equals(processExitCode(), other.processExitCode())
                && Objects.equals(progressMessage(), other.progressMessage()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(endedAt(), other.endedAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(progressPercent(), other.progressPercent()) && hasManifests() == other.hasManifests()
                && Objects.equals(manifests(), other.manifests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatedSessionActionInfo").add("CompletedStatus", completedStatusAsString())
                .add("ProcessExitCode", processExitCode())
                .add("ProgressMessage", progressMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StartedAt", startedAt()).add("EndedAt", endedAt()).add("UpdatedAt", updatedAt())
                .add("ProgressPercent", progressPercent()).add("Manifests", hasManifests() ? manifests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "completedStatus":
            return Optional.ofNullable(clazz.cast(completedStatusAsString()));
        case "processExitCode":
            return Optional.ofNullable(clazz.cast(processExitCode()));
        case "progressMessage":
            return Optional.ofNullable(clazz.cast(progressMessage()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "progressPercent":
            return Optional.ofNullable(clazz.cast(progressPercent()));
        case "manifests":
            return Optional.ofNullable(clazz.cast(manifests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("completedStatus", COMPLETED_STATUS_FIELD);
        map.put("processExitCode", PROCESS_EXIT_CODE_FIELD);
        map.put("progressMessage", PROGRESS_MESSAGE_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("progressPercent", PROGRESS_PERCENT_FIELD);
        map.put("manifests", MANIFESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatedSessionActionInfo, T> g) {
        return obj -> g.apply((UpdatedSessionActionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdatedSessionActionInfo> {
        /**
         * <p>
         * The status of the session upon completion.
         * </p>
         * 
         * @param completedStatus
         *        The status of the session upon completion.
         * @see CompletedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompletedStatus
         */
        Builder completedStatus(String completedStatus);

        /**
         * <p>
         * The status of the session upon completion.
         * </p>
         * 
         * @param completedStatus
         *        The status of the session upon completion.
         * @see CompletedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompletedStatus
         */
        Builder completedStatus(CompletedStatus completedStatus);

        /**
         * <p>
         * The process exit code. The default Deadline Cloud worker agent converts unsigned 32-bit exit codes to signed
         * 32-bit exit codes.
         * </p>
         * 
         * @param processExitCode
         *        The process exit code. The default Deadline Cloud worker agent converts unsigned 32-bit exit codes to
         *        signed 32-bit exit codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processExitCode(Integer processExitCode);

        /**
         * <p>
         * A message to indicate the progress of the updated session action.
         * </p>
         * 
         * @param progressMessage
         *        A message to indicate the progress of the updated session action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressMessage(String progressMessage);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The updated time.
         * </p>
         * 
         * @param updatedAt
         *        The updated time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The percentage completed.
         * </p>
         * 
         * @param progressPercent
         *        The percentage completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercent(Float progressPercent);

        /**
         * <p>
         * A list of output manifest properties reported by the worker agent, with each entry corresponding to a
         * manifest property in the job.
         * </p>
         * 
         * @param manifests
         *        A list of output manifest properties reported by the worker agent, with each entry corresponding to a
         *        manifest property in the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifests(Collection<TaskRunManifestPropertiesRequest> manifests);

        /**
         * <p>
         * A list of output manifest properties reported by the worker agent, with each entry corresponding to a
         * manifest property in the job.
         * </p>
         * 
         * @param manifests
         *        A list of output manifest properties reported by the worker agent, with each entry corresponding to a
         *        manifest property in the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifests(TaskRunManifestPropertiesRequest... manifests);

        /**
         * <p>
         * A list of output manifest properties reported by the worker agent, with each entry corresponding to a
         * manifest property in the job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.TaskRunManifestPropertiesRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.TaskRunManifestPropertiesRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.TaskRunManifestPropertiesRequest.Builder#build()} is
         * called immediately and its result is passed to {@link #manifests(List<TaskRunManifestPropertiesRequest>)}.
         * 
         * @param manifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.TaskRunManifestPropertiesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifests(java.util.Collection<TaskRunManifestPropertiesRequest>)
         */
        Builder manifests(Consumer<TaskRunManifestPropertiesRequest.Builder>... manifests);
    }

    static final class BuilderImpl implements Builder {
        private String completedStatus;

        private Integer processExitCode;

        private String progressMessage;

        private Instant startedAt;

        private Instant endedAt;

        private Instant updatedAt;

        private Float progressPercent;

        private List<TaskRunManifestPropertiesRequest> manifests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatedSessionActionInfo model) {
            completedStatus(model.completedStatus);
            processExitCode(model.processExitCode);
            progressMessage(model.progressMessage);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            updatedAt(model.updatedAt);
            progressPercent(model.progressPercent);
            manifests(model.manifests);
        }

        public final String getCompletedStatus() {
            return completedStatus;
        }

        public final void setCompletedStatus(String completedStatus) {
            this.completedStatus = completedStatus;
        }

        @Override
        public final Builder completedStatus(String completedStatus) {
            this.completedStatus = completedStatus;
            return this;
        }

        @Override
        public final Builder completedStatus(CompletedStatus completedStatus) {
            this.completedStatus(completedStatus == null ? null : completedStatus.toString());
            return this;
        }

        public final Integer getProcessExitCode() {
            return processExitCode;
        }

        public final void setProcessExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
        }

        @Override
        public final Builder processExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
            return this;
        }

        public final String getProgressMessage() {
            return progressMessage;
        }

        public final void setProgressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
        }

        @Override
        public final Builder progressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Float getProgressPercent() {
            return progressPercent;
        }

        public final void setProgressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final List<TaskRunManifestPropertiesRequest.Builder> getManifests() {
            List<TaskRunManifestPropertiesRequest.Builder> result = TaskRunManifestPropertiesListRequestCopier
                    .copyToBuilder(this.manifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManifests(Collection<TaskRunManifestPropertiesRequest.BuilderImpl> manifests) {
            this.manifests = TaskRunManifestPropertiesListRequestCopier.copyFromBuilder(manifests);
        }

        @Override
        public final Builder manifests(Collection<TaskRunManifestPropertiesRequest> manifests) {
            this.manifests = TaskRunManifestPropertiesListRequestCopier.copy(manifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manifests(TaskRunManifestPropertiesRequest... manifests) {
            manifests(Arrays.asList(manifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manifests(Consumer<TaskRunManifestPropertiesRequest.Builder>... manifests) {
            manifests(Stream.of(manifests).map(c -> TaskRunManifestPropertiesRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdatedSessionActionInfo build() {
            return new UpdatedSessionActionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
