/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.AllowedStorageProfileIdsCopier;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction;
import software.amazon.awssdk.services.deadline.model.JobAttachmentSettings;
import software.amazon.awssdk.services.deadline.model.JobRunAsUser;
import software.amazon.awssdk.services.deadline.model.RequiredFileSystemLocationNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQueueRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateQueueRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateQueueRequest.getter(UpdateQueueRequest::clientToken)).setter(UpdateQueueRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateQueueRequest.getter(UpdateQueueRequest::farmId)).setter(UpdateQueueRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(UpdateQueueRequest.getter(UpdateQueueRequest::queueId)).setter(UpdateQueueRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateQueueRequest.getter(UpdateQueueRequest::displayName)).setter(UpdateQueueRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateQueueRequest.getter(UpdateQueueRequest::description)).setter(UpdateQueueRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DEFAULT_BUDGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultBudgetAction").getter(UpdateQueueRequest.getter(UpdateQueueRequest::defaultBudgetActionAsString)).setter(UpdateQueueRequest.setter(Builder::defaultBudgetAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBudgetAction").build()}).build();
    private static final SdkField<JobAttachmentSettings> JOB_ATTACHMENT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobAttachmentSettings").getter(UpdateQueueRequest.getter(UpdateQueueRequest::jobAttachmentSettings)).setter(UpdateQueueRequest.setter(Builder::jobAttachmentSettings)).constructor(JobAttachmentSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentSettings").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateQueueRequest.getter(UpdateQueueRequest::roleArn)).setter(UpdateQueueRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<JobRunAsUser> JOB_RUN_AS_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobRunAsUser").getter(UpdateQueueRequest.getter(UpdateQueueRequest::jobRunAsUser)).setter(UpdateQueueRequest.setter(Builder::jobRunAsUser)).constructor(JobRunAsUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRunAsUser").build()}).build();
    private static final SdkField<List<String>> REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiredFileSystemLocationNamesToAdd").getter(UpdateQueueRequest.getter(UpdateQueueRequest::requiredFileSystemLocationNamesToAdd)).setter(UpdateQueueRequest.setter(Builder::requiredFileSystemLocationNamesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredFileSystemLocationNamesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiredFileSystemLocationNamesToRemove").getter(UpdateQueueRequest.getter(UpdateQueueRequest::requiredFileSystemLocationNamesToRemove)).setter(UpdateQueueRequest.setter(Builder::requiredFileSystemLocationNamesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredFileSystemLocationNamesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_STORAGE_PROFILE_IDS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedStorageProfileIdsToAdd").getter(UpdateQueueRequest.getter(UpdateQueueRequest::allowedStorageProfileIdsToAdd)).setter(UpdateQueueRequest.setter(Builder::allowedStorageProfileIdsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedStorageProfileIdsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_STORAGE_PROFILE_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedStorageProfileIdsToRemove").getter(UpdateQueueRequest.getter(UpdateQueueRequest::allowedStorageProfileIdsToRemove)).setter(UpdateQueueRequest.setter(Builder::allowedStorageProfileIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedStorageProfileIdsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, FARM_ID_FIELD, QUEUE_ID_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_BUDGET_ACTION_FIELD, JOB_ATTACHMENT_SETTINGS_FIELD, ROLE_ARN_FIELD, JOB_RUN_AS_USER_FIELD, REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_ADD_FIELD, REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_REMOVE_FIELD, ALLOWED_STORAGE_PROFILE_IDS_TO_ADD_FIELD, ALLOWED_STORAGE_PROFILE_IDS_TO_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateQueueRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String farmId;
    private final String queueId;
    private final String displayName;
    private final String description;
    private final String defaultBudgetAction;
    private final JobAttachmentSettings jobAttachmentSettings;
    private final String roleArn;
    private final JobRunAsUser jobRunAsUser;
    private final List<String> requiredFileSystemLocationNamesToAdd;
    private final List<String> requiredFileSystemLocationNamesToRemove;
    private final List<String> allowedStorageProfileIdsToAdd;
    private final List<String> allowedStorageProfileIdsToRemove;

    private UpdateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.defaultBudgetAction = builder.defaultBudgetAction;
        this.jobAttachmentSettings = builder.jobAttachmentSettings;
        this.roleArn = builder.roleArn;
        this.jobRunAsUser = builder.jobRunAsUser;
        this.requiredFileSystemLocationNamesToAdd = builder.requiredFileSystemLocationNamesToAdd;
        this.requiredFileSystemLocationNamesToRemove = builder.requiredFileSystemLocationNamesToRemove;
        this.allowedStorageProfileIdsToAdd = builder.allowedStorageProfileIdsToAdd;
        this.allowedStorageProfileIdsToRemove = builder.allowedStorageProfileIdsToRemove;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final DefaultQueueBudgetAction defaultBudgetAction() {
        return DefaultQueueBudgetAction.fromValue(this.defaultBudgetAction);
    }

    public final String defaultBudgetActionAsString() {
        return this.defaultBudgetAction;
    }

    public final JobAttachmentSettings jobAttachmentSettings() {
        return this.jobAttachmentSettings;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final JobRunAsUser jobRunAsUser() {
        return this.jobRunAsUser;
    }

    public final boolean hasRequiredFileSystemLocationNamesToAdd() {
        return this.requiredFileSystemLocationNamesToAdd != null && !(this.requiredFileSystemLocationNamesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> requiredFileSystemLocationNamesToAdd() {
        return this.requiredFileSystemLocationNamesToAdd;
    }

    public final boolean hasRequiredFileSystemLocationNamesToRemove() {
        return this.requiredFileSystemLocationNamesToRemove != null && !(this.requiredFileSystemLocationNamesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> requiredFileSystemLocationNamesToRemove() {
        return this.requiredFileSystemLocationNamesToRemove;
    }

    public final boolean hasAllowedStorageProfileIdsToAdd() {
        return this.allowedStorageProfileIdsToAdd != null && !(this.allowedStorageProfileIdsToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> allowedStorageProfileIdsToAdd() {
        return this.allowedStorageProfileIdsToAdd;
    }

    public final boolean hasAllowedStorageProfileIdsToRemove() {
        return this.allowedStorageProfileIdsToRemove != null && !(this.allowedStorageProfileIdsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> allowedStorageProfileIdsToRemove() {
        return this.allowedStorageProfileIdsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBudgetActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobAttachmentSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunAsUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredFileSystemLocationNamesToAdd() ? this.requiredFileSystemLocationNamesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredFileSystemLocationNamesToRemove() ? this.requiredFileSystemLocationNamesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedStorageProfileIdsToAdd() ? this.allowedStorageProfileIdsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedStorageProfileIdsToRemove() ? this.allowedStorageProfileIdsToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueueRequest)) {
            return false;
        }
        UpdateQueueRequest other = (UpdateQueueRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultBudgetActionAsString(), other.defaultBudgetActionAsString()) && Objects.equals(this.jobAttachmentSettings(), other.jobAttachmentSettings()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.jobRunAsUser(), other.jobRunAsUser()) && this.hasRequiredFileSystemLocationNamesToAdd() == other.hasRequiredFileSystemLocationNamesToAdd() && Objects.equals(this.requiredFileSystemLocationNamesToAdd(), other.requiredFileSystemLocationNamesToAdd()) && this.hasRequiredFileSystemLocationNamesToRemove() == other.hasRequiredFileSystemLocationNamesToRemove() && Objects.equals(this.requiredFileSystemLocationNamesToRemove(), other.requiredFileSystemLocationNamesToRemove()) && this.hasAllowedStorageProfileIdsToAdd() == other.hasAllowedStorageProfileIdsToAdd() && Objects.equals(this.allowedStorageProfileIdsToAdd(), other.allowedStorageProfileIdsToAdd()) && this.hasAllowedStorageProfileIdsToRemove() == other.hasAllowedStorageProfileIdsToRemove() && Objects.equals(this.allowedStorageProfileIdsToRemove(), other.allowedStorageProfileIdsToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQueueRequest").add("ClientToken", (Object)this.clientToken()).add("FarmId", (Object)this.farmId()).add("QueueId", (Object)this.queueId()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DefaultBudgetAction", (Object)this.defaultBudgetActionAsString()).add("JobAttachmentSettings", (Object)this.jobAttachmentSettings()).add("RoleArn", (Object)this.roleArn()).add("JobRunAsUser", (Object)this.jobRunAsUser()).add("RequiredFileSystemLocationNamesToAdd", this.hasRequiredFileSystemLocationNamesToAdd() ? this.requiredFileSystemLocationNamesToAdd() : null).add("RequiredFileSystemLocationNamesToRemove", this.hasRequiredFileSystemLocationNamesToRemove() ? this.requiredFileSystemLocationNamesToRemove() : null).add("AllowedStorageProfileIdsToAdd", this.hasAllowedStorageProfileIdsToAdd() ? this.allowedStorageProfileIdsToAdd() : null).add("AllowedStorageProfileIdsToRemove", this.hasAllowedStorageProfileIdsToRemove() ? this.allowedStorageProfileIdsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "defaultBudgetAction": {
                return Optional.ofNullable(clazz.cast(this.defaultBudgetActionAsString()));
            }
            case "jobAttachmentSettings": {
                return Optional.ofNullable(clazz.cast(this.jobAttachmentSettings()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "jobRunAsUser": {
                return Optional.ofNullable(clazz.cast(this.jobRunAsUser()));
            }
            case "requiredFileSystemLocationNamesToAdd": {
                return Optional.ofNullable(clazz.cast(this.requiredFileSystemLocationNamesToAdd()));
            }
            case "requiredFileSystemLocationNamesToRemove": {
                return Optional.ofNullable(clazz.cast(this.requiredFileSystemLocationNamesToRemove()));
            }
            case "allowedStorageProfileIdsToAdd": {
                return Optional.ofNullable(clazz.cast(this.allowedStorageProfileIdsToAdd()));
            }
            case "allowedStorageProfileIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.allowedStorageProfileIdsToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("X-Amz-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("defaultBudgetAction", DEFAULT_BUDGET_ACTION_FIELD);
        map.put("jobAttachmentSettings", JOB_ATTACHMENT_SETTINGS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("jobRunAsUser", JOB_RUN_AS_USER_FIELD);
        map.put("requiredFileSystemLocationNamesToAdd", REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_ADD_FIELD);
        map.put("requiredFileSystemLocationNamesToRemove", REQUIRED_FILE_SYSTEM_LOCATION_NAMES_TO_REMOVE_FIELD);
        map.put("allowedStorageProfileIdsToAdd", ALLOWED_STORAGE_PROFILE_IDS_TO_ADD_FIELD);
        map.put("allowedStorageProfileIdsToRemove", ALLOWED_STORAGE_PROFILE_IDS_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQueueRequest, T> g) {
        return obj -> g.apply((UpdateQueueRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String farmId;
        private String queueId;
        private String displayName;
        private String description;
        private String defaultBudgetAction;
        private JobAttachmentSettings jobAttachmentSettings;
        private String roleArn;
        private JobRunAsUser jobRunAsUser;
        private List<String> requiredFileSystemLocationNamesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> requiredFileSystemLocationNamesToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedStorageProfileIdsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedStorageProfileIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueueRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.farmId(model.farmId);
            this.queueId(model.queueId);
            this.displayName(model.displayName);
            this.description(model.description);
            this.defaultBudgetAction(model.defaultBudgetAction);
            this.jobAttachmentSettings(model.jobAttachmentSettings);
            this.roleArn(model.roleArn);
            this.jobRunAsUser(model.jobRunAsUser);
            this.requiredFileSystemLocationNamesToAdd(model.requiredFileSystemLocationNamesToAdd);
            this.requiredFileSystemLocationNamesToRemove(model.requiredFileSystemLocationNamesToRemove);
            this.allowedStorageProfileIdsToAdd(model.allowedStorageProfileIdsToAdd);
            this.allowedStorageProfileIdsToRemove(model.allowedStorageProfileIdsToRemove);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultBudgetAction() {
            return this.defaultBudgetAction;
        }

        public final void setDefaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
        }

        @Override
        public final Builder defaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
            return this;
        }

        @Override
        public final Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction) {
            this.defaultBudgetAction(defaultBudgetAction == null ? null : defaultBudgetAction.toString());
            return this;
        }

        public final JobAttachmentSettings.Builder getJobAttachmentSettings() {
            return this.jobAttachmentSettings != null ? this.jobAttachmentSettings.toBuilder() : null;
        }

        public final void setJobAttachmentSettings(JobAttachmentSettings.BuilderImpl jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings != null ? jobAttachmentSettings.build() : null;
        }

        @Override
        public final Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final JobRunAsUser.Builder getJobRunAsUser() {
            return this.jobRunAsUser != null ? this.jobRunAsUser.toBuilder() : null;
        }

        public final void setJobRunAsUser(JobRunAsUser.BuilderImpl jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser != null ? jobRunAsUser.build() : null;
        }

        @Override
        public final Builder jobRunAsUser(JobRunAsUser jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser;
            return this;
        }

        public final Collection<String> getRequiredFileSystemLocationNamesToAdd() {
            if (this.requiredFileSystemLocationNamesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredFileSystemLocationNamesToAdd;
        }

        public final void setRequiredFileSystemLocationNamesToAdd(Collection<String> requiredFileSystemLocationNamesToAdd) {
            this.requiredFileSystemLocationNamesToAdd = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNamesToAdd);
        }

        @Override
        public final Builder requiredFileSystemLocationNamesToAdd(Collection<String> requiredFileSystemLocationNamesToAdd) {
            this.requiredFileSystemLocationNamesToAdd = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNamesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFileSystemLocationNamesToAdd(String ... requiredFileSystemLocationNamesToAdd) {
            this.requiredFileSystemLocationNamesToAdd(Arrays.asList(requiredFileSystemLocationNamesToAdd));
            return this;
        }

        public final Collection<String> getRequiredFileSystemLocationNamesToRemove() {
            if (this.requiredFileSystemLocationNamesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredFileSystemLocationNamesToRemove;
        }

        public final void setRequiredFileSystemLocationNamesToRemove(Collection<String> requiredFileSystemLocationNamesToRemove) {
            this.requiredFileSystemLocationNamesToRemove = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNamesToRemove);
        }

        @Override
        public final Builder requiredFileSystemLocationNamesToRemove(Collection<String> requiredFileSystemLocationNamesToRemove) {
            this.requiredFileSystemLocationNamesToRemove = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNamesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFileSystemLocationNamesToRemove(String ... requiredFileSystemLocationNamesToRemove) {
            this.requiredFileSystemLocationNamesToRemove(Arrays.asList(requiredFileSystemLocationNamesToRemove));
            return this;
        }

        public final Collection<String> getAllowedStorageProfileIdsToAdd() {
            if (this.allowedStorageProfileIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedStorageProfileIdsToAdd;
        }

        public final void setAllowedStorageProfileIdsToAdd(Collection<String> allowedStorageProfileIdsToAdd) {
            this.allowedStorageProfileIdsToAdd = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIdsToAdd);
        }

        @Override
        public final Builder allowedStorageProfileIdsToAdd(Collection<String> allowedStorageProfileIdsToAdd) {
            this.allowedStorageProfileIdsToAdd = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedStorageProfileIdsToAdd(String ... allowedStorageProfileIdsToAdd) {
            this.allowedStorageProfileIdsToAdd(Arrays.asList(allowedStorageProfileIdsToAdd));
            return this;
        }

        public final Collection<String> getAllowedStorageProfileIdsToRemove() {
            if (this.allowedStorageProfileIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedStorageProfileIdsToRemove;
        }

        public final void setAllowedStorageProfileIdsToRemove(Collection<String> allowedStorageProfileIdsToRemove) {
            this.allowedStorageProfileIdsToRemove = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIdsToRemove);
        }

        @Override
        public final Builder allowedStorageProfileIdsToRemove(Collection<String> allowedStorageProfileIdsToRemove) {
            this.allowedStorageProfileIdsToRemove = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedStorageProfileIdsToRemove(String ... allowedStorageProfileIdsToRemove) {
            this.allowedStorageProfileIdsToRemove(Arrays.asList(allowedStorageProfileIdsToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueueRequest build() {
            return new UpdateQueueRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQueueRequest> {
        public Builder clientToken(String var1);

        public Builder farmId(String var1);

        public Builder queueId(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder defaultBudgetAction(String var1);

        public Builder defaultBudgetAction(DefaultQueueBudgetAction var1);

        public Builder jobAttachmentSettings(JobAttachmentSettings var1);

        default public Builder jobAttachmentSettings(Consumer<JobAttachmentSettings.Builder> jobAttachmentSettings) {
            return this.jobAttachmentSettings((JobAttachmentSettings)((JobAttachmentSettings.Builder)JobAttachmentSettings.builder().applyMutation(jobAttachmentSettings)).build());
        }

        public Builder roleArn(String var1);

        public Builder jobRunAsUser(JobRunAsUser var1);

        default public Builder jobRunAsUser(Consumer<JobRunAsUser.Builder> jobRunAsUser) {
            return this.jobRunAsUser((JobRunAsUser)((JobRunAsUser.Builder)JobRunAsUser.builder().applyMutation(jobRunAsUser)).build());
        }

        public Builder requiredFileSystemLocationNamesToAdd(Collection<String> var1);

        public Builder requiredFileSystemLocationNamesToAdd(String ... var1);

        public Builder requiredFileSystemLocationNamesToRemove(Collection<String> var1);

        public Builder requiredFileSystemLocationNamesToRemove(String ... var1);

        public Builder allowedStorageProfileIdsToAdd(Collection<String> var1);

        public Builder allowedStorageProfileIdsToAdd(String ... var1);

        public Builder allowedStorageProfileIdsToRemove(Collection<String> var1);

        public Builder allowedStorageProfileIdsToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

