/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFleetResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetFleetResponse.Builder, GetFleetResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(GetFleetResponse::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(GetFleetResponse::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetFleetResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetFleetResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetFleetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(GetFleetResponse::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> AUTO_SCALING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoScalingStatus").getter(getter(GetFleetResponse::autoScalingStatusAsString))
            .setter(setter(Builder::autoScalingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingStatus").build()).build();

    private static final SdkField<Integer> TARGET_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("targetWorkerCount").getter(getter(GetFleetResponse::targetWorkerCount))
            .setter(setter(Builder::targetWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetWorkerCount").build()).build();

    private static final SdkField<Integer> WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("workerCount").getter(getter(GetFleetResponse::workerCount)).setter(setter(Builder::workerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerCount").build()).build();

    private static final SdkField<Integer> MIN_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minWorkerCount").getter(getter(GetFleetResponse::minWorkerCount))
            .setter(setter(Builder::minWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minWorkerCount").build()).build();

    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxWorkerCount").getter(getter(GetFleetResponse::maxWorkerCount))
            .setter(setter(Builder::maxWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()).build();

    private static final SdkField<FleetConfiguration> CONFIGURATION_FIELD = SdkField
            .<FleetConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(GetFleetResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(FleetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<HostConfiguration> HOST_CONFIGURATION_FIELD = SdkField
            .<HostConfiguration> builder(MarshallingType.SDK_POJO).memberName("hostConfiguration")
            .getter(getter(GetFleetResponse::hostConfiguration)).setter(setter(Builder::hostConfiguration))
            .constructor(HostConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostConfiguration").build()).build();

    private static final SdkField<FleetCapabilities> CAPABILITIES_FIELD = SdkField
            .<FleetCapabilities> builder(MarshallingType.SDK_POJO).memberName("capabilities")
            .getter(getter(GetFleetResponse::capabilities)).setter(setter(Builder::capabilities))
            .constructor(FleetCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetFleetResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetFleetResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetFleetResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetFleetResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetFleetResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FARM_ID_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, AUTO_SCALING_STATUS_FIELD,
            TARGET_WORKER_COUNT_FIELD, WORKER_COUNT_FIELD, MIN_WORKER_COUNT_FIELD, MAX_WORKER_COUNT_FIELD, CONFIGURATION_FIELD,
            HOST_CONFIGURATION_FIELD, CAPABILITIES_FIELD, ROLE_ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD,
            UPDATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fleetId;

    private final String farmId;

    private final String displayName;

    private final String description;

    private final String status;

    private final String statusMessage;

    private final String autoScalingStatus;

    private final Integer targetWorkerCount;

    private final Integer workerCount;

    private final Integer minWorkerCount;

    private final Integer maxWorkerCount;

    private final FleetConfiguration configuration;

    private final HostConfiguration hostConfiguration;

    private final FleetCapabilities capabilities;

    private final String roleArn;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private GetFleetResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.farmId = builder.farmId;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.autoScalingStatus = builder.autoScalingStatus;
        this.targetWorkerCount = builder.targetWorkerCount;
        this.workerCount = builder.workerCount;
        this.minWorkerCount = builder.minWorkerCount;
        this.maxWorkerCount = builder.maxWorkerCount;
        this.configuration = builder.configuration;
        this.hostConfiguration = builder.hostConfiguration;
        this.capabilities = builder.capabilities;
        this.roleArn = builder.roleArn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The fleet ID.
     * </p>
     * 
     * @return The fleet ID.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The farm ID of the farm in the fleet.
     * </p>
     * 
     * @return The farm ID of the farm in the fleet.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The display name of the fleet.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the fleet.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description of the fleet.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The description of the fleet.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the fleet.
     * @see FleetStatus
     */
    public final FleetStatus status() {
        return FleetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FleetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the fleet.
     * @see FleetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message that communicates a suspended status of the fleet.
     * </p>
     * 
     * @return A message that communicates a suspended status of the fleet.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The Auto Scaling status of the fleet. Either <code>GROWING</code>, <code>STEADY</code>, or <code>SHRINKING</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingStatus}
     * will return {@link AutoScalingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingStatusAsString}.
     * </p>
     * 
     * @return The Auto Scaling status of the fleet. Either <code>GROWING</code>, <code>STEADY</code>, or
     *         <code>SHRINKING</code>.
     * @see AutoScalingStatus
     */
    public final AutoScalingStatus autoScalingStatus() {
        return AutoScalingStatus.fromValue(autoScalingStatus);
    }

    /**
     * <p>
     * The Auto Scaling status of the fleet. Either <code>GROWING</code>, <code>STEADY</code>, or <code>SHRINKING</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingStatus}
     * will return {@link AutoScalingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingStatusAsString}.
     * </p>
     * 
     * @return The Auto Scaling status of the fleet. Either <code>GROWING</code>, <code>STEADY</code>, or
     *         <code>SHRINKING</code>.
     * @see AutoScalingStatus
     */
    public final String autoScalingStatusAsString() {
        return autoScalingStatus;
    }

    /**
     * <p>
     * The number of target workers in the fleet.
     * </p>
     * 
     * @return The number of target workers in the fleet.
     */
    public final Integer targetWorkerCount() {
        return targetWorkerCount;
    }

    /**
     * <p>
     * The number of workers in the fleet.
     * </p>
     * 
     * @return The number of workers in the fleet.
     */
    public final Integer workerCount() {
        return workerCount;
    }

    /**
     * <p>
     * The minimum number of workers specified in the fleet.
     * </p>
     * 
     * @return The minimum number of workers specified in the fleet.
     */
    public final Integer minWorkerCount() {
        return minWorkerCount;
    }

    /**
     * <p>
     * The maximum number of workers specified in the fleet.
     * </p>
     * 
     * @return The maximum number of workers specified in the fleet.
     */
    public final Integer maxWorkerCount() {
        return maxWorkerCount;
    }

    /**
     * <p>
     * The configuration setting for the fleet.
     * </p>
     * 
     * @return The configuration setting for the fleet.
     */
    public final FleetConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The script that runs as a worker is starting up that you can use to provide additional configuration for workers
     * in your fleet.
     * </p>
     * 
     * @return The script that runs as a worker is starting up that you can use to provide additional configuration for
     *         workers in your fleet.
     */
    public final HostConfiguration hostConfiguration() {
        return hostConfiguration;
    }

    /**
     * <p>
     * Outlines what the fleet is capable of for minimums, maximums, and naming, in addition to attribute names and
     * values.
     * </p>
     * 
     * @return Outlines what the fleet is capable of for minimums, maximums, and naming, in addition to attribute names
     *         and values.
     */
    public final FleetCapabilities capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * The IAM role ARN.
     * </p>
     * 
     * @return The IAM role ARN.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(workerCount());
        hashCode = 31 * hashCode + Objects.hashCode(minWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hostConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFleetResponse)) {
            return false;
        }
        GetFleetResponse other = (GetFleetResponse) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(autoScalingStatusAsString(), other.autoScalingStatusAsString())
                && Objects.equals(targetWorkerCount(), other.targetWorkerCount())
                && Objects.equals(workerCount(), other.workerCount()) && Objects.equals(minWorkerCount(), other.minWorkerCount())
                && Objects.equals(maxWorkerCount(), other.maxWorkerCount())
                && Objects.equals(configuration(), other.configuration())
                && Objects.equals(hostConfiguration(), other.hostConfiguration())
                && Objects.equals(capabilities(), other.capabilities()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFleetResponse").add("FleetId", fleetId()).add("FarmId", farmId())
                .add("DisplayName", displayName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("AutoScalingStatus", autoScalingStatusAsString()).add("TargetWorkerCount", targetWorkerCount())
                .add("WorkerCount", workerCount()).add("MinWorkerCount", minWorkerCount())
                .add("MaxWorkerCount", maxWorkerCount()).add("Configuration", configuration())
                .add("HostConfiguration", hostConfiguration()).add("Capabilities", capabilities()).add("RoleArn", roleArn())
                .add("CreatedAt", createdAt()).add("CreatedBy", createdBy()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "autoScalingStatus":
            return Optional.ofNullable(clazz.cast(autoScalingStatusAsString()));
        case "targetWorkerCount":
            return Optional.ofNullable(clazz.cast(targetWorkerCount()));
        case "workerCount":
            return Optional.ofNullable(clazz.cast(workerCount()));
        case "minWorkerCount":
            return Optional.ofNullable(clazz.cast(minWorkerCount()));
        case "maxWorkerCount":
            return Optional.ofNullable(clazz.cast(maxWorkerCount()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "hostConfiguration":
            return Optional.ofNullable(clazz.cast(hostConfiguration()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fleetId", FLEET_ID_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("autoScalingStatus", AUTO_SCALING_STATUS_FIELD);
        map.put("targetWorkerCount", TARGET_WORKER_COUNT_FIELD);
        map.put("workerCount", WORKER_COUNT_FIELD);
        map.put("minWorkerCount", MIN_WORKER_COUNT_FIELD);
        map.put("maxWorkerCount", MAX_WORKER_COUNT_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("hostConfiguration", HOST_CONFIGURATION_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFleetResponse, T> g) {
        return obj -> g.apply((GetFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFleetResponse> {
        /**
         * <p>
         * The fleet ID.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The farm ID of the farm in the fleet.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the farm in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The display name of the fleet.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the fleet.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description of the fleet.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param description
         *        The description of the fleet.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the fleet.
         * </p>
         * 
         * @param status
         *        The status of the fleet.
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the fleet.
         * </p>
         * 
         * @param status
         *        The status of the fleet.
         * @see FleetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStatus
         */
        Builder status(FleetStatus status);

        /**
         * <p>
         * A message that communicates a suspended status of the fleet.
         * </p>
         * 
         * @param statusMessage
         *        A message that communicates a suspended status of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The Auto Scaling status of the fleet. Either <code>GROWING</code>, <code>STEADY</code>, or
         * <code>SHRINKING</code>.
         * </p>
         * 
         * @param autoScalingStatus
         *        The Auto Scaling status of the fleet. Either <code>GROWING</code>, <code>STEADY</code>, or
         *        <code>SHRINKING</code>.
         * @see AutoScalingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingStatus
         */
        Builder autoScalingStatus(String autoScalingStatus);

        /**
         * <p>
         * The Auto Scaling status of the fleet. Either <code>GROWING</code>, <code>STEADY</code>, or
         * <code>SHRINKING</code>.
         * </p>
         * 
         * @param autoScalingStatus
         *        The Auto Scaling status of the fleet. Either <code>GROWING</code>, <code>STEADY</code>, or
         *        <code>SHRINKING</code>.
         * @see AutoScalingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingStatus
         */
        Builder autoScalingStatus(AutoScalingStatus autoScalingStatus);

        /**
         * <p>
         * The number of target workers in the fleet.
         * </p>
         * 
         * @param targetWorkerCount
         *        The number of target workers in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetWorkerCount(Integer targetWorkerCount);

        /**
         * <p>
         * The number of workers in the fleet.
         * </p>
         * 
         * @param workerCount
         *        The number of workers in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerCount(Integer workerCount);

        /**
         * <p>
         * The minimum number of workers specified in the fleet.
         * </p>
         * 
         * @param minWorkerCount
         *        The minimum number of workers specified in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minWorkerCount(Integer minWorkerCount);

        /**
         * <p>
         * The maximum number of workers specified in the fleet.
         * </p>
         * 
         * @param maxWorkerCount
         *        The maximum number of workers specified in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkerCount(Integer maxWorkerCount);

        /**
         * <p>
         * The configuration setting for the fleet.
         * </p>
         * 
         * @param configuration
         *        The configuration setting for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(FleetConfiguration configuration);

        /**
         * <p>
         * The configuration setting for the fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetConfiguration.Builder} avoiding the
         * need to create one manually via {@link FleetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(FleetConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link FleetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(FleetConfiguration)
         */
        default Builder configuration(Consumer<FleetConfiguration.Builder> configuration) {
            return configuration(FleetConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The script that runs as a worker is starting up that you can use to provide additional configuration for
         * workers in your fleet.
         * </p>
         * 
         * @param hostConfiguration
         *        The script that runs as a worker is starting up that you can use to provide additional configuration
         *        for workers in your fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostConfiguration(HostConfiguration hostConfiguration);

        /**
         * <p>
         * The script that runs as a worker is starting up that you can use to provide additional configuration for
         * workers in your fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostConfiguration.Builder} avoiding the
         * need to create one manually via {@link HostConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #hostConfiguration(HostConfiguration)}.
         * 
         * @param hostConfiguration
         *        a consumer that will call methods on {@link HostConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostConfiguration(HostConfiguration)
         */
        default Builder hostConfiguration(Consumer<HostConfiguration.Builder> hostConfiguration) {
            return hostConfiguration(HostConfiguration.builder().applyMutation(hostConfiguration).build());
        }

        /**
         * <p>
         * Outlines what the fleet is capable of for minimums, maximums, and naming, in addition to attribute names and
         * values.
         * </p>
         * 
         * @param capabilities
         *        Outlines what the fleet is capable of for minimums, maximums, and naming, in addition to attribute
         *        names and values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(FleetCapabilities capabilities);

        /**
         * <p>
         * Outlines what the fleet is capable of for minimums, maximums, and naming, in addition to attribute names and
         * values.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetCapabilities.Builder} avoiding the
         * need to create one manually via {@link FleetCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetCapabilities.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilities(FleetCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link FleetCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(FleetCapabilities)
         */
        default Builder capabilities(Consumer<FleetCapabilities.Builder> capabilities) {
            return capabilities(FleetCapabilities.builder().applyMutation(capabilities).build());
        }

        /**
         * <p>
         * The IAM role ARN.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String fleetId;

        private String farmId;

        private String displayName;

        private String description;

        private String status;

        private String statusMessage;

        private String autoScalingStatus;

        private Integer targetWorkerCount;

        private Integer workerCount;

        private Integer minWorkerCount;

        private Integer maxWorkerCount;

        private FleetConfiguration configuration;

        private HostConfiguration hostConfiguration;

        private FleetCapabilities capabilities;

        private String roleArn;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFleetResponse model) {
            super(model);
            fleetId(model.fleetId);
            farmId(model.farmId);
            displayName(model.displayName);
            description(model.description);
            status(model.status);
            statusMessage(model.statusMessage);
            autoScalingStatus(model.autoScalingStatus);
            targetWorkerCount(model.targetWorkerCount);
            workerCount(model.workerCount);
            minWorkerCount(model.minWorkerCount);
            maxWorkerCount(model.maxWorkerCount);
            configuration(model.configuration);
            hostConfiguration(model.hostConfiguration);
            capabilities(model.capabilities);
            roleArn(model.roleArn);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FleetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getAutoScalingStatus() {
            return autoScalingStatus;
        }

        public final void setAutoScalingStatus(String autoScalingStatus) {
            this.autoScalingStatus = autoScalingStatus;
        }

        @Override
        public final Builder autoScalingStatus(String autoScalingStatus) {
            this.autoScalingStatus = autoScalingStatus;
            return this;
        }

        @Override
        public final Builder autoScalingStatus(AutoScalingStatus autoScalingStatus) {
            this.autoScalingStatus(autoScalingStatus == null ? null : autoScalingStatus.toString());
            return this;
        }

        public final Integer getTargetWorkerCount() {
            return targetWorkerCount;
        }

        public final void setTargetWorkerCount(Integer targetWorkerCount) {
            this.targetWorkerCount = targetWorkerCount;
        }

        @Override
        public final Builder targetWorkerCount(Integer targetWorkerCount) {
            this.targetWorkerCount = targetWorkerCount;
            return this;
        }

        public final Integer getWorkerCount() {
            return workerCount;
        }

        public final void setWorkerCount(Integer workerCount) {
            this.workerCount = workerCount;
        }

        @Override
        public final Builder workerCount(Integer workerCount) {
            this.workerCount = workerCount;
            return this;
        }

        public final Integer getMinWorkerCount() {
            return minWorkerCount;
        }

        public final void setMinWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
        }

        @Override
        public final Builder minWorkerCount(Integer minWorkerCount) {
            this.minWorkerCount = minWorkerCount;
            return this;
        }

        public final Integer getMaxWorkerCount() {
            return maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final FleetConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(FleetConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FleetConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final HostConfiguration.Builder getHostConfiguration() {
            return hostConfiguration != null ? hostConfiguration.toBuilder() : null;
        }

        public final void setHostConfiguration(HostConfiguration.BuilderImpl hostConfiguration) {
            this.hostConfiguration = hostConfiguration != null ? hostConfiguration.build() : null;
        }

        @Override
        public final Builder hostConfiguration(HostConfiguration hostConfiguration) {
            this.hostConfiguration = hostConfiguration;
            return this;
        }

        public final FleetCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(FleetCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(FleetCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public GetFleetResponse build() {
            return new GetFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
