/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueueLimitAssociationResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetQueueLimitAssociationResponse.Builder, GetQueueLimitAssociationResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetQueueLimitAssociationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetQueueLimitAssociationResponse::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetQueueLimitAssociationResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetQueueLimitAssociationResponse::updatedBy))
            .setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(GetQueueLimitAssociationResponse::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<String> LIMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("limitId").getter(getter(GetQueueLimitAssociationResponse::limitId)).setter(setter(Builder::limitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetQueueLimitAssociationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, QUEUE_ID_FIELD, LIMIT_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final String queueId;

    private final String limitId;

    private final String status;

    private GetQueueLimitAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.queueId = builder.queueId;
        this.limitId = builder.limitId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Unix timestamp of the date and time that the association was created.
     * </p>
     * 
     * @return The Unix timestamp of the date and time that the association was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user identifier of the person that created the association.
     * </p>
     * 
     * @return The user identifier of the person that created the association.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The Unix timestamp of the date and time that the association was last updated.
     * </p>
     * 
     * @return The Unix timestamp of the date and time that the association was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user identifier of the person that last updated the association.
     * </p>
     * 
     * @return The user identifier of the person that last updated the association.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The unique identifier of the queue associated with the limit.
     * </p>
     * 
     * @return The unique identifier of the queue associated with the limit.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The unique identifier of the limit associated with the queue.
     * </p>
     * 
     * @return The unique identifier of the limit associated with the queue.
     */
    public final String limitId() {
        return limitId;
    }

    /**
     * <p>
     * The current status of the limit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueLimitAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the limit.
     * @see QueueLimitAssociationStatus
     */
    public final QueueLimitAssociationStatus status() {
        return QueueLimitAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the limit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueLimitAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the limit.
     * @see QueueLimitAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(limitId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueLimitAssociationResponse)) {
            return false;
        }
        GetQueueLimitAssociationResponse other = (GetQueueLimitAssociationResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(limitId(), other.limitId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueueLimitAssociationResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).add("QueueId", queueId()).add("LimitId", limitId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "limitId":
            return Optional.ofNullable(clazz.cast(limitId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("limitId", LIMIT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueueLimitAssociationResponse, T> g) {
        return obj -> g.apply((GetQueueLimitAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetQueueLimitAssociationResponse> {
        /**
         * <p>
         * The Unix timestamp of the date and time that the association was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp of the date and time that the association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user identifier of the person that created the association.
         * </p>
         * 
         * @param createdBy
         *        The user identifier of the person that created the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The Unix timestamp of the date and time that the association was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp of the date and time that the association was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user identifier of the person that last updated the association.
         * </p>
         * 
         * @param updatedBy
         *        The user identifier of the person that last updated the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The unique identifier of the queue associated with the limit.
         * </p>
         * 
         * @param queueId
         *        The unique identifier of the queue associated with the limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The unique identifier of the limit associated with the queue.
         * </p>
         * 
         * @param limitId
         *        The unique identifier of the limit associated with the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitId(String limitId);

        /**
         * <p>
         * The current status of the limit.
         * </p>
         * 
         * @param status
         *        The current status of the limit.
         * @see QueueLimitAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueLimitAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the limit.
         * </p>
         * 
         * @param status
         *        The current status of the limit.
         * @see QueueLimitAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueLimitAssociationStatus
         */
        Builder status(QueueLimitAssociationStatus status);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private String queueId;

        private String limitId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueLimitAssociationResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            queueId(model.queueId);
            limitId(model.limitId);
            status(model.status);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getLimitId() {
            return limitId;
        }

        public final void setLimitId(String limitId) {
            this.limitId = limitId;
        }

        @Override
        public final Builder limitId(String limitId) {
            this.limitId = limitId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueLimitAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetQueueLimitAssociationResponse build() {
            return new GetQueueLimitAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
