/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a script that runs as a worker is starting up that you can use to provide additional configuration for
 * workers in your fleet.
 * </p>
 * <p>
 * To remove a script from a fleet, use the <a
 * href="https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_UpdateFleet.html">UpdateFleet</a> operation
 * with the <code>hostConfiguration</code> <code>scriptBody</code> parameter set to an empty string ("").
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HostConfiguration.Builder, HostConfiguration> {
    private static final SdkField<String> SCRIPT_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scriptBody").getter(getter(HostConfiguration::scriptBody)).setter(setter(Builder::scriptBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptBody").build()).build();

    private static final SdkField<Integer> SCRIPT_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("scriptTimeoutSeconds").getter(getter(HostConfiguration::scriptTimeoutSeconds))
            .setter(setter(Builder::scriptTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptTimeoutSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_BODY_FIELD,
            SCRIPT_TIMEOUT_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scriptBody;

    private final Integer scriptTimeoutSeconds;

    private HostConfiguration(BuilderImpl builder) {
        this.scriptBody = builder.scriptBody;
        this.scriptTimeoutSeconds = builder.scriptTimeoutSeconds;
    }

    /**
     * <p>
     * The text of the script that runs as a worker is starting up that you can use to provide additional configuration
     * for workers in your fleet. The script runs after a worker enters the <code>STARTING</code> state and before the
     * worker processes tasks.
     * </p>
     * <p>
     * For more information about using the script, see <a
     * href="https://docs.aws.amazon.com/deadline-cloud/latest/developerguide/smf-admin.html">Run scripts as an
     * administrator to configure workers</a> in the <i>Deadline Cloud Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * The script runs as an administrative user (<code>sudo root</code> on Linux, as an Administrator on Windows).
     * </p>
     * </important>
     * 
     * @return The text of the script that runs as a worker is starting up that you can use to provide additional
     *         configuration for workers in your fleet. The script runs after a worker enters the <code>STARTING</code>
     *         state and before the worker processes tasks.</p>
     *         <p>
     *         For more information about using the script, see <a
     *         href="https://docs.aws.amazon.com/deadline-cloud/latest/developerguide/smf-admin.html">Run scripts as an
     *         administrator to configure workers</a> in the <i>Deadline Cloud Developer Guide</i>.
     *         </p>
     *         <important>
     *         <p>
     *         The script runs as an administrative user (<code>sudo root</code> on Linux, as an Administrator on
     *         Windows).
     *         </p>
     */
    public final String scriptBody() {
        return scriptBody;
    }

    /**
     * <p>
     * The maximum time that the host configuration can run. If the timeout expires, the worker enters the
     * <code>NOT RESPONDING</code> state and shuts down. You are charged for the time that the worker is running the
     * host configuration script.
     * </p>
     * <note>
     * <p>
     * You should configure your fleet for a maximum of one worker while testing your host configuration script to avoid
     * starting additional workers.
     * </p>
     * </note>
     * <p>
     * The default is 300 seconds (5 minutes).
     * </p>
     * 
     * @return The maximum time that the host configuration can run. If the timeout expires, the worker enters the
     *         <code>NOT RESPONDING</code> state and shuts down. You are charged for the time that the worker is running
     *         the host configuration script.</p> <note>
     *         <p>
     *         You should configure your fleet for a maximum of one worker while testing your host configuration script
     *         to avoid starting additional workers.
     *         </p>
     *         </note>
     *         <p>
     *         The default is 300 seconds (5 minutes).
     */
    public final Integer scriptTimeoutSeconds() {
        return scriptTimeoutSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scriptBody());
        hashCode = 31 * hashCode + Objects.hashCode(scriptTimeoutSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostConfiguration)) {
            return false;
        }
        HostConfiguration other = (HostConfiguration) obj;
        return Objects.equals(scriptBody(), other.scriptBody())
                && Objects.equals(scriptTimeoutSeconds(), other.scriptTimeoutSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostConfiguration")
                .add("ScriptBody", scriptBody() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ScriptTimeoutSeconds", scriptTimeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scriptBody":
            return Optional.ofNullable(clazz.cast(scriptBody()));
        case "scriptTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(scriptTimeoutSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scriptBody", SCRIPT_BODY_FIELD);
        map.put("scriptTimeoutSeconds", SCRIPT_TIMEOUT_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostConfiguration, T> g) {
        return obj -> g.apply((HostConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostConfiguration> {
        /**
         * <p>
         * The text of the script that runs as a worker is starting up that you can use to provide additional
         * configuration for workers in your fleet. The script runs after a worker enters the <code>STARTING</code>
         * state and before the worker processes tasks.
         * </p>
         * <p>
         * For more information about using the script, see <a
         * href="https://docs.aws.amazon.com/deadline-cloud/latest/developerguide/smf-admin.html">Run scripts as an
         * administrator to configure workers</a> in the <i>Deadline Cloud Developer Guide</i>.
         * </p>
         * <important>
         * <p>
         * The script runs as an administrative user (<code>sudo root</code> on Linux, as an Administrator on Windows).
         * </p>
         * </important>
         * 
         * @param scriptBody
         *        The text of the script that runs as a worker is starting up that you can use to provide additional
         *        configuration for workers in your fleet. The script runs after a worker enters the
         *        <code>STARTING</code> state and before the worker processes tasks.</p>
         *        <p>
         *        For more information about using the script, see <a
         *        href="https://docs.aws.amazon.com/deadline-cloud/latest/developerguide/smf-admin.html">Run scripts as
         *        an administrator to configure workers</a> in the <i>Deadline Cloud Developer Guide</i>.
         *        </p>
         *        <important>
         *        <p>
         *        The script runs as an administrative user (<code>sudo root</code> on Linux, as an Administrator on
         *        Windows).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptBody(String scriptBody);

        /**
         * <p>
         * The maximum time that the host configuration can run. If the timeout expires, the worker enters the
         * <code>NOT RESPONDING</code> state and shuts down. You are charged for the time that the worker is running the
         * host configuration script.
         * </p>
         * <note>
         * <p>
         * You should configure your fleet for a maximum of one worker while testing your host configuration script to
         * avoid starting additional workers.
         * </p>
         * </note>
         * <p>
         * The default is 300 seconds (5 minutes).
         * </p>
         * 
         * @param scriptTimeoutSeconds
         *        The maximum time that the host configuration can run. If the timeout expires, the worker enters the
         *        <code>NOT RESPONDING</code> state and shuts down. You are charged for the time that the worker is
         *        running the host configuration script.</p> <note>
         *        <p>
         *        You should configure your fleet for a maximum of one worker while testing your host configuration
         *        script to avoid starting additional workers.
         *        </p>
         *        </note>
         *        <p>
         *        The default is 300 seconds (5 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptTimeoutSeconds(Integer scriptTimeoutSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String scriptBody;

        private Integer scriptTimeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HostConfiguration model) {
            scriptBody(model.scriptBody);
            scriptTimeoutSeconds(model.scriptTimeoutSeconds);
        }

        public final String getScriptBody() {
            return scriptBody;
        }

        public final void setScriptBody(String scriptBody) {
            this.scriptBody = scriptBody;
        }

        @Override
        public final Builder scriptBody(String scriptBody) {
            this.scriptBody = scriptBody;
            return this;
        }

        public final Integer getScriptTimeoutSeconds() {
            return scriptTimeoutSeconds;
        }

        public final void setScriptTimeoutSeconds(Integer scriptTimeoutSeconds) {
            this.scriptTimeoutSeconds = scriptTimeoutSeconds;
        }

        @Override
        public final Builder scriptTimeoutSeconds(Integer scriptTimeoutSeconds) {
            this.scriptTimeoutSeconds = scriptTimeoutSeconds;
            return this;
        }

        @Override
        public HostConfiguration build() {
            return new HostConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
