/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a job entity identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobEntityIdentifiersUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<JobEntityIdentifiersUnion.Builder, JobEntityIdentifiersUnion> {
    private static final SdkField<JobDetailsIdentifiers> JOB_DETAILS_FIELD = SdkField
            .<JobDetailsIdentifiers> builder(MarshallingType.SDK_POJO).memberName("jobDetails")
            .getter(getter(JobEntityIdentifiersUnion::jobDetails)).setter(setter(Builder::jobDetails))
            .constructor(JobDetailsIdentifiers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()).build();

    private static final SdkField<JobAttachmentDetailsIdentifiers> JOB_ATTACHMENT_DETAILS_FIELD = SdkField
            .<JobAttachmentDetailsIdentifiers> builder(MarshallingType.SDK_POJO).memberName("jobAttachmentDetails")
            .getter(getter(JobEntityIdentifiersUnion::jobAttachmentDetails)).setter(setter(Builder::jobAttachmentDetails))
            .constructor(JobAttachmentDetailsIdentifiers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentDetails").build())
            .build();

    private static final SdkField<StepDetailsIdentifiers> STEP_DETAILS_FIELD = SdkField
            .<StepDetailsIdentifiers> builder(MarshallingType.SDK_POJO).memberName("stepDetails")
            .getter(getter(JobEntityIdentifiersUnion::stepDetails)).setter(setter(Builder::stepDetails))
            .constructor(StepDetailsIdentifiers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepDetails").build()).build();

    private static final SdkField<EnvironmentDetailsIdentifiers> ENVIRONMENT_DETAILS_FIELD = SdkField
            .<EnvironmentDetailsIdentifiers> builder(MarshallingType.SDK_POJO).memberName("environmentDetails")
            .getter(getter(JobEntityIdentifiersUnion::environmentDetails)).setter(setter(Builder::environmentDetails))
            .constructor(EnvironmentDetailsIdentifiers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DETAILS_FIELD,
            JOB_ATTACHMENT_DETAILS_FIELD, STEP_DETAILS_FIELD, ENVIRONMENT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final JobDetailsIdentifiers jobDetails;

    private final JobAttachmentDetailsIdentifiers jobAttachmentDetails;

    private final StepDetailsIdentifiers stepDetails;

    private final EnvironmentDetailsIdentifiers environmentDetails;

    private final Type type;

    private JobEntityIdentifiersUnion(BuilderImpl builder) {
        this.jobDetails = builder.jobDetails;
        this.jobAttachmentDetails = builder.jobAttachmentDetails;
        this.stepDetails = builder.stepDetails;
        this.environmentDetails = builder.environmentDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The job details.
     * </p>
     * 
     * @return The job details.
     */
    public final JobDetailsIdentifiers jobDetails() {
        return jobDetails;
    }

    /**
     * <p>
     * The job attachment details.
     * </p>
     * 
     * @return The job attachment details.
     */
    public final JobAttachmentDetailsIdentifiers jobAttachmentDetails() {
        return jobAttachmentDetails;
    }

    /**
     * <p>
     * The step details.
     * </p>
     * 
     * @return The step details.
     */
    public final StepDetailsIdentifiers stepDetails() {
        return stepDetails;
    }

    /**
     * <p>
     * The environment details.
     * </p>
     * 
     * @return The environment details.
     */
    public final EnvironmentDetailsIdentifiers environmentDetails() {
        return environmentDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(jobAttachmentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(environmentDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobEntityIdentifiersUnion)) {
            return false;
        }
        JobEntityIdentifiersUnion other = (JobEntityIdentifiersUnion) obj;
        return Objects.equals(jobDetails(), other.jobDetails())
                && Objects.equals(jobAttachmentDetails(), other.jobAttachmentDetails())
                && Objects.equals(stepDetails(), other.stepDetails())
                && Objects.equals(environmentDetails(), other.environmentDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobEntityIdentifiersUnion").add("JobDetails", jobDetails())
                .add("JobAttachmentDetails", jobAttachmentDetails()).add("StepDetails", stepDetails())
                .add("EnvironmentDetails", environmentDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobDetails":
            return Optional.ofNullable(clazz.cast(jobDetails()));
        case "jobAttachmentDetails":
            return Optional.ofNullable(clazz.cast(jobAttachmentDetails()));
        case "stepDetails":
            return Optional.ofNullable(clazz.cast(stepDetails()));
        case "environmentDetails":
            return Optional.ofNullable(clazz.cast(environmentDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #jobDetails()} initialized to the given value.
     *
     * <p>
     * The job details.
     * </p>
     * 
     * @param jobDetails
     *        The job details.
     */
    public static JobEntityIdentifiersUnion fromJobDetails(JobDetailsIdentifiers jobDetails) {
        return builder().jobDetails(jobDetails).build();
    }

    /**
     * Create an instance of this class with {@link #jobDetails()} initialized to the given value.
     *
     * <p>
     * The job details.
     * </p>
     * 
     * @param jobDetails
     *        The job details.
     */
    public static JobEntityIdentifiersUnion fromJobDetails(Consumer<JobDetailsIdentifiers.Builder> jobDetails) {
        JobDetailsIdentifiers.Builder builder = JobDetailsIdentifiers.builder();
        jobDetails.accept(builder);
        return fromJobDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #jobAttachmentDetails()} initialized to the given value.
     *
     * <p>
     * The job attachment details.
     * </p>
     * 
     * @param jobAttachmentDetails
     *        The job attachment details.
     */
    public static JobEntityIdentifiersUnion fromJobAttachmentDetails(JobAttachmentDetailsIdentifiers jobAttachmentDetails) {
        return builder().jobAttachmentDetails(jobAttachmentDetails).build();
    }

    /**
     * Create an instance of this class with {@link #jobAttachmentDetails()} initialized to the given value.
     *
     * <p>
     * The job attachment details.
     * </p>
     * 
     * @param jobAttachmentDetails
     *        The job attachment details.
     */
    public static JobEntityIdentifiersUnion fromJobAttachmentDetails(
            Consumer<JobAttachmentDetailsIdentifiers.Builder> jobAttachmentDetails) {
        JobAttachmentDetailsIdentifiers.Builder builder = JobAttachmentDetailsIdentifiers.builder();
        jobAttachmentDetails.accept(builder);
        return fromJobAttachmentDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stepDetails()} initialized to the given value.
     *
     * <p>
     * The step details.
     * </p>
     * 
     * @param stepDetails
     *        The step details.
     */
    public static JobEntityIdentifiersUnion fromStepDetails(StepDetailsIdentifiers stepDetails) {
        return builder().stepDetails(stepDetails).build();
    }

    /**
     * Create an instance of this class with {@link #stepDetails()} initialized to the given value.
     *
     * <p>
     * The step details.
     * </p>
     * 
     * @param stepDetails
     *        The step details.
     */
    public static JobEntityIdentifiersUnion fromStepDetails(Consumer<StepDetailsIdentifiers.Builder> stepDetails) {
        StepDetailsIdentifiers.Builder builder = StepDetailsIdentifiers.builder();
        stepDetails.accept(builder);
        return fromStepDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #environmentDetails()} initialized to the given value.
     *
     * <p>
     * The environment details.
     * </p>
     * 
     * @param environmentDetails
     *        The environment details.
     */
    public static JobEntityIdentifiersUnion fromEnvironmentDetails(EnvironmentDetailsIdentifiers environmentDetails) {
        return builder().environmentDetails(environmentDetails).build();
    }

    /**
     * Create an instance of this class with {@link #environmentDetails()} initialized to the given value.
     *
     * <p>
     * The environment details.
     * </p>
     * 
     * @param environmentDetails
     *        The environment details.
     */
    public static JobEntityIdentifiersUnion fromEnvironmentDetails(
            Consumer<EnvironmentDetailsIdentifiers.Builder> environmentDetails) {
        EnvironmentDetailsIdentifiers.Builder builder = EnvironmentDetailsIdentifiers.builder();
        environmentDetails.accept(builder);
        return fromEnvironmentDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobDetails", JOB_DETAILS_FIELD);
        map.put("jobAttachmentDetails", JOB_ATTACHMENT_DETAILS_FIELD);
        map.put("stepDetails", STEP_DETAILS_FIELD);
        map.put("environmentDetails", ENVIRONMENT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobEntityIdentifiersUnion, T> g) {
        return obj -> g.apply((JobEntityIdentifiersUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobEntityIdentifiersUnion> {
        /**
         * <p>
         * The job details.
         * </p>
         * 
         * @param jobDetails
         *        The job details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDetails(JobDetailsIdentifiers jobDetails);

        /**
         * <p>
         * The job details.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobDetailsIdentifiers.Builder} avoiding
         * the need to create one manually via {@link JobDetailsIdentifiers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobDetailsIdentifiers.Builder#build()} is called immediately and
         * its result is passed to {@link #jobDetails(JobDetailsIdentifiers)}.
         * 
         * @param jobDetails
         *        a consumer that will call methods on {@link JobDetailsIdentifiers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDetails(JobDetailsIdentifiers)
         */
        default Builder jobDetails(Consumer<JobDetailsIdentifiers.Builder> jobDetails) {
            return jobDetails(JobDetailsIdentifiers.builder().applyMutation(jobDetails).build());
        }

        /**
         * <p>
         * The job attachment details.
         * </p>
         * 
         * @param jobAttachmentDetails
         *        The job attachment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobAttachmentDetails(JobAttachmentDetailsIdentifiers jobAttachmentDetails);

        /**
         * <p>
         * The job attachment details.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobAttachmentDetailsIdentifiers.Builder}
         * avoiding the need to create one manually via {@link JobAttachmentDetailsIdentifiers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobAttachmentDetailsIdentifiers.Builder#build()} is called
         * immediately and its result is passed to {@link #jobAttachmentDetails(JobAttachmentDetailsIdentifiers)}.
         * 
         * @param jobAttachmentDetails
         *        a consumer that will call methods on {@link JobAttachmentDetailsIdentifiers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobAttachmentDetails(JobAttachmentDetailsIdentifiers)
         */
        default Builder jobAttachmentDetails(Consumer<JobAttachmentDetailsIdentifiers.Builder> jobAttachmentDetails) {
            return jobAttachmentDetails(JobAttachmentDetailsIdentifiers.builder().applyMutation(jobAttachmentDetails).build());
        }

        /**
         * <p>
         * The step details.
         * </p>
         * 
         * @param stepDetails
         *        The step details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepDetails(StepDetailsIdentifiers stepDetails);

        /**
         * <p>
         * The step details.
         * </p>
         * This is a convenience method that creates an instance of the {@link StepDetailsIdentifiers.Builder} avoiding
         * the need to create one manually via {@link StepDetailsIdentifiers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StepDetailsIdentifiers.Builder#build()} is called immediately and
         * its result is passed to {@link #stepDetails(StepDetailsIdentifiers)}.
         * 
         * @param stepDetails
         *        a consumer that will call methods on {@link StepDetailsIdentifiers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepDetails(StepDetailsIdentifiers)
         */
        default Builder stepDetails(Consumer<StepDetailsIdentifiers.Builder> stepDetails) {
            return stepDetails(StepDetailsIdentifiers.builder().applyMutation(stepDetails).build());
        }

        /**
         * <p>
         * The environment details.
         * </p>
         * 
         * @param environmentDetails
         *        The environment details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentDetails(EnvironmentDetailsIdentifiers environmentDetails);

        /**
         * <p>
         * The environment details.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentDetailsIdentifiers.Builder}
         * avoiding the need to create one manually via {@link EnvironmentDetailsIdentifiers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentDetailsIdentifiers.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentDetails(EnvironmentDetailsIdentifiers)}.
         * 
         * @param environmentDetails
         *        a consumer that will call methods on {@link EnvironmentDetailsIdentifiers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentDetails(EnvironmentDetailsIdentifiers)
         */
        default Builder environmentDetails(Consumer<EnvironmentDetailsIdentifiers.Builder> environmentDetails) {
            return environmentDetails(EnvironmentDetailsIdentifiers.builder().applyMutation(environmentDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JobDetailsIdentifiers jobDetails;

        private JobAttachmentDetailsIdentifiers jobAttachmentDetails;

        private StepDetailsIdentifiers stepDetails;

        private EnvironmentDetailsIdentifiers environmentDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobEntityIdentifiersUnion model) {
            jobDetails(model.jobDetails);
            jobAttachmentDetails(model.jobAttachmentDetails);
            stepDetails(model.stepDetails);
            environmentDetails(model.environmentDetails);
        }

        public final JobDetailsIdentifiers.Builder getJobDetails() {
            return jobDetails != null ? jobDetails.toBuilder() : null;
        }

        public final void setJobDetails(JobDetailsIdentifiers.BuilderImpl jobDetails) {
            Object oldValue = this.jobDetails;
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
            handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
        }

        @Override
        public final Builder jobDetails(JobDetailsIdentifiers jobDetails) {
            Object oldValue = this.jobDetails;
            this.jobDetails = jobDetails;
            handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
            return this;
        }

        public final JobAttachmentDetailsIdentifiers.Builder getJobAttachmentDetails() {
            return jobAttachmentDetails != null ? jobAttachmentDetails.toBuilder() : null;
        }

        public final void setJobAttachmentDetails(JobAttachmentDetailsIdentifiers.BuilderImpl jobAttachmentDetails) {
            Object oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails != null ? jobAttachmentDetails.build() : null;
            handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
        }

        @Override
        public final Builder jobAttachmentDetails(JobAttachmentDetailsIdentifiers jobAttachmentDetails) {
            Object oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails;
            handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
            return this;
        }

        public final StepDetailsIdentifiers.Builder getStepDetails() {
            return stepDetails != null ? stepDetails.toBuilder() : null;
        }

        public final void setStepDetails(StepDetailsIdentifiers.BuilderImpl stepDetails) {
            Object oldValue = this.stepDetails;
            this.stepDetails = stepDetails != null ? stepDetails.build() : null;
            handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
        }

        @Override
        public final Builder stepDetails(StepDetailsIdentifiers stepDetails) {
            Object oldValue = this.stepDetails;
            this.stepDetails = stepDetails;
            handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
            return this;
        }

        public final EnvironmentDetailsIdentifiers.Builder getEnvironmentDetails() {
            return environmentDetails != null ? environmentDetails.toBuilder() : null;
        }

        public final void setEnvironmentDetails(EnvironmentDetailsIdentifiers.BuilderImpl environmentDetails) {
            Object oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails != null ? environmentDetails.build() : null;
            handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
        }

        @Override
        public final Builder environmentDetails(EnvironmentDetailsIdentifiers environmentDetails) {
            Object oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails;
            handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
            return this;
        }

        @Override
        public JobEntityIdentifiersUnion build() {
            return new JobEntityIdentifiersUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see JobEntityIdentifiersUnion#type()
     */
    public enum Type {
        JOB_DETAILS,

        JOB_ATTACHMENT_DETAILS,

        STEP_DETAILS,

        ENVIRONMENT_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
