/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of job details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobSummary implements SdkPojo, Serializable, ToCopyableBuilder<JobSummary.Builder, JobSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(JobSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(JobSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatus").getter(getter(JobSummary::lifecycleStatusAsString))
            .setter(setter(Builder::lifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatusMessage").getter(getter(JobSummary::lifecycleStatusMessage))
            .setter(setter(Builder::lifecycleStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatusMessage").build())
            .build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(JobSummary::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(JobSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(JobSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(JobSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(JobSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(JobSummary::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(JobSummary::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRunStatus").getter(getter(JobSummary::taskRunStatusAsString)).setter(setter(Builder::taskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatus").build()).build();

    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetTaskRunStatus").getter(getter(JobSummary::targetTaskRunStatusAsString))
            .setter(setter(Builder::targetTaskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build())
            .build();

    private static final SdkField<Map<String, Integer>> TASK_RUN_STATUS_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("taskRunStatusCounts")
            .getter(getter(JobSummary::taskRunStatusCountsAsStrings))
            .setter(setter(Builder::taskRunStatusCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatusCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> TASK_FAILURE_RETRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("taskFailureRetryCount").getter(getter(JobSummary::taskFailureRetryCount))
            .setter(setter(Builder::taskFailureRetryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskFailureRetryCount").build())
            .build();

    private static final SdkField<Integer> MAX_FAILED_TASKS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxFailedTasksCount").getter(getter(JobSummary::maxFailedTasksCount))
            .setter(setter(Builder::maxFailedTasksCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailedTasksCount").build())
            .build();

    private static final SdkField<Integer> MAX_RETRIES_PER_TASK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRetriesPerTask").getter(getter(JobSummary::maxRetriesPerTask))
            .setter(setter(Builder::maxRetriesPerTask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetriesPerTask").build()).build();

    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxWorkerCount").getter(getter(JobSummary::maxWorkerCount)).setter(setter(Builder::maxWorkerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()).build();

    private static final SdkField<String> SOURCE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceJobId").getter(getter(JobSummary::sourceJobId)).setter(setter(Builder::sourceJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceJobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, NAME_FIELD,
            LIFECYCLE_STATUS_FIELD, LIFECYCLE_STATUS_MESSAGE_FIELD, PRIORITY_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD,
            UPDATED_AT_FIELD, UPDATED_BY_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, TASK_RUN_STATUS_FIELD,
            TARGET_TASK_RUN_STATUS_FIELD, TASK_RUN_STATUS_COUNTS_FIELD, TASK_FAILURE_RETRY_COUNT_FIELD,
            MAX_FAILED_TASKS_COUNT_FIELD, MAX_RETRIES_PER_TASK_FIELD, MAX_WORKER_COUNT_FIELD, SOURCE_JOB_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String name;

    private final String lifecycleStatus;

    private final String lifecycleStatusMessage;

    private final Integer priority;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final Instant startedAt;

    private final Instant endedAt;

    private final String taskRunStatus;

    private final String targetTaskRunStatus;

    private final Map<String, Integer> taskRunStatusCounts;

    private final Integer taskFailureRetryCount;

    private final Integer maxFailedTasksCount;

    private final Integer maxRetriesPerTask;

    private final Integer maxWorkerCount;

    private final String sourceJobId;

    private JobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.name = builder.name;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.lifecycleStatusMessage = builder.lifecycleStatusMessage;
        this.priority = builder.priority;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.taskRunStatus = builder.taskRunStatus;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.taskRunStatusCounts = builder.taskRunStatusCounts;
        this.taskFailureRetryCount = builder.taskFailureRetryCount;
        this.maxFailedTasksCount = builder.maxFailedTasksCount;
        this.maxRetriesPerTask = builder.maxRetriesPerTask;
        this.maxWorkerCount = builder.maxWorkerCount;
        this.sourceJobId = builder.sourceJobId;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @return The job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The job name.
     * </p>
     * 
     * @return The job name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The life cycle status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link JobLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status.
     * @see JobLifecycleStatus
     */
    public final JobLifecycleStatus lifecycleStatus() {
        return JobLifecycleStatus.fromValue(lifecycleStatus);
    }

    /**
     * <p>
     * The life cycle status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link JobLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status.
     * @see JobLifecycleStatus
     */
    public final String lifecycleStatusAsString() {
        return lifecycleStatus;
    }

    /**
     * <p>
     * The life cycle status message.
     * </p>
     * 
     * @return The life cycle status message.
     */
    public final String lifecycleStatusMessage() {
        return lifecycleStatusMessage;
    }

    /**
     * <p>
     * The job priority.
     * </p>
     * 
     * @return The job priority.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The task run status for the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>–pending and waiting for resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code>–ready to be processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSIGNED</code>–assigned and will run next on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULED</code>–scheduled to be run on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERRUPTING</code>–being interrupted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>–running on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code>–the task is suspended.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELED</code>–the task has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>–the task has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>–the task has succeeded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunStatus}
     * will return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunStatusAsString}.
     * </p>
     * 
     * @return The task run status for the job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>–pending and waiting for resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code>–ready to be processed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSIGNED</code>–assigned and will run next on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULED</code>–scheduled to be run on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERRUPTING</code>–being interrupted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>–running on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code>–the task is suspended.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELED</code>–the task has been canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>–the task has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>–the task has succeeded.
     *         </p>
     *         </li>
     * @see TaskRunStatus
     */
    public final TaskRunStatus taskRunStatus() {
        return TaskRunStatus.fromValue(taskRunStatus);
    }

    /**
     * <p>
     * The task run status for the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>–pending and waiting for resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code>–ready to be processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSIGNED</code>–assigned and will run next on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULED</code>–scheduled to be run on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERRUPTING</code>–being interrupted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>–running on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code>–the task is suspended.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELED</code>–the task has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>–the task has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>–the task has succeeded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunStatus}
     * will return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunStatusAsString}.
     * </p>
     * 
     * @return The task run status for the job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>–pending and waiting for resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code>–ready to be processed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSIGNED</code>–assigned and will run next on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULED</code>–scheduled to be run on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERRUPTING</code>–being interrupted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>–running on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code>–the task is suspended.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELED</code>–the task has been canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>–the task has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>–the task has succeeded.
     *         </p>
     *         </li>
     * @see TaskRunStatus
     */
    public final String taskRunStatusAsString() {
        return taskRunStatus;
    }

    /**
     * <p>
     * The task status to start with on the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link JobTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status to start with on the job.
     * @see JobTargetTaskRunStatus
     */
    public final JobTargetTaskRunStatus targetTaskRunStatus() {
        return JobTargetTaskRunStatus.fromValue(targetTaskRunStatus);
    }

    /**
     * <p>
     * The task status to start with on the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link JobTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status to start with on the job.
     * @see JobTargetTaskRunStatus
     */
    public final String targetTaskRunStatusAsString() {
        return targetTaskRunStatus;
    }

    /**
     * <p>
     * The number of tasks running on the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskRunStatusCounts} method.
     * </p>
     * 
     * @return The number of tasks running on the job.
     */
    public final Map<TaskRunStatus, Integer> taskRunStatusCounts() {
        return TaskRunStatusCountsCopier.copyStringToEnum(taskRunStatusCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskRunStatusCounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskRunStatusCounts() {
        return taskRunStatusCounts != null && !(taskRunStatusCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of tasks running on the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskRunStatusCounts} method.
     * </p>
     * 
     * @return The number of tasks running on the job.
     */
    public final Map<String, Integer> taskRunStatusCountsAsStrings() {
        return taskRunStatusCounts;
    }

    /**
     * <p>
     * The total number of times tasks from the job failed and were retried.
     * </p>
     * 
     * @return The total number of times tasks from the job failed and were retried.
     */
    public final Integer taskFailureRetryCount() {
        return taskFailureRetryCount;
    }

    /**
     * <p>
     * The number of task failures before the job stops running and is marked as <code>FAILED</code>.
     * </p>
     * 
     * @return The number of task failures before the job stops running and is marked as <code>FAILED</code>.
     */
    public final Integer maxFailedTasksCount() {
        return maxFailedTasksCount;
    }

    /**
     * <p>
     * The maximum number of retries for a job.
     * </p>
     * 
     * @return The maximum number of retries for a job.
     */
    public final Integer maxRetriesPerTask() {
        return maxRetriesPerTask;
    }

    /**
     * <p>
     * The maximum number of worker hosts that can concurrently process a job. When the <code>maxWorkerCount</code> is
     * reached, no more workers will be assigned to process the job, even if the fleets assigned to the job's queue has
     * available workers.
     * </p>
     * <p>
     * You can't set the <code>maxWorkerCount</code> to 0. If you set it to -1, there is no maximum number of workers.
     * </p>
     * <p>
     * If you don't specify the <code>maxWorkerCount</code>, the default is -1.
     * </p>
     * 
     * @return The maximum number of worker hosts that can concurrently process a job. When the
     *         <code>maxWorkerCount</code> is reached, no more workers will be assigned to process the job, even if the
     *         fleets assigned to the job's queue has available workers.</p>
     *         <p>
     *         You can't set the <code>maxWorkerCount</code> to 0. If you set it to -1, there is no maximum number of
     *         workers.
     *         </p>
     *         <p>
     *         If you don't specify the <code>maxWorkerCount</code>, the default is -1.
     */
    public final Integer maxWorkerCount() {
        return maxWorkerCount;
    }

    /**
     * <p>
     * The job ID for the source job.
     * </p>
     * 
     * @return The job ID for the source job.
     */
    public final String sourceJobId() {
        return sourceJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(taskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskRunStatusCounts() ? taskRunStatusCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskFailureRetryCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxFailedTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetriesPerTask());
        hashCode = 31 * hashCode + Objects.hashCode(maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(sourceJobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(name(), other.name())
                && Objects.equals(lifecycleStatusAsString(), other.lifecycleStatusAsString())
                && Objects.equals(lifecycleStatusMessage(), other.lifecycleStatusMessage())
                && Objects.equals(priority(), other.priority()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(taskRunStatusAsString(), other.taskRunStatusAsString())
                && Objects.equals(targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString())
                && hasTaskRunStatusCounts() == other.hasTaskRunStatusCounts()
                && Objects.equals(taskRunStatusCountsAsStrings(), other.taskRunStatusCountsAsStrings())
                && Objects.equals(taskFailureRetryCount(), other.taskFailureRetryCount())
                && Objects.equals(maxFailedTasksCount(), other.maxFailedTasksCount())
                && Objects.equals(maxRetriesPerTask(), other.maxRetriesPerTask())
                && Objects.equals(maxWorkerCount(), other.maxWorkerCount()) && Objects.equals(sourceJobId(), other.sourceJobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobSummary").add("JobId", jobId()).add("Name", name())
                .add("LifecycleStatus", lifecycleStatusAsString()).add("LifecycleStatusMessage", lifecycleStatusMessage())
                .add("Priority", priority()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).add("StartedAt", startedAt())
                .add("EndedAt", endedAt()).add("TaskRunStatus", taskRunStatusAsString())
                .add("TargetTaskRunStatus", targetTaskRunStatusAsString())
                .add("TaskRunStatusCounts", hasTaskRunStatusCounts() ? taskRunStatusCountsAsStrings() : null)
                .add("TaskFailureRetryCount", taskFailureRetryCount()).add("MaxFailedTasksCount", maxFailedTasksCount())
                .add("MaxRetriesPerTask", maxRetriesPerTask()).add("MaxWorkerCount", maxWorkerCount())
                .add("SourceJobId", sourceJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "lifecycleStatus":
            return Optional.ofNullable(clazz.cast(lifecycleStatusAsString()));
        case "lifecycleStatusMessage":
            return Optional.ofNullable(clazz.cast(lifecycleStatusMessage()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "taskRunStatus":
            return Optional.ofNullable(clazz.cast(taskRunStatusAsString()));
        case "targetTaskRunStatus":
            return Optional.ofNullable(clazz.cast(targetTaskRunStatusAsString()));
        case "taskRunStatusCounts":
            return Optional.ofNullable(clazz.cast(taskRunStatusCountsAsStrings()));
        case "taskFailureRetryCount":
            return Optional.ofNullable(clazz.cast(taskFailureRetryCount()));
        case "maxFailedTasksCount":
            return Optional.ofNullable(clazz.cast(maxFailedTasksCount()));
        case "maxRetriesPerTask":
            return Optional.ofNullable(clazz.cast(maxRetriesPerTask()));
        case "maxWorkerCount":
            return Optional.ofNullable(clazz.cast(maxWorkerCount()));
        case "sourceJobId":
            return Optional.ofNullable(clazz.cast(sourceJobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
        map.put("lifecycleStatusMessage", LIFECYCLE_STATUS_MESSAGE_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("taskRunStatus", TASK_RUN_STATUS_FIELD);
        map.put("targetTaskRunStatus", TARGET_TASK_RUN_STATUS_FIELD);
        map.put("taskRunStatusCounts", TASK_RUN_STATUS_COUNTS_FIELD);
        map.put("taskFailureRetryCount", TASK_FAILURE_RETRY_COUNT_FIELD);
        map.put("maxFailedTasksCount", MAX_FAILED_TASKS_COUNT_FIELD);
        map.put("maxRetriesPerTask", MAX_RETRIES_PER_TASK_FIELD);
        map.put("maxWorkerCount", MAX_WORKER_COUNT_FIELD);
        map.put("sourceJobId", SOURCE_JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobSummary, T> g) {
        return obj -> g.apply((JobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobSummary> {
        /**
         * <p>
         * The job ID.
         * </p>
         * 
         * @param jobId
         *        The job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The job name.
         * </p>
         * 
         * @param name
         *        The job name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The life cycle status.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status.
         * @see JobLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobLifecycleStatus
         */
        Builder lifecycleStatus(String lifecycleStatus);

        /**
         * <p>
         * The life cycle status.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status.
         * @see JobLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobLifecycleStatus
         */
        Builder lifecycleStatus(JobLifecycleStatus lifecycleStatus);

        /**
         * <p>
         * The life cycle status message.
         * </p>
         * 
         * @param lifecycleStatusMessage
         *        The life cycle status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleStatusMessage(String lifecycleStatusMessage);

        /**
         * <p>
         * The job priority.
         * </p>
         * 
         * @param priority
         *        The job priority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The task run status for the job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>–pending and waiting for resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code>–ready to be processed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSIGNED</code>–assigned and will run next on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULED</code>–scheduled to be run on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERRUPTING</code>–being interrupted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>–running on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code>–the task is suspended.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELED</code>–the task has been canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>–the task has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>–the task has succeeded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskRunStatus
         *        The task run status for the job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>–pending and waiting for resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code>–ready to be processed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSIGNED</code>–assigned and will run next on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULED</code>–scheduled to be run on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERRUPTING</code>–being interrupted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>–running on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code>–the task is suspended.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELED</code>–the task has been canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>–the task has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>–the task has succeeded.
         *        </p>
         *        </li>
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder taskRunStatus(String taskRunStatus);

        /**
         * <p>
         * The task run status for the job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>–pending and waiting for resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code>–ready to be processed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSIGNED</code>–assigned and will run next on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULED</code>–scheduled to be run on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERRUPTING</code>–being interrupted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>–running on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code>–the task is suspended.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELED</code>–the task has been canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>–the task has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>–the task has succeeded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskRunStatus
         *        The task run status for the job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>–pending and waiting for resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code>–ready to be processed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSIGNED</code>–assigned and will run next on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULED</code>–scheduled to be run on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERRUPTING</code>–being interrupted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>–running on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code>–the task is suspended.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELED</code>–the task has been canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>–the task has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>–the task has succeeded.
         *        </p>
         *        </li>
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder taskRunStatus(TaskRunStatus taskRunStatus);

        /**
         * <p>
         * The task status to start with on the job.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status to start with on the job.
         * @see JobTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(String targetTaskRunStatus);

        /**
         * <p>
         * The task status to start with on the job.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status to start with on the job.
         * @see JobTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(JobTargetTaskRunStatus targetTaskRunStatus);

        /**
         * <p>
         * The number of tasks running on the job.
         * </p>
         * 
         * @param taskRunStatusCounts
         *        The number of tasks running on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts);

        /**
         * <p>
         * The number of tasks running on the job.
         * </p>
         * 
         * @param taskRunStatusCounts
         *        The number of tasks running on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts);

        /**
         * <p>
         * The total number of times tasks from the job failed and were retried.
         * </p>
         * 
         * @param taskFailureRetryCount
         *        The total number of times tasks from the job failed and were retried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskFailureRetryCount(Integer taskFailureRetryCount);

        /**
         * <p>
         * The number of task failures before the job stops running and is marked as <code>FAILED</code>.
         * </p>
         * 
         * @param maxFailedTasksCount
         *        The number of task failures before the job stops running and is marked as <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFailedTasksCount(Integer maxFailedTasksCount);

        /**
         * <p>
         * The maximum number of retries for a job.
         * </p>
         * 
         * @param maxRetriesPerTask
         *        The maximum number of retries for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetriesPerTask(Integer maxRetriesPerTask);

        /**
         * <p>
         * The maximum number of worker hosts that can concurrently process a job. When the <code>maxWorkerCount</code>
         * is reached, no more workers will be assigned to process the job, even if the fleets assigned to the job's
         * queue has available workers.
         * </p>
         * <p>
         * You can't set the <code>maxWorkerCount</code> to 0. If you set it to -1, there is no maximum number of
         * workers.
         * </p>
         * <p>
         * If you don't specify the <code>maxWorkerCount</code>, the default is -1.
         * </p>
         * 
         * @param maxWorkerCount
         *        The maximum number of worker hosts that can concurrently process a job. When the
         *        <code>maxWorkerCount</code> is reached, no more workers will be assigned to process the job, even if
         *        the fleets assigned to the job's queue has available workers.</p>
         *        <p>
         *        You can't set the <code>maxWorkerCount</code> to 0. If you set it to -1, there is no maximum number of
         *        workers.
         *        </p>
         *        <p>
         *        If you don't specify the <code>maxWorkerCount</code>, the default is -1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWorkerCount(Integer maxWorkerCount);

        /**
         * <p>
         * The job ID for the source job.
         * </p>
         * 
         * @param sourceJobId
         *        The job ID for the source job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceJobId(String sourceJobId);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String name;

        private String lifecycleStatus;

        private String lifecycleStatusMessage;

        private Integer priority;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private Instant startedAt;

        private Instant endedAt;

        private String taskRunStatus;

        private String targetTaskRunStatus;

        private Map<String, Integer> taskRunStatusCounts = DefaultSdkAutoConstructMap.getInstance();

        private Integer taskFailureRetryCount;

        private Integer maxFailedTasksCount;

        private Integer maxRetriesPerTask;

        private Integer maxWorkerCount;

        private String sourceJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            jobId(model.jobId);
            name(model.name);
            lifecycleStatus(model.lifecycleStatus);
            lifecycleStatusMessage(model.lifecycleStatusMessage);
            priority(model.priority);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            taskRunStatus(model.taskRunStatus);
            targetTaskRunStatus(model.targetTaskRunStatus);
            taskRunStatusCountsWithStrings(model.taskRunStatusCounts);
            taskFailureRetryCount(model.taskFailureRetryCount);
            maxFailedTasksCount(model.maxFailedTasksCount);
            maxRetriesPerTask(model.maxRetriesPerTask);
            maxWorkerCount(model.maxWorkerCount);
            sourceJobId(model.sourceJobId);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLifecycleStatus() {
            return lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(JobLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final String getLifecycleStatusMessage() {
            return lifecycleStatusMessage;
        }

        public final void setLifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
        }

        @Override
        public final Builder lifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getTaskRunStatus() {
            return taskRunStatus;
        }

        public final void setTaskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
        }

        @Override
        public final Builder taskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
            return this;
        }

        @Override
        public final Builder taskRunStatus(TaskRunStatus taskRunStatus) {
            this.taskRunStatus(taskRunStatus == null ? null : taskRunStatus.toString());
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(JobTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final Map<String, Integer> getTaskRunStatusCounts() {
            if (taskRunStatusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return taskRunStatusCounts;
        }

        public final void setTaskRunStatusCounts(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
        }

        @Override
        public final Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
            return this;
        }

        @Override
        public final Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copyEnumToString(taskRunStatusCounts);
            return this;
        }

        public final Integer getTaskFailureRetryCount() {
            return taskFailureRetryCount;
        }

        public final void setTaskFailureRetryCount(Integer taskFailureRetryCount) {
            this.taskFailureRetryCount = taskFailureRetryCount;
        }

        @Override
        public final Builder taskFailureRetryCount(Integer taskFailureRetryCount) {
            this.taskFailureRetryCount = taskFailureRetryCount;
            return this;
        }

        public final Integer getMaxFailedTasksCount() {
            return maxFailedTasksCount;
        }

        public final void setMaxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
        }

        @Override
        public final Builder maxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
            return this;
        }

        public final Integer getMaxRetriesPerTask() {
            return maxRetriesPerTask;
        }

        public final void setMaxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
        }

        @Override
        public final Builder maxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
            return this;
        }

        public final Integer getMaxWorkerCount() {
            return maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final String getSourceJobId() {
            return sourceJobId;
        }

        public final void setSourceJobId(String sourceJobId) {
            this.sourceJobId = sourceJobId;
        }

        @Override
        public final Builder sourceJobId(String sourceJobId) {
            this.sourceJobId = sourceJobId;
            return this;
        }

        @Override
        public JobSummary build() {
            return new JobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
