/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a specific limit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LimitSummary implements SdkPojo, Serializable, ToCopyableBuilder<LimitSummary.Builder, LimitSummary> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(LimitSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> AMOUNT_REQUIREMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amountRequirementName").getter(getter(LimitSummary::amountRequirementName))
            .setter(setter(Builder::amountRequirementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amountRequirementName").build())
            .build();

    private static final SdkField<Integer> MAX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCount").getter(getter(LimitSummary::maxCount)).setter(setter(Builder::maxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCount").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(LimitSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(LimitSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(LimitSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(LimitSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(LimitSummary::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()).build();

    private static final SdkField<String> LIMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("limitId").getter(getter(LimitSummary::limitId)).setter(setter(Builder::limitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitId").build()).build();

    private static final SdkField<Integer> CURRENT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("currentCount").getter(getter(LimitSummary::currentCount)).setter(setter(Builder::currentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            AMOUNT_REQUIREMENT_NAME_FIELD, MAX_COUNT_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD,
            UPDATED_BY_FIELD, FARM_ID_FIELD, LIMIT_ID_FIELD, CURRENT_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String displayName;

    private final String amountRequirementName;

    private final Integer maxCount;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final String farmId;

    private final String limitId;

    private final Integer currentCount;

    private LimitSummary(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.amountRequirementName = builder.amountRequirementName;
        this.maxCount = builder.maxCount;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.farmId = builder.farmId;
        this.limitId = builder.limitId;
        this.currentCount = builder.currentCount;
    }

    /**
     * <p>
     * The name of the limit used in lists to identify the limit.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The name of the limit used in lists to identify the limit.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The value that you specify as the <code>name</code> in the <code>amounts</code> field of the
     * <code>hostRequirements</code> in a step of a job template to declare the limit requirement.
     * </p>
     * 
     * @return The value that you specify as the <code>name</code> in the <code>amounts</code> field of the
     *         <code>hostRequirements</code> in a step of a job template to declare the limit requirement.
     */
    public final String amountRequirementName() {
        return amountRequirementName;
    }

    /**
     * <p>
     * The maximum number of resources constrained by this limit. When all of the resources are in use, steps that
     * require the limit won't be scheduled until the resource is available.
     * </p>
     * <p>
     * The <code>maxValue</code> must not be 0. If the value is -1, there is no restriction on the number of resources
     * that can be acquired for this limit.
     * </p>
     * 
     * @return The maximum number of resources constrained by this limit. When all of the resources are in use, steps
     *         that require the limit won't be scheduled until the resource is available.</p>
     *         <p>
     *         The <code>maxValue</code> must not be 0. If the value is -1, there is no restriction on the number of
     *         resources that can be acquired for this limit.
     */
    public final Integer maxCount() {
        return maxCount;
    }

    /**
     * <p>
     * The Unix timestamp of the date and time that the limit was created.
     * </p>
     * 
     * @return The Unix timestamp of the date and time that the limit was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user identifier of the person that created the limit.
     * </p>
     * 
     * @return The user identifier of the person that created the limit.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The Unix timestamp of the date and time that the limit was last updated.
     * </p>
     * 
     * @return The Unix timestamp of the date and time that the limit was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user identifier of the person that last updated the limit.
     * </p>
     * 
     * @return The user identifier of the person that last updated the limit.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The unique identifier of the farm that contains the limit.
     * </p>
     * 
     * @return The unique identifier of the farm that contains the limit.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The unique identifier of the limit.
     * </p>
     * 
     * @return The unique identifier of the limit.
     */
    public final String limitId() {
        return limitId;
    }

    /**
     * <p>
     * The number of resources from the limit that are being used by jobs. The result is delayed and may not be the
     * count at the time that you called the operation.
     * </p>
     * 
     * @return The number of resources from the limit that are being used by jobs. The result is delayed and may not be
     *         the count at the time that you called the operation.
     */
    public final Integer currentCount() {
        return currentCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(amountRequirementName());
        hashCode = 31 * hashCode + Objects.hashCode(maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(limitId());
        hashCode = 31 * hashCode + Objects.hashCode(currentCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LimitSummary)) {
            return false;
        }
        LimitSummary other = (LimitSummary) obj;
        return Objects.equals(displayName(), other.displayName())
                && Objects.equals(amountRequirementName(), other.amountRequirementName())
                && Objects.equals(maxCount(), other.maxCount()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(limitId(), other.limitId()) && Objects.equals(currentCount(), other.currentCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LimitSummary").add("DisplayName", displayName())
                .add("AmountRequirementName", amountRequirementName()).add("MaxCount", maxCount()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy()).add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy())
                .add("FarmId", farmId()).add("LimitId", limitId()).add("CurrentCount", currentCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "amountRequirementName":
            return Optional.ofNullable(clazz.cast(amountRequirementName()));
        case "maxCount":
            return Optional.ofNullable(clazz.cast(maxCount()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "limitId":
            return Optional.ofNullable(clazz.cast(limitId()));
        case "currentCount":
            return Optional.ofNullable(clazz.cast(currentCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("amountRequirementName", AMOUNT_REQUIREMENT_NAME_FIELD);
        map.put("maxCount", MAX_COUNT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("limitId", LIMIT_ID_FIELD);
        map.put("currentCount", CURRENT_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LimitSummary, T> g) {
        return obj -> g.apply((LimitSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LimitSummary> {
        /**
         * <p>
         * The name of the limit used in lists to identify the limit.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The name of the limit used in lists to identify the limit.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The value that you specify as the <code>name</code> in the <code>amounts</code> field of the
         * <code>hostRequirements</code> in a step of a job template to declare the limit requirement.
         * </p>
         * 
         * @param amountRequirementName
         *        The value that you specify as the <code>name</code> in the <code>amounts</code> field of the
         *        <code>hostRequirements</code> in a step of a job template to declare the limit requirement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amountRequirementName(String amountRequirementName);

        /**
         * <p>
         * The maximum number of resources constrained by this limit. When all of the resources are in use, steps that
         * require the limit won't be scheduled until the resource is available.
         * </p>
         * <p>
         * The <code>maxValue</code> must not be 0. If the value is -1, there is no restriction on the number of
         * resources that can be acquired for this limit.
         * </p>
         * 
         * @param maxCount
         *        The maximum number of resources constrained by this limit. When all of the resources are in use, steps
         *        that require the limit won't be scheduled until the resource is available.</p>
         *        <p>
         *        The <code>maxValue</code> must not be 0. If the value is -1, there is no restriction on the number of
         *        resources that can be acquired for this limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCount(Integer maxCount);

        /**
         * <p>
         * The Unix timestamp of the date and time that the limit was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp of the date and time that the limit was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user identifier of the person that created the limit.
         * </p>
         * 
         * @param createdBy
         *        The user identifier of the person that created the limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The Unix timestamp of the date and time that the limit was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp of the date and time that the limit was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user identifier of the person that last updated the limit.
         * </p>
         * 
         * @param updatedBy
         *        The user identifier of the person that last updated the limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The unique identifier of the farm that contains the limit.
         * </p>
         * 
         * @param farmId
         *        The unique identifier of the farm that contains the limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The unique identifier of the limit.
         * </p>
         * 
         * @param limitId
         *        The unique identifier of the limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitId(String limitId);

        /**
         * <p>
         * The number of resources from the limit that are being used by jobs. The result is delayed and may not be the
         * count at the time that you called the operation.
         * </p>
         * 
         * @param currentCount
         *        The number of resources from the limit that are being used by jobs. The result is delayed and may not
         *        be the count at the time that you called the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentCount(Integer currentCount);
    }

    static final class BuilderImpl implements Builder {
        private String displayName;

        private String amountRequirementName;

        private Integer maxCount;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private String farmId;

        private String limitId;

        private Integer currentCount;

        private BuilderImpl() {
        }

        private BuilderImpl(LimitSummary model) {
            displayName(model.displayName);
            amountRequirementName(model.amountRequirementName);
            maxCount(model.maxCount);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            farmId(model.farmId);
            limitId(model.limitId);
            currentCount(model.currentCount);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAmountRequirementName() {
            return amountRequirementName;
        }

        public final void setAmountRequirementName(String amountRequirementName) {
            this.amountRequirementName = amountRequirementName;
        }

        @Override
        public final Builder amountRequirementName(String amountRequirementName) {
            this.amountRequirementName = amountRequirementName;
            return this;
        }

        public final Integer getMaxCount() {
            return maxCount;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getLimitId() {
            return limitId;
        }

        public final void setLimitId(String limitId) {
            this.limitId = limitId;
        }

        @Override
        public final Builder limitId(String limitId) {
            this.limitId = limitId;
            return this;
        }

        public final Integer getCurrentCount() {
            return currentCount;
        }

        public final void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        @Override
        public final Builder currentCount(Integer currentCount) {
            this.currentCount = currentCount;
            return this;
        }

        @Override
        public LimitSummary build() {
            return new LimitSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
