/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueueLimitAssociationsResponse extends DeadlineResponse implements
        ToCopyableBuilder<ListQueueLimitAssociationsResponse.Builder, ListQueueLimitAssociationsResponse> {
    private static final SdkField<List<QueueLimitAssociationSummary>> QUEUE_LIMIT_ASSOCIATIONS_FIELD = SdkField
            .<List<QueueLimitAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("queueLimitAssociations")
            .getter(getter(ListQueueLimitAssociationsResponse::queueLimitAssociations))
            .setter(setter(Builder::queueLimitAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueLimitAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueueLimitAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueueLimitAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListQueueLimitAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            QUEUE_LIMIT_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<QueueLimitAssociationSummary> queueLimitAssociations;

    private final String nextToken;

    private ListQueueLimitAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.queueLimitAssociations = builder.queueLimitAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueueLimitAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasQueueLimitAssociations() {
        return queueLimitAssociations != null && !(queueLimitAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of associations between limits and queues in the farm specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueueLimitAssociations} method.
     * </p>
     * 
     * @return A list of associations between limits and queues in the farm specified in the request.
     */
    public final List<QueueLimitAssociationSummary> queueLimitAssociations() {
        return queueLimitAssociations;
    }

    /**
     * <p>
     * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation
     * again using the returned token. Keep all other arguments unchanged. If no results remain, then
     * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide
     * a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     * </p>
     * 
     * @return If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
     *         operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
     *         <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
     *         provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQueueLimitAssociations() ? queueLimitAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueLimitAssociationsResponse)) {
            return false;
        }
        ListQueueLimitAssociationsResponse other = (ListQueueLimitAssociationsResponse) obj;
        return hasQueueLimitAssociations() == other.hasQueueLimitAssociations()
                && Objects.equals(queueLimitAssociations(), other.queueLimitAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueueLimitAssociationsResponse")
                .add("QueueLimitAssociations", hasQueueLimitAssociations() ? queueLimitAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueLimitAssociations":
            return Optional.ofNullable(clazz.cast(queueLimitAssociations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queueLimitAssociations", QUEUE_LIMIT_ASSOCIATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueueLimitAssociationsResponse, T> g) {
        return obj -> g.apply((ListQueueLimitAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListQueueLimitAssociationsResponse> {
        /**
         * <p>
         * A list of associations between limits and queues in the farm specified in the request.
         * </p>
         * 
         * @param queueLimitAssociations
         *        A list of associations between limits and queues in the farm specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueLimitAssociations(Collection<QueueLimitAssociationSummary> queueLimitAssociations);

        /**
         * <p>
         * A list of associations between limits and queues in the farm specified in the request.
         * </p>
         * 
         * @param queueLimitAssociations
         *        A list of associations between limits and queues in the farm specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueLimitAssociations(QueueLimitAssociationSummary... queueLimitAssociations);

        /**
         * <p>
         * A list of associations between limits and queues in the farm specified in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.QueueLimitAssociationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.QueueLimitAssociationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.QueueLimitAssociationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #queueLimitAssociations(List<QueueLimitAssociationSummary>)}.
         * 
         * @param queueLimitAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.QueueLimitAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueLimitAssociations(java.util.Collection<QueueLimitAssociationSummary>)
         */
        Builder queueLimitAssociations(Consumer<QueueLimitAssociationSummary.Builder>... queueLimitAssociations);

        /**
         * <p>
         * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         * operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
         * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
         * provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
         * </p>
         * 
         * @param nextToken
         *        If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         *        operation again using the returned token. Keep all other arguments unchanged. If no results remain,
         *        then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours.
         *        If you provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<QueueLimitAssociationSummary> queueLimitAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueLimitAssociationsResponse model) {
            super(model);
            queueLimitAssociations(model.queueLimitAssociations);
            nextToken(model.nextToken);
        }

        public final List<QueueLimitAssociationSummary.Builder> getQueueLimitAssociations() {
            List<QueueLimitAssociationSummary.Builder> result = QueueLimitAssociationSummariesCopier
                    .copyToBuilder(this.queueLimitAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueueLimitAssociations(Collection<QueueLimitAssociationSummary.BuilderImpl> queueLimitAssociations) {
            this.queueLimitAssociations = QueueLimitAssociationSummariesCopier.copyFromBuilder(queueLimitAssociations);
        }

        @Override
        public final Builder queueLimitAssociations(Collection<QueueLimitAssociationSummary> queueLimitAssociations) {
            this.queueLimitAssociations = QueueLimitAssociationSummariesCopier.copy(queueLimitAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueLimitAssociations(QueueLimitAssociationSummary... queueLimitAssociations) {
            queueLimitAssociations(Arrays.asList(queueLimitAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueLimitAssociations(Consumer<QueueLimitAssociationSummary.Builder>... queueLimitAssociations) {
            queueLimitAssociations(Stream.of(queueLimitAssociations)
                    .map(c -> QueueLimitAssociationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQueueLimitAssociationsResponse build() {
            return new ListQueueLimitAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
