/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the manifest that links a job's source information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManifestProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ManifestProperties.Builder, ManifestProperties> {
    private static final SdkField<String> FILE_SYSTEM_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileSystemLocationName").getter(getter(ManifestProperties::fileSystemLocationName))
            .setter(setter(Builder::fileSystemLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocationName").build())
            .build();

    private static final SdkField<String> ROOT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootPath").getter(getter(ManifestProperties::rootPath)).setter(setter(Builder::rootPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootPath").build()).build();

    private static final SdkField<String> ROOT_PATH_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootPathFormat").getter(getter(ManifestProperties::rootPathFormatAsString))
            .setter(setter(Builder::rootPathFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootPathFormat").build()).build();

    private static final SdkField<List<String>> OUTPUT_RELATIVE_DIRECTORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("outputRelativeDirectories")
            .getter(getter(ManifestProperties::outputRelativeDirectories))
            .setter(setter(Builder::outputRelativeDirectories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputRelativeDirectories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INPUT_MANIFEST_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputManifestPath").getter(getter(ManifestProperties::inputManifestPath))
            .setter(setter(Builder::inputManifestPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputManifestPath").build()).build();

    private static final SdkField<String> INPUT_MANIFEST_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputManifestHash").getter(getter(ManifestProperties::inputManifestHash))
            .setter(setter(Builder::inputManifestHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputManifestHash").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILE_SYSTEM_LOCATION_NAME_FIELD, ROOT_PATH_FIELD, ROOT_PATH_FORMAT_FIELD, OUTPUT_RELATIVE_DIRECTORIES_FIELD,
            INPUT_MANIFEST_PATH_FIELD, INPUT_MANIFEST_HASH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileSystemLocationName;

    private final String rootPath;

    private final String rootPathFormat;

    private final List<String> outputRelativeDirectories;

    private final String inputManifestPath;

    private final String inputManifestHash;

    private ManifestProperties(BuilderImpl builder) {
        this.fileSystemLocationName = builder.fileSystemLocationName;
        this.rootPath = builder.rootPath;
        this.rootPathFormat = builder.rootPathFormat;
        this.outputRelativeDirectories = builder.outputRelativeDirectories;
        this.inputManifestPath = builder.inputManifestPath;
        this.inputManifestHash = builder.inputManifestHash;
    }

    /**
     * <p>
     * The file system location name.
     * </p>
     * 
     * @return The file system location name.
     */
    public final String fileSystemLocationName() {
        return fileSystemLocationName;
    }

    /**
     * <p>
     * The file's root path.
     * </p>
     * 
     * @return The file's root path.
     */
    public final String rootPath() {
        return rootPath;
    }

    /**
     * <p>
     * The format of the root path.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootPathFormat}
     * will return {@link PathFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootPathFormatAsString}.
     * </p>
     * 
     * @return The format of the root path.
     * @see PathFormat
     */
    public final PathFormat rootPathFormat() {
        return PathFormat.fromValue(rootPathFormat);
    }

    /**
     * <p>
     * The format of the root path.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootPathFormat}
     * will return {@link PathFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootPathFormatAsString}.
     * </p>
     * 
     * @return The format of the root path.
     * @see PathFormat
     */
    public final String rootPathFormatAsString() {
        return rootPathFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputRelativeDirectories property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOutputRelativeDirectories() {
        return outputRelativeDirectories != null && !(outputRelativeDirectories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The file path relative to the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputRelativeDirectories} method.
     * </p>
     * 
     * @return The file path relative to the directory.
     */
    public final List<String> outputRelativeDirectories() {
        return outputRelativeDirectories;
    }

    /**
     * <p>
     * The file path.
     * </p>
     * 
     * @return The file path.
     */
    public final String inputManifestPath() {
        return inputManifestPath;
    }

    /**
     * <p>
     * The hash value of the file.
     * </p>
     * 
     * @return The hash value of the file.
     */
    public final String inputManifestHash() {
        return inputManifestHash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(rootPath());
        hashCode = 31 * hashCode + Objects.hashCode(rootPathFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputRelativeDirectories() ? outputRelativeDirectories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputManifestPath());
        hashCode = 31 * hashCode + Objects.hashCode(inputManifestHash());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManifestProperties)) {
            return false;
        }
        ManifestProperties other = (ManifestProperties) obj;
        return Objects.equals(fileSystemLocationName(), other.fileSystemLocationName())
                && Objects.equals(rootPath(), other.rootPath())
                && Objects.equals(rootPathFormatAsString(), other.rootPathFormatAsString())
                && hasOutputRelativeDirectories() == other.hasOutputRelativeDirectories()
                && Objects.equals(outputRelativeDirectories(), other.outputRelativeDirectories())
                && Objects.equals(inputManifestPath(), other.inputManifestPath())
                && Objects.equals(inputManifestHash(), other.inputManifestHash());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManifestProperties").add("FileSystemLocationName", fileSystemLocationName())
                .add("RootPath", rootPath()).add("RootPathFormat", rootPathFormatAsString())
                .add("OutputRelativeDirectories", hasOutputRelativeDirectories() ? outputRelativeDirectories() : null)
                .add("InputManifestPath", inputManifestPath()).add("InputManifestHash", inputManifestHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileSystemLocationName":
            return Optional.ofNullable(clazz.cast(fileSystemLocationName()));
        case "rootPath":
            return Optional.ofNullable(clazz.cast(rootPath()));
        case "rootPathFormat":
            return Optional.ofNullable(clazz.cast(rootPathFormatAsString()));
        case "outputRelativeDirectories":
            return Optional.ofNullable(clazz.cast(outputRelativeDirectories()));
        case "inputManifestPath":
            return Optional.ofNullable(clazz.cast(inputManifestPath()));
        case "inputManifestHash":
            return Optional.ofNullable(clazz.cast(inputManifestHash()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileSystemLocationName", FILE_SYSTEM_LOCATION_NAME_FIELD);
        map.put("rootPath", ROOT_PATH_FIELD);
        map.put("rootPathFormat", ROOT_PATH_FORMAT_FIELD);
        map.put("outputRelativeDirectories", OUTPUT_RELATIVE_DIRECTORIES_FIELD);
        map.put("inputManifestPath", INPUT_MANIFEST_PATH_FIELD);
        map.put("inputManifestHash", INPUT_MANIFEST_HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManifestProperties, T> g) {
        return obj -> g.apply((ManifestProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManifestProperties> {
        /**
         * <p>
         * The file system location name.
         * </p>
         * 
         * @param fileSystemLocationName
         *        The file system location name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocationName(String fileSystemLocationName);

        /**
         * <p>
         * The file's root path.
         * </p>
         * 
         * @param rootPath
         *        The file's root path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootPath(String rootPath);

        /**
         * <p>
         * The format of the root path.
         * </p>
         * 
         * @param rootPathFormat
         *        The format of the root path.
         * @see PathFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PathFormat
         */
        Builder rootPathFormat(String rootPathFormat);

        /**
         * <p>
         * The format of the root path.
         * </p>
         * 
         * @param rootPathFormat
         *        The format of the root path.
         * @see PathFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PathFormat
         */
        Builder rootPathFormat(PathFormat rootPathFormat);

        /**
         * <p>
         * The file path relative to the directory.
         * </p>
         * 
         * @param outputRelativeDirectories
         *        The file path relative to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputRelativeDirectories(Collection<String> outputRelativeDirectories);

        /**
         * <p>
         * The file path relative to the directory.
         * </p>
         * 
         * @param outputRelativeDirectories
         *        The file path relative to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputRelativeDirectories(String... outputRelativeDirectories);

        /**
         * <p>
         * The file path.
         * </p>
         * 
         * @param inputManifestPath
         *        The file path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputManifestPath(String inputManifestPath);

        /**
         * <p>
         * The hash value of the file.
         * </p>
         * 
         * @param inputManifestHash
         *        The hash value of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputManifestHash(String inputManifestHash);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemLocationName;

        private String rootPath;

        private String rootPathFormat;

        private List<String> outputRelativeDirectories = DefaultSdkAutoConstructList.getInstance();

        private String inputManifestPath;

        private String inputManifestHash;

        private BuilderImpl() {
        }

        private BuilderImpl(ManifestProperties model) {
            fileSystemLocationName(model.fileSystemLocationName);
            rootPath(model.rootPath);
            rootPathFormat(model.rootPathFormat);
            outputRelativeDirectories(model.outputRelativeDirectories);
            inputManifestPath(model.inputManifestPath);
            inputManifestHash(model.inputManifestHash);
        }

        public final String getFileSystemLocationName() {
            return fileSystemLocationName;
        }

        public final void setFileSystemLocationName(String fileSystemLocationName) {
            this.fileSystemLocationName = fileSystemLocationName;
        }

        @Override
        public final Builder fileSystemLocationName(String fileSystemLocationName) {
            this.fileSystemLocationName = fileSystemLocationName;
            return this;
        }

        public final String getRootPath() {
            return rootPath;
        }

        public final void setRootPath(String rootPath) {
            this.rootPath = rootPath;
        }

        @Override
        public final Builder rootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public final String getRootPathFormat() {
            return rootPathFormat;
        }

        public final void setRootPathFormat(String rootPathFormat) {
            this.rootPathFormat = rootPathFormat;
        }

        @Override
        public final Builder rootPathFormat(String rootPathFormat) {
            this.rootPathFormat = rootPathFormat;
            return this;
        }

        @Override
        public final Builder rootPathFormat(PathFormat rootPathFormat) {
            this.rootPathFormat(rootPathFormat == null ? null : rootPathFormat.toString());
            return this;
        }

        public final Collection<String> getOutputRelativeDirectories() {
            if (outputRelativeDirectories instanceof SdkAutoConstructList) {
                return null;
            }
            return outputRelativeDirectories;
        }

        public final void setOutputRelativeDirectories(Collection<String> outputRelativeDirectories) {
            this.outputRelativeDirectories = OutputRelativeDirectoriesListCopier.copy(outputRelativeDirectories);
        }

        @Override
        public final Builder outputRelativeDirectories(Collection<String> outputRelativeDirectories) {
            this.outputRelativeDirectories = OutputRelativeDirectoriesListCopier.copy(outputRelativeDirectories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputRelativeDirectories(String... outputRelativeDirectories) {
            outputRelativeDirectories(Arrays.asList(outputRelativeDirectories));
            return this;
        }

        public final String getInputManifestPath() {
            return inputManifestPath;
        }

        public final void setInputManifestPath(String inputManifestPath) {
            this.inputManifestPath = inputManifestPath;
        }

        @Override
        public final Builder inputManifestPath(String inputManifestPath) {
            this.inputManifestPath = inputManifestPath;
            return this;
        }

        public final String getInputManifestHash() {
            return inputManifestHash;
        }

        public final void setInputManifestHash(String inputManifestHash) {
            this.inputManifestHash = inputManifestHash;
        }

        @Override
        public final Builder inputManifestHash(String inputManifestHash) {
            this.inputManifestHash = inputManifestHash;
            return this;
        }

        @Override
        public ManifestProperties build() {
            return new ManifestProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
