/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a monitor in Deadline Cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitorSummary implements SdkPojo, Serializable, ToCopyableBuilder<MonitorSummary.Builder, MonitorSummary> {
    private static final SdkField<String> MONITOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorId").getter(getter(MonitorSummary::monitorId)).setter(setter(Builder::monitorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(MonitorSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> SUBDOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subdomain").getter(getter(MonitorSummary::subdomain)).setter(setter(Builder::subdomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subdomain").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(MonitorSummary::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(MonitorSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityCenterInstanceArn").getter(getter(MonitorSummary::identityCenterInstanceArn))
            .setter(setter(Builder::identityCenterInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterInstanceArn").build())
            .build();

    private static final SdkField<String> IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("identityCenterApplicationArn")
            .getter(getter(MonitorSummary::identityCenterApplicationArn))
            .setter(setter(Builder::identityCenterApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityCenterApplicationArn")
                    .build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(MonitorSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(MonitorSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(MonitorSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(MonitorSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ID_FIELD,
            DISPLAY_NAME_FIELD, SUBDOMAIN_FIELD, URL_FIELD, ROLE_ARN_FIELD, IDENTITY_CENTER_INSTANCE_ARN_FIELD,
            IDENTITY_CENTER_APPLICATION_ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String monitorId;

    private final String displayName;

    private final String subdomain;

    private final String url;

    private final String roleArn;

    private final String identityCenterInstanceArn;

    private final String identityCenterApplicationArn;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private MonitorSummary(BuilderImpl builder) {
        this.monitorId = builder.monitorId;
        this.displayName = builder.displayName;
        this.subdomain = builder.subdomain;
        this.url = builder.url;
        this.roleArn = builder.roleArn;
        this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
        this.identityCenterApplicationArn = builder.identityCenterApplicationArn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The unique identifier for the monitor.
     * </p>
     * 
     * @return The unique identifier for the monitor.
     */
    public final String monitorId() {
        return monitorId;
    }

    /**
     * <p>
     * The name of the monitor that displays on the Deadline Cloud console.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The name of the monitor that displays on the Deadline Cloud console.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The subdomain used for the monitor URL. The full URL of the monitor is
     * subdomain.Region.deadlinecloud.amazonaws.com.
     * </p>
     * 
     * @return The subdomain used for the monitor URL. The full URL of the monitor is
     *         subdomain.Region.deadlinecloud.amazonaws.com.
     */
    public final String subdomain() {
        return subdomain;
    }

    /**
     * <p>
     * The complete URL of the monitor. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
     * </p>
     * 
     * @return The complete URL of the monitor. The full URL of the monitor is
     *         subdomain.Region.deadlinecloud.amazonaws.com.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to access
     * Deadline Cloud resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to
     *         access Deadline Cloud resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor users.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor
     *         users.
     */
    public final String identityCenterInstanceArn() {
        return identityCenterInstanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the monitor when it was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the monitor when it was created.
     */
    public final String identityCenterApplicationArn() {
        return identityCenterApplicationArn;
    }

    /**
     * <p>
     * The UNIX timestamp of the date and time that the monitor was created.
     * </p>
     * 
     * @return The UNIX timestamp of the date and time that the monitor was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user name of the person that created the monitor.
     * </p>
     * 
     * @return The user name of the person that created the monitor.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The UNIX timestamp of the date and time that the monitor was last updated.
     * </p>
     * 
     * @return The UNIX timestamp of the date and time that the monitor was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user name of the person that last updated the monitor.
     * </p>
     * 
     * @return The user name of the person that last updated the monitor.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitorId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(subdomain());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorSummary)) {
            return false;
        }
        MonitorSummary other = (MonitorSummary) obj;
        return Objects.equals(monitorId(), other.monitorId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(subdomain(), other.subdomain()) && Objects.equals(url(), other.url())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(identityCenterInstanceArn(), other.identityCenterInstanceArn())
                && Objects.equals(identityCenterApplicationArn(), other.identityCenterApplicationArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitorSummary").add("MonitorId", monitorId()).add("DisplayName", displayName())
                .add("Subdomain", subdomain()).add("Url", url()).add("RoleArn", roleArn())
                .add("IdentityCenterInstanceArn", identityCenterInstanceArn())
                .add("IdentityCenterApplicationArn", identityCenterApplicationArn()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy()).add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "monitorId":
            return Optional.ofNullable(clazz.cast(monitorId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "subdomain":
            return Optional.ofNullable(clazz.cast(subdomain()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "identityCenterInstanceArn":
            return Optional.ofNullable(clazz.cast(identityCenterInstanceArn()));
        case "identityCenterApplicationArn":
            return Optional.ofNullable(clazz.cast(identityCenterApplicationArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("monitorId", MONITOR_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("subdomain", SUBDOMAIN_FIELD);
        map.put("url", URL_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("identityCenterInstanceArn", IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("identityCenterApplicationArn", IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitorSummary, T> g) {
        return obj -> g.apply((MonitorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitorSummary> {
        /**
         * <p>
         * The unique identifier for the monitor.
         * </p>
         * 
         * @param monitorId
         *        The unique identifier for the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorId(String monitorId);

        /**
         * <p>
         * The name of the monitor that displays on the Deadline Cloud console.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The name of the monitor that displays on the Deadline Cloud console.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The subdomain used for the monitor URL. The full URL of the monitor is
         * subdomain.Region.deadlinecloud.amazonaws.com.
         * </p>
         * 
         * @param subdomain
         *        The subdomain used for the monitor URL. The full URL of the monitor is
         *        subdomain.Region.deadlinecloud.amazonaws.com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdomain(String subdomain);

        /**
         * <p>
         * The complete URL of the monitor. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
         * </p>
         * 
         * @param url
         *        The complete URL of the monitor. The full URL of the monitor is
         *        subdomain.Region.deadlinecloud.amazonaws.com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to access
         * Deadline Cloud resources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of the monitor use this role to
         *        access Deadline Cloud resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating monitor
         * users.
         * </p>
         * 
         * @param identityCenterInstanceArn
         *        The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible for authenticating
         *        monitor users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterInstanceArn(String identityCenterInstanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the monitor when it was created.
         * </p>
         * 
         * @param identityCenterApplicationArn
         *        The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the monitor when it was
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterApplicationArn(String identityCenterApplicationArn);

        /**
         * <p>
         * The UNIX timestamp of the date and time that the monitor was created.
         * </p>
         * 
         * @param createdAt
         *        The UNIX timestamp of the date and time that the monitor was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user name of the person that created the monitor.
         * </p>
         * 
         * @param createdBy
         *        The user name of the person that created the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The UNIX timestamp of the date and time that the monitor was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The UNIX timestamp of the date and time that the monitor was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user name of the person that last updated the monitor.
         * </p>
         * 
         * @param updatedBy
         *        The user name of the person that last updated the monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private String monitorId;

        private String displayName;

        private String subdomain;

        private String url;

        private String roleArn;

        private String identityCenterInstanceArn;

        private String identityCenterApplicationArn;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorSummary model) {
            monitorId(model.monitorId);
            displayName(model.displayName);
            subdomain(model.subdomain);
            url(model.url);
            roleArn(model.roleArn);
            identityCenterInstanceArn(model.identityCenterInstanceArn);
            identityCenterApplicationArn(model.identityCenterApplicationArn);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final String getMonitorId() {
            return monitorId;
        }

        public final void setMonitorId(String monitorId) {
            this.monitorId = monitorId;
        }

        @Override
        public final Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getSubdomain() {
            return subdomain;
        }

        public final void setSubdomain(String subdomain) {
            this.subdomain = subdomain;
        }

        @Override
        public final Builder subdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getIdentityCenterInstanceArn() {
            return identityCenterInstanceArn;
        }

        public final void setIdentityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
        }

        @Override
        public final Builder identityCenterInstanceArn(String identityCenterInstanceArn) {
            this.identityCenterInstanceArn = identityCenterInstanceArn;
            return this;
        }

        public final String getIdentityCenterApplicationArn() {
            return identityCenterApplicationArn;
        }

        public final void setIdentityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
        }

        @Override
        public final Builder identityCenterApplicationArn(String identityCenterApplicationArn) {
            this.identityCenterApplicationArn = identityCenterApplicationArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public MonitorSummary build() {
            return new MonitorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
