/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search strings in
 * a resource.
 * <p>
 * You can use two groupings per search each within parenthesis <code>()</code>.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchGroupedFilterExpressions implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchGroupedFilterExpressions.Builder, SearchGroupedFilterExpressions> {
    private static final SdkField<List<SearchFilterExpression>> FILTERS_FIELD = SdkField
            .<List<SearchFilterExpression>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(SearchGroupedFilterExpressions::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchFilterExpression> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchFilterExpression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(SearchGroupedFilterExpressions::operatorAsString))
            .setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FILTERS_FIELD, OPERATOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SearchFilterExpression> filters;

    private final String operator;

    private SearchGroupedFilterExpressions(BuilderImpl builder) {
        this.filters = builder.filters;
        this.operator = builder.operator;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters to use for the search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters to use for the search.
     */
    public final List<SearchFilterExpression> filters() {
        return filters;
    }

    /**
     * <p>
     * The operators to include in the search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link LogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The operators to include in the search.
     * @see LogicalOperator
     */
    public final LogicalOperator operator() {
        return LogicalOperator.fromValue(operator);
    }

    /**
     * <p>
     * The operators to include in the search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link LogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return The operators to include in the search.
     * @see LogicalOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGroupedFilterExpressions)) {
            return false;
        }
        SearchGroupedFilterExpressions other = (SearchGroupedFilterExpressions) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchGroupedFilterExpressions").add("Filters", hasFilters() ? filters() : null)
                .add("Operator", operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filters", FILTERS_FIELD);
        map.put("operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchGroupedFilterExpressions, T> g) {
        return obj -> g.apply((SearchGroupedFilterExpressions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchGroupedFilterExpressions> {
        /**
         * <p>
         * The filters to use for the search.
         * </p>
         * 
         * @param filters
         *        The filters to use for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SearchFilterExpression> filters);

        /**
         * <p>
         * The filters to use for the search.
         * </p>
         * 
         * @param filters
         *        The filters to use for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SearchFilterExpression... filters);

        /**
         * <p>
         * The filters to use for the search.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.SearchFilterExpression.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.SearchFilterExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.SearchFilterExpression.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<SearchFilterExpression>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.SearchFilterExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<SearchFilterExpression>)
         */
        Builder filters(Consumer<SearchFilterExpression.Builder>... filters);

        /**
         * <p>
         * The operators to include in the search.
         * </p>
         * 
         * @param operator
         *        The operators to include in the search.
         * @see LogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogicalOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The operators to include in the search.
         * </p>
         * 
         * @param operator
         *        The operators to include in the search.
         * @see LogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogicalOperator
         */
        Builder operator(LogicalOperator operator);
    }

    static final class BuilderImpl implements Builder {
        private List<SearchFilterExpression> filters = DefaultSdkAutoConstructList.getInstance();

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGroupedFilterExpressions model) {
            filters(model.filters);
            operator(model.operator);
        }

        public final List<SearchFilterExpression.Builder> getFilters() {
            List<SearchFilterExpression.Builder> result = SearchFilterExpressionsCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SearchFilterExpression.BuilderImpl> filters) {
            this.filters = SearchFilterExpressionsCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<SearchFilterExpression> filters) {
            this.filters = SearchFilterExpressionsCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SearchFilterExpression... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SearchFilterExpression.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SearchFilterExpression.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(LogicalOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public SearchGroupedFilterExpressions build() {
            return new SearchGroupedFilterExpressions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
