/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resources to search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchSortExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchSortExpression.Builder, SearchSortExpression> {
    private static final SdkField<UserJobsFirst> USER_JOBS_FIRST_FIELD = SdkField
            .<UserJobsFirst> builder(MarshallingType.SDK_POJO).memberName("userJobsFirst")
            .getter(getter(SearchSortExpression::userJobsFirst)).setter(setter(Builder::userJobsFirst))
            .constructor(UserJobsFirst::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userJobsFirst").build()).build();

    private static final SdkField<FieldSortExpression> FIELD_SORT_FIELD = SdkField
            .<FieldSortExpression> builder(MarshallingType.SDK_POJO).memberName("fieldSort")
            .getter(getter(SearchSortExpression::fieldSort)).setter(setter(Builder::fieldSort))
            .constructor(FieldSortExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldSort").build()).build();

    private static final SdkField<ParameterSortExpression> PARAMETER_SORT_FIELD = SdkField
            .<ParameterSortExpression> builder(MarshallingType.SDK_POJO).memberName("parameterSort")
            .getter(getter(SearchSortExpression::parameterSort)).setter(setter(Builder::parameterSort))
            .constructor(ParameterSortExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterSort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_JOBS_FIRST_FIELD,
            FIELD_SORT_FIELD, PARAMETER_SORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UserJobsFirst userJobsFirst;

    private final FieldSortExpression fieldSort;

    private final ParameterSortExpression parameterSort;

    private final Type type;

    private SearchSortExpression(BuilderImpl builder) {
        this.userJobsFirst = builder.userJobsFirst;
        this.fieldSort = builder.fieldSort;
        this.parameterSort = builder.parameterSort;
        this.type = builder.type;
    }

    /**
     * <p>
     * Options for sorting a particular user's jobs first.
     * </p>
     * 
     * @return Options for sorting a particular user's jobs first.
     */
    public final UserJobsFirst userJobsFirst() {
        return userJobsFirst;
    }

    /**
     * <p>
     * Options for sorting by a field.
     * </p>
     * 
     * @return Options for sorting by a field.
     */
    public final FieldSortExpression fieldSort() {
        return fieldSort;
    }

    /**
     * <p>
     * Options for sorting by a parameter.
     * </p>
     * 
     * @return Options for sorting by a parameter.
     */
    public final ParameterSortExpression parameterSort() {
        return parameterSort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userJobsFirst());
        hashCode = 31 * hashCode + Objects.hashCode(fieldSort());
        hashCode = 31 * hashCode + Objects.hashCode(parameterSort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSortExpression)) {
            return false;
        }
        SearchSortExpression other = (SearchSortExpression) obj;
        return Objects.equals(userJobsFirst(), other.userJobsFirst()) && Objects.equals(fieldSort(), other.fieldSort())
                && Objects.equals(parameterSort(), other.parameterSort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchSortExpression").add("UserJobsFirst", userJobsFirst()).add("FieldSort", fieldSort())
                .add("ParameterSort", parameterSort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userJobsFirst":
            return Optional.ofNullable(clazz.cast(userJobsFirst()));
        case "fieldSort":
            return Optional.ofNullable(clazz.cast(fieldSort()));
        case "parameterSort":
            return Optional.ofNullable(clazz.cast(parameterSort()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #userJobsFirst()} initialized to the given value.
     *
     * <p>
     * Options for sorting a particular user's jobs first.
     * </p>
     * 
     * @param userJobsFirst
     *        Options for sorting a particular user's jobs first.
     */
    public static SearchSortExpression fromUserJobsFirst(UserJobsFirst userJobsFirst) {
        return builder().userJobsFirst(userJobsFirst).build();
    }

    /**
     * Create an instance of this class with {@link #userJobsFirst()} initialized to the given value.
     *
     * <p>
     * Options for sorting a particular user's jobs first.
     * </p>
     * 
     * @param userJobsFirst
     *        Options for sorting a particular user's jobs first.
     */
    public static SearchSortExpression fromUserJobsFirst(Consumer<UserJobsFirst.Builder> userJobsFirst) {
        UserJobsFirst.Builder builder = UserJobsFirst.builder();
        userJobsFirst.accept(builder);
        return fromUserJobsFirst(builder.build());
    }

    /**
     * Create an instance of this class with {@link #fieldSort()} initialized to the given value.
     *
     * <p>
     * Options for sorting by a field.
     * </p>
     * 
     * @param fieldSort
     *        Options for sorting by a field.
     */
    public static SearchSortExpression fromFieldSort(FieldSortExpression fieldSort) {
        return builder().fieldSort(fieldSort).build();
    }

    /**
     * Create an instance of this class with {@link #fieldSort()} initialized to the given value.
     *
     * <p>
     * Options for sorting by a field.
     * </p>
     * 
     * @param fieldSort
     *        Options for sorting by a field.
     */
    public static SearchSortExpression fromFieldSort(Consumer<FieldSortExpression.Builder> fieldSort) {
        FieldSortExpression.Builder builder = FieldSortExpression.builder();
        fieldSort.accept(builder);
        return fromFieldSort(builder.build());
    }

    /**
     * Create an instance of this class with {@link #parameterSort()} initialized to the given value.
     *
     * <p>
     * Options for sorting by a parameter.
     * </p>
     * 
     * @param parameterSort
     *        Options for sorting by a parameter.
     */
    public static SearchSortExpression fromParameterSort(ParameterSortExpression parameterSort) {
        return builder().parameterSort(parameterSort).build();
    }

    /**
     * Create an instance of this class with {@link #parameterSort()} initialized to the given value.
     *
     * <p>
     * Options for sorting by a parameter.
     * </p>
     * 
     * @param parameterSort
     *        Options for sorting by a parameter.
     */
    public static SearchSortExpression fromParameterSort(Consumer<ParameterSortExpression.Builder> parameterSort) {
        ParameterSortExpression.Builder builder = ParameterSortExpression.builder();
        parameterSort.accept(builder);
        return fromParameterSort(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userJobsFirst", USER_JOBS_FIRST_FIELD);
        map.put("fieldSort", FIELD_SORT_FIELD);
        map.put("parameterSort", PARAMETER_SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchSortExpression, T> g) {
        return obj -> g.apply((SearchSortExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchSortExpression> {
        /**
         * <p>
         * Options for sorting a particular user's jobs first.
         * </p>
         * 
         * @param userJobsFirst
         *        Options for sorting a particular user's jobs first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userJobsFirst(UserJobsFirst userJobsFirst);

        /**
         * <p>
         * Options for sorting a particular user's jobs first.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserJobsFirst.Builder} avoiding the need
         * to create one manually via {@link UserJobsFirst#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserJobsFirst.Builder#build()} is called immediately and its
         * result is passed to {@link #userJobsFirst(UserJobsFirst)}.
         * 
         * @param userJobsFirst
         *        a consumer that will call methods on {@link UserJobsFirst.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userJobsFirst(UserJobsFirst)
         */
        default Builder userJobsFirst(Consumer<UserJobsFirst.Builder> userJobsFirst) {
            return userJobsFirst(UserJobsFirst.builder().applyMutation(userJobsFirst).build());
        }

        /**
         * <p>
         * Options for sorting by a field.
         * </p>
         * 
         * @param fieldSort
         *        Options for sorting by a field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldSort(FieldSortExpression fieldSort);

        /**
         * <p>
         * Options for sorting by a field.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldSortExpression.Builder} avoiding the
         * need to create one manually via {@link FieldSortExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldSortExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldSort(FieldSortExpression)}.
         * 
         * @param fieldSort
         *        a consumer that will call methods on {@link FieldSortExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldSort(FieldSortExpression)
         */
        default Builder fieldSort(Consumer<FieldSortExpression.Builder> fieldSort) {
            return fieldSort(FieldSortExpression.builder().applyMutation(fieldSort).build());
        }

        /**
         * <p>
         * Options for sorting by a parameter.
         * </p>
         * 
         * @param parameterSort
         *        Options for sorting by a parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterSort(ParameterSortExpression parameterSort);

        /**
         * <p>
         * Options for sorting by a parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterSortExpression.Builder} avoiding
         * the need to create one manually via {@link ParameterSortExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterSortExpression.Builder#build()} is called immediately
         * and its result is passed to {@link #parameterSort(ParameterSortExpression)}.
         * 
         * @param parameterSort
         *        a consumer that will call methods on {@link ParameterSortExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterSort(ParameterSortExpression)
         */
        default Builder parameterSort(Consumer<ParameterSortExpression.Builder> parameterSort) {
            return parameterSort(ParameterSortExpression.builder().applyMutation(parameterSort).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UserJobsFirst userJobsFirst;

        private FieldSortExpression fieldSort;

        private ParameterSortExpression parameterSort;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSortExpression model) {
            userJobsFirst(model.userJobsFirst);
            fieldSort(model.fieldSort);
            parameterSort(model.parameterSort);
        }

        public final UserJobsFirst.Builder getUserJobsFirst() {
            return userJobsFirst != null ? userJobsFirst.toBuilder() : null;
        }

        public final void setUserJobsFirst(UserJobsFirst.BuilderImpl userJobsFirst) {
            Object oldValue = this.userJobsFirst;
            this.userJobsFirst = userJobsFirst != null ? userJobsFirst.build() : null;
            handleUnionValueChange(Type.USER_JOBS_FIRST, oldValue, this.userJobsFirst);
        }

        @Override
        public final Builder userJobsFirst(UserJobsFirst userJobsFirst) {
            Object oldValue = this.userJobsFirst;
            this.userJobsFirst = userJobsFirst;
            handleUnionValueChange(Type.USER_JOBS_FIRST, oldValue, this.userJobsFirst);
            return this;
        }

        public final FieldSortExpression.Builder getFieldSort() {
            return fieldSort != null ? fieldSort.toBuilder() : null;
        }

        public final void setFieldSort(FieldSortExpression.BuilderImpl fieldSort) {
            Object oldValue = this.fieldSort;
            this.fieldSort = fieldSort != null ? fieldSort.build() : null;
            handleUnionValueChange(Type.FIELD_SORT, oldValue, this.fieldSort);
        }

        @Override
        public final Builder fieldSort(FieldSortExpression fieldSort) {
            Object oldValue = this.fieldSort;
            this.fieldSort = fieldSort;
            handleUnionValueChange(Type.FIELD_SORT, oldValue, this.fieldSort);
            return this;
        }

        public final ParameterSortExpression.Builder getParameterSort() {
            return parameterSort != null ? parameterSort.toBuilder() : null;
        }

        public final void setParameterSort(ParameterSortExpression.BuilderImpl parameterSort) {
            Object oldValue = this.parameterSort;
            this.parameterSort = parameterSort != null ? parameterSort.build() : null;
            handleUnionValueChange(Type.PARAMETER_SORT, oldValue, this.parameterSort);
        }

        @Override
        public final Builder parameterSort(ParameterSortExpression parameterSort) {
            Object oldValue = this.parameterSort;
            this.parameterSort = parameterSort;
            handleUnionValueChange(Type.PARAMETER_SORT, oldValue, this.parameterSort);
            return this;
        }

        @Override
        public SearchSortExpression build() {
            return new SearchSortExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SearchSortExpression#type()
     */
    public enum Type {
        USER_JOBS_FIRST,

        FIELD_SORT,

        PARAMETER_SORT,

        UNKNOWN_TO_SDK_VERSION
    }
}
