/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Searches for a particular search term.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTermFilterExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchTermFilterExpression.Builder, SearchTermFilterExpression> {
    private static final SdkField<String> SEARCH_TERM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("searchTerm").getter(getter(SearchTermFilterExpression::searchTerm)).setter(setter(Builder::searchTerm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchTerm").build()).build();

    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchType").getter(getter(SearchTermFilterExpression::matchTypeAsString))
            .setter(setter(Builder::matchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_TERM_FIELD,
            MATCH_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String searchTerm;

    private final String matchType;

    private SearchTermFilterExpression(BuilderImpl builder) {
        this.searchTerm = builder.searchTerm;
        this.matchType = builder.matchType;
    }

    /**
     * <p>
     * The term to search for.
     * </p>
     * 
     * @return The term to search for.
     */
    public final String searchTerm() {
        return searchTerm;
    }

    /**
     * <p>
     * Specifies how Deadline Cloud matches your search term in the results. If you don't specify a
     * <code>matchType</code> the default is <code>FUZZY_MATCH</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FUZZY_MATCH</code> - Matches if a portion of the search term is found in the result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONTAINS</code> - Matches if the exact search term is contained in the result.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link SearchTermMatchingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeAsString}.
     * </p>
     * 
     * @return Specifies how Deadline Cloud matches your search term in the results. If you don't specify a
     *         <code>matchType</code> the default is <code>FUZZY_MATCH</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FUZZY_MATCH</code> - Matches if a portion of the search term is found in the result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONTAINS</code> - Matches if the exact search term is contained in the result.
     *         </p>
     *         </li>
     * @see SearchTermMatchingType
     */
    public final SearchTermMatchingType matchType() {
        return SearchTermMatchingType.fromValue(matchType);
    }

    /**
     * <p>
     * Specifies how Deadline Cloud matches your search term in the results. If you don't specify a
     * <code>matchType</code> the default is <code>FUZZY_MATCH</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FUZZY_MATCH</code> - Matches if a portion of the search term is found in the result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CONTAINS</code> - Matches if the exact search term is contained in the result.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link SearchTermMatchingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeAsString}.
     * </p>
     * 
     * @return Specifies how Deadline Cloud matches your search term in the results. If you don't specify a
     *         <code>matchType</code> the default is <code>FUZZY_MATCH</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FUZZY_MATCH</code> - Matches if a portion of the search term is found in the result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CONTAINS</code> - Matches if the exact search term is contained in the result.
     *         </p>
     *         </li>
     * @see SearchTermMatchingType
     */
    public final String matchTypeAsString() {
        return matchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(searchTerm());
        hashCode = 31 * hashCode + Objects.hashCode(matchTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTermFilterExpression)) {
            return false;
        }
        SearchTermFilterExpression other = (SearchTermFilterExpression) obj;
        return Objects.equals(searchTerm(), other.searchTerm()) && Objects.equals(matchTypeAsString(), other.matchTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchTermFilterExpression").add("SearchTerm", searchTerm())
                .add("MatchType", matchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "searchTerm":
            return Optional.ofNullable(clazz.cast(searchTerm()));
        case "matchType":
            return Optional.ofNullable(clazz.cast(matchTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("searchTerm", SEARCH_TERM_FIELD);
        map.put("matchType", MATCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchTermFilterExpression, T> g) {
        return obj -> g.apply((SearchTermFilterExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchTermFilterExpression> {
        /**
         * <p>
         * The term to search for.
         * </p>
         * 
         * @param searchTerm
         *        The term to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchTerm(String searchTerm);

        /**
         * <p>
         * Specifies how Deadline Cloud matches your search term in the results. If you don't specify a
         * <code>matchType</code> the default is <code>FUZZY_MATCH</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FUZZY_MATCH</code> - Matches if a portion of the search term is found in the result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONTAINS</code> - Matches if the exact search term is contained in the result.
         * </p>
         * </li>
         * </ul>
         * 
         * @param matchType
         *        Specifies how Deadline Cloud matches your search term in the results. If you don't specify a
         *        <code>matchType</code> the default is <code>FUZZY_MATCH</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FUZZY_MATCH</code> - Matches if a portion of the search term is found in the result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONTAINS</code> - Matches if the exact search term is contained in the result.
         *        </p>
         *        </li>
         * @see SearchTermMatchingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchTermMatchingType
         */
        Builder matchType(String matchType);

        /**
         * <p>
         * Specifies how Deadline Cloud matches your search term in the results. If you don't specify a
         * <code>matchType</code> the default is <code>FUZZY_MATCH</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FUZZY_MATCH</code> - Matches if a portion of the search term is found in the result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CONTAINS</code> - Matches if the exact search term is contained in the result.
         * </p>
         * </li>
         * </ul>
         * 
         * @param matchType
         *        Specifies how Deadline Cloud matches your search term in the results. If you don't specify a
         *        <code>matchType</code> the default is <code>FUZZY_MATCH</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FUZZY_MATCH</code> - Matches if a portion of the search term is found in the result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CONTAINS</code> - Matches if the exact search term is contained in the result.
         *        </p>
         *        </li>
         * @see SearchTermMatchingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchTermMatchingType
         */
        Builder matchType(SearchTermMatchingType matchType);
    }

    static final class BuilderImpl implements Builder {
        private String searchTerm;

        private String matchType;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTermFilterExpression model) {
            searchTerm(model.searchTerm);
            matchType(model.matchType);
        }

        public final String getSearchTerm() {
            return searchTerm;
        }

        public final void setSearchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public final Builder searchTerm(String searchTerm) {
            this.searchTerm = searchTerm;
            return this;
        }

        public final String getMatchType() {
            return matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(SearchTermMatchingType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        @Override
        public SearchTermFilterExpression build() {
            return new SearchTermFilterExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
