/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.waiters;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.model.GetFleetRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetResponse;
import software.amazon.awssdk.services.deadline.model.GetJobRequest;
import software.amazon.awssdk.services.deadline.model.GetJobResponse;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueLimitAssociationRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueLimitAssociationResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Waiter utility class that polls a resource until a desired state is reached or until it is determined that the
 * resource will never enter into the desired state. This can be created using the static {@link #builder()} method
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
@Immutable
public interface DeadlineWaiter extends SdkAutoCloseable {
    /**
     * Polls {@link DeadlineClient#getFleet} API until the desired condition {@code FleetActive} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getFleetRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetFleetResponse> waitUntilFleetActive(GetFleetRequest getFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getFleet} API until the desired condition {@code FleetActive} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetFleetRequest#builder()}
     *
     * @param getFleetRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetFleetResponse> waitUntilFleetActive(Consumer<GetFleetRequest.Builder> getFleetRequest) {
        return waitUntilFleetActive(GetFleetRequest.builder().applyMutation(getFleetRequest).build());
    }

    /**
     * Polls {@link DeadlineClient#getFleet} API until the desired condition {@code FleetActive} is met, or until it is
     * determined that the resource will never enter into the desired state
     *
     * @param getFleetRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetFleetResponse> waitUntilFleetActive(GetFleetRequest getFleetRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getFleet} API until the desired condition {@code FleetActive} is met, or until it is
     * determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getFleetRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetFleetResponse> waitUntilFleetActive(Consumer<GetFleetRequest.Builder> getFleetRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilFleetActive(GetFleetRequest.builder().applyMutation(getFleetRequest).build(), WaiterOverrideConfiguration
                .builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link DeadlineClient#getJob} API until the desired condition {@code JobCreateComplete} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param getJobRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetJobResponse> waitUntilJobCreateComplete(GetJobRequest getJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getJob} API until the desired condition {@code JobCreateComplete} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetJobRequest#builder()}
     *
     * @param getJobRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetJobResponse> waitUntilJobCreateComplete(Consumer<GetJobRequest.Builder> getJobRequest) {
        return waitUntilJobCreateComplete(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * Polls {@link DeadlineClient#getJob} API until the desired condition {@code JobCreateComplete} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param getJobRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetJobResponse> waitUntilJobCreateComplete(GetJobRequest getJobRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getJob} API until the desired condition {@code JobCreateComplete} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getJobRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetJobResponse> waitUntilJobCreateComplete(Consumer<GetJobRequest.Builder> getJobRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilJobCreateComplete(GetJobRequest.builder().applyMutation(getJobRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link DeadlineClient#getLicenseEndpoint} API until the desired condition {@code LicenseEndpointDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getLicenseEndpointRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointDeleted(
            GetLicenseEndpointRequest getLicenseEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getLicenseEndpoint} API until the desired condition {@code LicenseEndpointDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetLicenseEndpointRequest#builder()}
     *
     * @param getLicenseEndpointRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointDeleted(
            Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest) {
        return waitUntilLicenseEndpointDeleted(GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest)
                .build());
    }

    /**
     * Polls {@link DeadlineClient#getLicenseEndpoint} API until the desired condition {@code LicenseEndpointDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getLicenseEndpointRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointDeleted(
            GetLicenseEndpointRequest getLicenseEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getLicenseEndpoint} API until the desired condition {@code LicenseEndpointDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getLicenseEndpointRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointDeleted(
            Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilLicenseEndpointDeleted(GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link DeadlineClient#getLicenseEndpoint} API until the desired condition {@code LicenseEndpointValid} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getLicenseEndpointRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointValid(
            GetLicenseEndpointRequest getLicenseEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getLicenseEndpoint} API until the desired condition {@code LicenseEndpointValid} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetLicenseEndpointRequest#builder()}
     *
     * @param getLicenseEndpointRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointValid(
            Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest) {
        return waitUntilLicenseEndpointValid(GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest).build());
    }

    /**
     * Polls {@link DeadlineClient#getLicenseEndpoint} API until the desired condition {@code LicenseEndpointValid} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getLicenseEndpointRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointValid(
            GetLicenseEndpointRequest getLicenseEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getLicenseEndpoint} API until the desired condition {@code LicenseEndpointValid} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getLicenseEndpointRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetLicenseEndpointResponse> waitUntilLicenseEndpointValid(
            Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilLicenseEndpointValid(
                GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest).build(), WaiterOverrideConfiguration
                        .builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link DeadlineClient#getQueueFleetAssociation} API until the desired condition
     * {@code QueueFleetAssociationStopped} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param getQueueFleetAssociationRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueFleetAssociationResponse> waitUntilQueueFleetAssociationStopped(
            GetQueueFleetAssociationRequest getQueueFleetAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getQueueFleetAssociation} API until the desired condition
     * {@code QueueFleetAssociationStopped} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetQueueFleetAssociationRequest#builder()}
     *
     * @param getQueueFleetAssociationRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueFleetAssociationResponse> waitUntilQueueFleetAssociationStopped(
            Consumer<GetQueueFleetAssociationRequest.Builder> getQueueFleetAssociationRequest) {
        return waitUntilQueueFleetAssociationStopped(GetQueueFleetAssociationRequest.builder()
                .applyMutation(getQueueFleetAssociationRequest).build());
    }

    /**
     * Polls {@link DeadlineClient#getQueueFleetAssociation} API until the desired condition
     * {@code QueueFleetAssociationStopped} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param getQueueFleetAssociationRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueFleetAssociationResponse> waitUntilQueueFleetAssociationStopped(
            GetQueueFleetAssociationRequest getQueueFleetAssociationRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getQueueFleetAssociation} API until the desired condition
     * {@code QueueFleetAssociationStopped} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getQueueFleetAssociationRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueFleetAssociationResponse> waitUntilQueueFleetAssociationStopped(
            Consumer<GetQueueFleetAssociationRequest.Builder> getQueueFleetAssociationRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilQueueFleetAssociationStopped(
                GetQueueFleetAssociationRequest.builder().applyMutation(getQueueFleetAssociationRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link DeadlineClient#getQueueLimitAssociation} API until the desired condition
     * {@code QueueLimitAssociationStopped} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param getQueueLimitAssociationRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueLimitAssociationResponse> waitUntilQueueLimitAssociationStopped(
            GetQueueLimitAssociationRequest getQueueLimitAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getQueueLimitAssociation} API until the desired condition
     * {@code QueueLimitAssociationStopped} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetQueueLimitAssociationRequest#builder()}
     *
     * @param getQueueLimitAssociationRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueLimitAssociationResponse> waitUntilQueueLimitAssociationStopped(
            Consumer<GetQueueLimitAssociationRequest.Builder> getQueueLimitAssociationRequest) {
        return waitUntilQueueLimitAssociationStopped(GetQueueLimitAssociationRequest.builder()
                .applyMutation(getQueueLimitAssociationRequest).build());
    }

    /**
     * Polls {@link DeadlineClient#getQueueLimitAssociation} API until the desired condition
     * {@code QueueLimitAssociationStopped} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param getQueueLimitAssociationRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueLimitAssociationResponse> waitUntilQueueLimitAssociationStopped(
            GetQueueLimitAssociationRequest getQueueLimitAssociationRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getQueueLimitAssociation} API until the desired condition
     * {@code QueueLimitAssociationStopped} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getQueueLimitAssociationRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueLimitAssociationResponse> waitUntilQueueLimitAssociationStopped(
            Consumer<GetQueueLimitAssociationRequest.Builder> getQueueLimitAssociationRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilQueueLimitAssociationStopped(
                GetQueueLimitAssociationRequest.builder().applyMutation(getQueueLimitAssociationRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link DeadlineClient#getQueue} API until the desired condition {@code QueueScheduling} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param getQueueRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueResponse> waitUntilQueueScheduling(GetQueueRequest getQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getQueue} API until the desired condition {@code QueueScheduling} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetQueueRequest#builder()}
     *
     * @param getQueueRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueResponse> waitUntilQueueScheduling(Consumer<GetQueueRequest.Builder> getQueueRequest) {
        return waitUntilQueueScheduling(GetQueueRequest.builder().applyMutation(getQueueRequest).build());
    }

    /**
     * Polls {@link DeadlineClient#getQueue} API until the desired condition {@code QueueScheduling} is met, or until it
     * is determined that the resource will never enter into the desired state
     *
     * @param getQueueRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueResponse> waitUntilQueueScheduling(GetQueueRequest getQueueRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getQueue} API until the desired condition {@code QueueScheduling} is met, or until it
     * is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getQueueRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueResponse> waitUntilQueueScheduling(Consumer<GetQueueRequest.Builder> getQueueRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilQueueScheduling(GetQueueRequest.builder().applyMutation(getQueueRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link DeadlineClient#getQueue} API until the desired condition {@code QueueSchedulingBlocked} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param getQueueRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueResponse> waitUntilQueueSchedulingBlocked(GetQueueRequest getQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getQueue} API until the desired condition {@code QueueSchedulingBlocked} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetQueueRequest#builder()}
     *
     * @param getQueueRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueResponse> waitUntilQueueSchedulingBlocked(Consumer<GetQueueRequest.Builder> getQueueRequest) {
        return waitUntilQueueSchedulingBlocked(GetQueueRequest.builder().applyMutation(getQueueRequest).build());
    }

    /**
     * Polls {@link DeadlineClient#getQueue} API until the desired condition {@code QueueSchedulingBlocked} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param getQueueRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueResponse> waitUntilQueueSchedulingBlocked(GetQueueRequest getQueueRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link DeadlineClient#getQueue} API until the desired condition {@code QueueSchedulingBlocked} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getQueueRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetQueueResponse> waitUntilQueueSchedulingBlocked(Consumer<GetQueueRequest.Builder> getQueueRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilQueueSchedulingBlocked(GetQueueRequest.builder().applyMutation(getQueueRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Create a builder that can be used to configure and create a {@link DeadlineWaiter}.
     *
     * @return a builder
     */
    static Builder builder() {
        return DefaultDeadlineWaiter.builder();
    }

    /**
     * Create an instance of {@link DeadlineWaiter} with the default configuration.
     * <p>
     * <b>A default {@link DeadlineClient} will be created to poll resources. It is recommended to share a single
     * instance of the waiter created via this method. If it is not desirable to share a waiter instance, invoke
     * {@link #close()} to release the resources once the waiter is not needed.</b>
     *
     * @return an instance of {@link DeadlineWaiter}
     */
    static DeadlineWaiter create() {
        return DefaultDeadlineWaiter.builder().build();
    }

    interface Builder {
        /**
         * Defines overrides to the default SDK waiter configuration that should be used for waiters created from this
         * builder
         *
         * @param overrideConfiguration
         *        the override configuration to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration);

        /**
         * This is a convenient method to pass the override configuration without the need to create an instance
         * manually via {@link WaiterOverrideConfiguration#builder()}
         *
         * @param overrideConfiguration
         *        The consumer that will configure the overrideConfiguration
         * @return a reference to this object so that method calls can be chained together.
         * @see #overrideConfiguration(WaiterOverrideConfiguration)
         */
        default Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return overrideConfiguration(builder.build());
        }

        /**
         * Sets a custom {@link DeadlineClient} that will be used to poll the resource
         * <p>
         * This SDK client must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * client when the waiter is closed
         *
         * @param client
         *        the client to send the request
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder client(DeadlineClient client);

        /**
         * Builds an instance of {@link DeadlineWaiter} based on the configurations supplied to this builder
         *
         * @return An initialized {@link DeadlineWaiter}
         */
        DeadlineWaiter build();
    }
}
