/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMembersResponse extends DetectiveResponse implements
        ToCopyableBuilder<ListMembersResponse.Builder, ListMembersResponse> {
    private static final SdkField<List<MemberDetail>> MEMBER_DETAILS_FIELD = SdkField
            .<List<MemberDetail>> builder(MarshallingType.LIST)
            .getter(getter(ListMembersResponse::memberDetails))
            .setter(setter(Builder::memberDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMembersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MemberDetail> memberDetails;

    private final String nextToken;

    private ListMembersResponse(BuilderImpl builder) {
        super(builder);
        this.memberDetails = builder.memberDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the MemberDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMemberDetails() {
        return memberDetails != null && !(memberDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of member accounts in the behavior graph.
     * </p>
     * <p>
     * The results include member accounts that did not pass verification and member accounts that have not yet accepted
     * the invitation to the behavior graph. The results do not include member accounts that were removed from the
     * behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMemberDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of member accounts in the behavior graph.</p>
     *         <p>
     *         The results include member accounts that did not pass verification and member accounts that have not yet
     *         accepted the invitation to the behavior graph. The results do not include member accounts that were
     *         removed from the behavior graph.
     */
    public List<MemberDetail> memberDetails() {
        return memberDetails;
    }

    /**
     * <p>
     * If there are more member accounts remaining in the results, then this is the pagination token to use to request
     * the next page of member accounts.
     * </p>
     * 
     * @return If there are more member accounts remaining in the results, then this is the pagination token to use to
     *         request the next page of member accounts.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memberDetails());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersResponse)) {
            return false;
        }
        ListMembersResponse other = (ListMembersResponse) obj;
        return Objects.equals(memberDetails(), other.memberDetails()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMembersResponse").add("MemberDetails", memberDetails()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberDetails":
            return Optional.ofNullable(clazz.cast(memberDetails()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMembersResponse, T> g) {
        return obj -> g.apply((ListMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMembersResponse> {
        /**
         * <p>
         * The list of member accounts in the behavior graph.
         * </p>
         * <p>
         * The results include member accounts that did not pass verification and member accounts that have not yet
         * accepted the invitation to the behavior graph. The results do not include member accounts that were removed
         * from the behavior graph.
         * </p>
         * 
         * @param memberDetails
         *        The list of member accounts in the behavior graph.</p>
         *        <p>
         *        The results include member accounts that did not pass verification and member accounts that have not
         *        yet accepted the invitation to the behavior graph. The results do not include member accounts that
         *        were removed from the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDetails(Collection<MemberDetail> memberDetails);

        /**
         * <p>
         * The list of member accounts in the behavior graph.
         * </p>
         * <p>
         * The results include member accounts that did not pass verification and member accounts that have not yet
         * accepted the invitation to the behavior graph. The results do not include member accounts that were removed
         * from the behavior graph.
         * </p>
         * 
         * @param memberDetails
         *        The list of member accounts in the behavior graph.</p>
         *        <p>
         *        The results include member accounts that did not pass verification and member accounts that have not
         *        yet accepted the invitation to the behavior graph. The results do not include member accounts that
         *        were removed from the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDetails(MemberDetail... memberDetails);

        /**
         * <p>
         * The list of member accounts in the behavior graph.
         * </p>
         * <p>
         * The results include member accounts that did not pass verification and member accounts that have not yet
         * accepted the invitation to the behavior graph. The results do not include member accounts that were removed
         * from the behavior graph.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberDetail>.Builder} avoiding the need to
         * create one manually via {@link List<MemberDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #memberDetails(List<MemberDetail>)}.
         * 
         * @param memberDetails
         *        a consumer that will call methods on {@link List<MemberDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberDetails(List<MemberDetail>)
         */
        Builder memberDetails(Consumer<MemberDetail.Builder>... memberDetails);

        /**
         * <p>
         * If there are more member accounts remaining in the results, then this is the pagination token to use to
         * request the next page of member accounts.
         * </p>
         * 
         * @param nextToken
         *        If there are more member accounts remaining in the results, then this is the pagination token to use
         *        to request the next page of member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private List<MemberDetail> memberDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersResponse model) {
            super(model);
            memberDetails(model.memberDetails);
            nextToken(model.nextToken);
        }

        public final Collection<MemberDetail.Builder> getMemberDetails() {
            return memberDetails != null ? memberDetails.stream().map(MemberDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder memberDetails(Collection<MemberDetail> memberDetails) {
            this.memberDetails = MemberDetailListCopier.copy(memberDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDetails(MemberDetail... memberDetails) {
            memberDetails(Arrays.asList(memberDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDetails(Consumer<MemberDetail.Builder>... memberDetails) {
            memberDetails(Stream.of(memberDetails).map(c -> MemberDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMemberDetails(Collection<MemberDetail.BuilderImpl> memberDetails) {
            this.memberDetails = MemberDetailListCopier.copyFromBuilder(memberDetails);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMembersResponse build() {
            return new ListMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
