/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon Detective is currently in preview.
 * </p>
 * <p>
 * Details about a member account that was invited to contribute to a behavior graph.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberDetail implements SdkPojo, Serializable, ToCopyableBuilder<MemberDetail.Builder, MemberDetail> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MemberDetail::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MemberDetail::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MemberDetail::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()).build();

    private static final SdkField<String> MASTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MemberDetail::masterId)).setter(setter(Builder::masterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MemberDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> INVITED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MemberDetail::invitedTime)).setter(setter(Builder::invitedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedTime").build()).build();

    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MemberDetail::updatedTime)).setter(setter(Builder::updatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            EMAIL_ADDRESS_FIELD, GRAPH_ARN_FIELD, MASTER_ID_FIELD, STATUS_FIELD, INVITED_TIME_FIELD, UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String emailAddress;

    private final String graphArn;

    private final String masterId;

    private final String status;

    private final Instant invitedTime;

    private final Instant updatedTime;

    private MemberDetail(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.emailAddress = builder.emailAddress;
        this.graphArn = builder.graphArn;
        this.masterId = builder.masterId;
        this.status = builder.status;
        this.invitedTime = builder.invitedTime;
        this.updatedTime = builder.updatedTime;
    }

    /**
     * <p>
     * The AWS account identifier for the member account.
     * </p>
     * 
     * @return The AWS account identifier for the member account.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The AWS account root user email address for the member account.
     * </p>
     * 
     * @return The AWS account root user email address for the member account.
     */
    public String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The ARN of the behavior graph that the member account was invited to.
     * </p>
     * 
     * @return The ARN of the behavior graph that the member account was invited to.
     */
    public String graphArn() {
        return graphArn;
    }

    /**
     * <p>
     * The AWS account identifier of the master account for the behavior graph.
     * </p>
     * 
     * @return The AWS account identifier of the master account for the behavior graph.
     */
    public String masterId() {
        return masterId;
    }

    /**
     * <p>
     * The current membership status of the member account. The status can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INVITED</code> - Indicates that the member was sent an invitation but has not yet responded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFICATION_IN_PROGRESS</code> - Indicates that Detective is verifying that the account identifier and
     * email address provided for the member account match. If they do match, then Detective sends the invitation. If
     * the email address and account identifier don't match, then the member cannot be added to the behavior graph.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFICATION_FAILED</code> - Indicates that the account and email address provided for the member account
     * do not match, and Detective did not send an invitation to the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> - Indicates that the member account accepted the invitation to contribute to the behavior
     * graph.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Member accounts that declined an invitation or that were removed from the behavior graph are not included.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current membership status of the member account. The status can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INVITED</code> - Indicates that the member was sent an invitation but has not yet responded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFICATION_IN_PROGRESS</code> - Indicates that Detective is verifying that the account identifier
     *         and email address provided for the member account match. If they do match, then Detective sends the
     *         invitation. If the email address and account identifier don't match, then the member cannot be added to
     *         the behavior graph.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFICATION_FAILED</code> - Indicates that the account and email address provided for the member
     *         account do not match, and Detective did not send an invitation to the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Indicates that the member account accepted the invitation to contribute to the
     *         behavior graph.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Member accounts that declined an invitation or that were removed from the behavior graph are not
     *         included.
     * @see MemberStatus
     */
    public MemberStatus status() {
        return MemberStatus.fromValue(status);
    }

    /**
     * <p>
     * The current membership status of the member account. The status can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INVITED</code> - Indicates that the member was sent an invitation but has not yet responded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFICATION_IN_PROGRESS</code> - Indicates that Detective is verifying that the account identifier and
     * email address provided for the member account match. If they do match, then Detective sends the invitation. If
     * the email address and account identifier don't match, then the member cannot be added to the behavior graph.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFICATION_FAILED</code> - Indicates that the account and email address provided for the member account
     * do not match, and Detective did not send an invitation to the account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> - Indicates that the member account accepted the invitation to contribute to the behavior
     * graph.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Member accounts that declined an invitation or that were removed from the behavior graph are not included.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current membership status of the member account. The status can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INVITED</code> - Indicates that the member was sent an invitation but has not yet responded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFICATION_IN_PROGRESS</code> - Indicates that Detective is verifying that the account identifier
     *         and email address provided for the member account match. If they do match, then Detective sends the
     *         invitation. If the email address and account identifier don't match, then the member cannot be added to
     *         the behavior graph.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFICATION_FAILED</code> - Indicates that the account and email address provided for the member
     *         account do not match, and Detective did not send an invitation to the account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Indicates that the member account accepted the invitation to contribute to the
     *         behavior graph.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Member accounts that declined an invitation or that were removed from the behavior graph are not
     *         included.
     * @see MemberStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that Detective sent the invitation to the member account. The value is in milliseconds since
     * the epoch.
     * </p>
     * 
     * @return The date and time that Detective sent the invitation to the member account. The value is in milliseconds
     *         since the epoch.
     */
    public Instant invitedTime() {
        return invitedTime;
    }

    /**
     * <p>
     * The date and time that the member account was last updated. The value is in milliseconds since the epoch.
     * </p>
     * 
     * @return The date and time that the member account was last updated. The value is in milliseconds since the epoch.
     */
    public Instant updatedTime() {
        return updatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(masterId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(invitedTime());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberDetail)) {
            return false;
        }
        MemberDetail other = (MemberDetail) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(emailAddress(), other.emailAddress())
                && Objects.equals(graphArn(), other.graphArn()) && Objects.equals(masterId(), other.masterId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(invitedTime(), other.invitedTime())
                && Objects.equals(updatedTime(), other.updatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MemberDetail").add("AccountId", accountId()).add("EmailAddress", emailAddress())
                .add("GraphArn", graphArn()).add("MasterId", masterId()).add("Status", statusAsString())
                .add("InvitedTime", invitedTime()).add("UpdatedTime", updatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "GraphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        case "MasterId":
            return Optional.ofNullable(clazz.cast(masterId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "InvitedTime":
            return Optional.ofNullable(clazz.cast(invitedTime()));
        case "UpdatedTime":
            return Optional.ofNullable(clazz.cast(updatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberDetail, T> g) {
        return obj -> g.apply((MemberDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberDetail> {
        /**
         * <p>
         * The AWS account identifier for the member account.
         * </p>
         * 
         * @param accountId
         *        The AWS account identifier for the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The AWS account root user email address for the member account.
         * </p>
         * 
         * @param emailAddress
         *        The AWS account root user email address for the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The ARN of the behavior graph that the member account was invited to.
         * </p>
         * 
         * @param graphArn
         *        The ARN of the behavior graph that the member account was invited to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);

        /**
         * <p>
         * The AWS account identifier of the master account for the behavior graph.
         * </p>
         * 
         * @param masterId
         *        The AWS account identifier of the master account for the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterId(String masterId);

        /**
         * <p>
         * The current membership status of the member account. The status can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INVITED</code> - Indicates that the member was sent an invitation but has not yet responded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFICATION_IN_PROGRESS</code> - Indicates that Detective is verifying that the account identifier and
         * email address provided for the member account match. If they do match, then Detective sends the invitation.
         * If the email address and account identifier don't match, then the member cannot be added to the behavior
         * graph.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFICATION_FAILED</code> - Indicates that the account and email address provided for the member
         * account do not match, and Detective did not send an invitation to the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - Indicates that the member account accepted the invitation to contribute to the
         * behavior graph.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Member accounts that declined an invitation or that were removed from the behavior graph are not included.
         * </p>
         * 
         * @param status
         *        The current membership status of the member account. The status can have one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INVITED</code> - Indicates that the member was sent an invitation but has not yet responded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFICATION_IN_PROGRESS</code> - Indicates that Detective is verifying that the account
         *        identifier and email address provided for the member account match. If they do match, then Detective
         *        sends the invitation. If the email address and account identifier don't match, then the member cannot
         *        be added to the behavior graph.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFICATION_FAILED</code> - Indicates that the account and email address provided for the
         *        member account do not match, and Detective did not send an invitation to the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Indicates that the member account accepted the invitation to contribute to the
         *        behavior graph.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Member accounts that declined an invitation or that were removed from the behavior graph are not
         *        included.
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current membership status of the member account. The status can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INVITED</code> - Indicates that the member was sent an invitation but has not yet responded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFICATION_IN_PROGRESS</code> - Indicates that Detective is verifying that the account identifier and
         * email address provided for the member account match. If they do match, then Detective sends the invitation.
         * If the email address and account identifier don't match, then the member cannot be added to the behavior
         * graph.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFICATION_FAILED</code> - Indicates that the account and email address provided for the member
         * account do not match, and Detective did not send an invitation to the account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - Indicates that the member account accepted the invitation to contribute to the
         * behavior graph.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Member accounts that declined an invitation or that were removed from the behavior graph are not included.
         * </p>
         * 
         * @param status
         *        The current membership status of the member account. The status can have one of the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INVITED</code> - Indicates that the member was sent an invitation but has not yet responded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFICATION_IN_PROGRESS</code> - Indicates that Detective is verifying that the account
         *        identifier and email address provided for the member account match. If they do match, then Detective
         *        sends the invitation. If the email address and account identifier don't match, then the member cannot
         *        be added to the behavior graph.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFICATION_FAILED</code> - Indicates that the account and email address provided for the
         *        member account do not match, and Detective did not send an invitation to the account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Indicates that the member account accepted the invitation to contribute to the
         *        behavior graph.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Member accounts that declined an invitation or that were removed from the behavior graph are not
         *        included.
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder status(MemberStatus status);

        /**
         * <p>
         * The date and time that Detective sent the invitation to the member account. The value is in milliseconds
         * since the epoch.
         * </p>
         * 
         * @param invitedTime
         *        The date and time that Detective sent the invitation to the member account. The value is in
         *        milliseconds since the epoch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitedTime(Instant invitedTime);

        /**
         * <p>
         * The date and time that the member account was last updated. The value is in milliseconds since the epoch.
         * </p>
         * 
         * @param updatedTime
         *        The date and time that the member account was last updated. The value is in milliseconds since the
         *        epoch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTime(Instant updatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String emailAddress;

        private String graphArn;

        private String masterId;

        private String status;

        private Instant invitedTime;

        private Instant updatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberDetail model) {
            accountId(model.accountId);
            emailAddress(model.emailAddress);
            graphArn(model.graphArn);
            masterId(model.masterId);
            status(model.status);
            invitedTime(model.invitedTime);
            updatedTime(model.updatedTime);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getGraphArn() {
            return graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        public final String getMasterId() {
            return masterId;
        }

        @Override
        public final Builder masterId(String masterId) {
            this.masterId = masterId;
            return this;
        }

        public final void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getInvitedTime() {
            return invitedTime;
        }

        @Override
        public final Builder invitedTime(Instant invitedTime) {
            this.invitedTime = invitedTime;
            return this;
        }

        public final void setInvitedTime(Instant invitedTime) {
            this.invitedTime = invitedTime;
        }

        public final Instant getUpdatedTime() {
            return updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public MemberDetail build() {
            return new MemberDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
