/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMembersResponse extends DetectiveResponse implements
        ToCopyableBuilder<DeleteMembersResponse.Builder, DeleteMembersResponse> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DeleteMembersResponse::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<UnprocessedAccount>> builder(MarshallingType.LIST)
            .getter(getter(DeleteMembersResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            UNPROCESSED_ACCOUNTS_FIELD));

    private final List<String> accountIds;

    private final List<UnprocessedAccount> unprocessedAccounts;

    private DeleteMembersResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * Returns true if the AccountIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of AWS account identifiers for the member accounts that Detective successfully deleted from the behavior
     * graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of AWS account identifiers for the member accounts that Detective successfully deleted from the
     *         behavior graph.
     */
    public List<String> accountIds() {
        return accountIds;
    }

    /**
     * Returns true if the UnprocessedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of member accounts that Detective was not able to delete from the behavior graph. For each member
     * account, provides the reason that the deletion could not be processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of member accounts that Detective was not able to delete from the behavior graph. For each
     *         member account, provides the reason that the deletion could not be processed.
     */
    public List<UnprocessedAccount> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedAccounts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMembersResponse)) {
            return false;
        }
        DeleteMembersResponse other = (DeleteMembersResponse) obj;
        return Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteMembersResponse").add("AccountIds", accountIds())
                .add("UnprocessedAccounts", unprocessedAccounts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "UnprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteMembersResponse, T> g) {
        return obj -> g.apply((DeleteMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteMembersResponse> {
        /**
         * <p>
         * The list of AWS account identifiers for the member accounts that Detective successfully deleted from the
         * behavior graph.
         * </p>
         * 
         * @param accountIds
         *        The list of AWS account identifiers for the member accounts that Detective successfully deleted from
         *        the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The list of AWS account identifiers for the member accounts that Detective successfully deleted from the
         * behavior graph.
         * </p>
         * 
         * @param accountIds
         *        The list of AWS account identifiers for the member accounts that Detective successfully deleted from
         *        the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * The list of member accounts that Detective was not able to delete from the behavior graph. For each member
         * account, provides the reason that the deletion could not be processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The list of member accounts that Detective was not able to delete from the behavior graph. For each
         *        member account, provides the reason that the deletion could not be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts);

        /**
         * <p>
         * The list of member accounts that Detective was not able to delete from the behavior graph. For each member
         * account, provides the reason that the deletion could not be processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The list of member accounts that Detective was not able to delete from the behavior graph. For each
         *        member account, provides the reason that the deletion could not be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts);

        /**
         * <p>
         * The list of member accounts that Detective was not able to delete from the behavior graph. For each member
         * account, provides the reason that the deletion could not be processed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedAccount>.Builder} avoiding the
         * need to create one manually via {@link List<UnprocessedAccount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedAccount>.Builder#build()} is called immediately
         * and its result is passed to {@link #unprocessedAccounts(List<UnprocessedAccount>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on {@link List<UnprocessedAccount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(List<UnprocessedAccount>)
         */
        Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMembersResponse model) {
            super(model);
            accountIds(model.accountIds);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final Collection<String> getAccountIds() {
            return accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        public final Collection<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            return unprocessedAccounts != null ? unprocessedAccounts.stream().map(UnprocessedAccount::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> UnprocessedAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public DeleteMembersResponse build() {
            return new DeleteMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
