/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.services.detective.model.MemberDetail;
import software.amazon.awssdk.services.detective.model.MemberDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMembersResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, ListMembersResponse> {
    private static final SdkField<List<MemberDetail>> MEMBER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberDetails").getter(ListMembersResponse.getter(ListMembersResponse::memberDetails)).setter(ListMembersResponse.setter(Builder::memberDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MemberDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMembersResponse.getter(ListMembersResponse::nextToken)).setter(ListMembersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MemberDetail> memberDetails;
    private final String nextToken;

    private ListMembersResponse(BuilderImpl builder) {
        super(builder);
        this.memberDetails = builder.memberDetails;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMemberDetails() {
        return this.memberDetails != null && !(this.memberDetails instanceof SdkAutoConstructList);
    }

    public List<MemberDetail> memberDetails() {
        return this.memberDetails;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberDetails() ? this.memberDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersResponse)) {
            return false;
        }
        ListMembersResponse other = (ListMembersResponse)((Object)obj);
        return this.hasMemberDetails() == other.hasMemberDetails() && Objects.equals(this.memberDetails(), other.memberDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMembersResponse").add("MemberDetails", this.hasMemberDetails() ? this.memberDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberDetails": {
                return Optional.ofNullable(clazz.cast(this.memberDetails()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMembersResponse, T> g) {
        return obj -> g.apply((ListMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private List<MemberDetail> memberDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersResponse model) {
            super(model);
            this.memberDetails(model.memberDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<MemberDetail.Builder> getMemberDetails() {
            if (this.memberDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberDetails != null ? (Collection)this.memberDetails.stream().map(MemberDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder memberDetails(Collection<MemberDetail> memberDetails) {
            this.memberDetails = MemberDetailListCopier.copy(memberDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDetails(MemberDetail ... memberDetails) {
            this.memberDetails(Arrays.asList(memberDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDetails(Consumer<MemberDetail.Builder> ... memberDetails) {
            this.memberDetails(Stream.of(memberDetails).map(c -> (MemberDetail)((MemberDetail.Builder)MemberDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMemberDetails(Collection<MemberDetail.BuilderImpl> memberDetails) {
            this.memberDetails = MemberDetailListCopier.copyFromBuilder(memberDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMembersResponse build() {
            return new ListMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMembersResponse> {
        public Builder memberDetails(Collection<MemberDetail> var1);

        public Builder memberDetails(MemberDetail ... var1);

        public Builder memberDetails(Consumer<MemberDetail.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

