/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMembersResponse extends DetectiveResponse implements
        ToCopyableBuilder<GetMembersResponse.Builder, GetMembersResponse> {
    private static final SdkField<List<MemberDetail>> MEMBER_DETAILS_FIELD = SdkField
            .<List<MemberDetail>> builder(MarshallingType.LIST)
            .memberName("MemberDetails")
            .getter(getter(GetMembersResponse::memberDetails))
            .setter(setter(Builder::memberDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<UnprocessedAccount>> builder(MarshallingType.LIST)
            .memberName("UnprocessedAccounts")
            .getter(getter(GetMembersResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_DETAILS_FIELD,
            UNPROCESSED_ACCOUNTS_FIELD));

    private final List<MemberDetail> memberDetails;

    private final List<UnprocessedAccount> unprocessedAccounts;

    private GetMembersResponse(BuilderImpl builder) {
        super(builder);
        this.memberDetails = builder.memberDetails;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * Returns true if the MemberDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMemberDetails() {
        return memberDetails != null && !(memberDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The member account details that Detective is returning in response to the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMemberDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The member account details that Detective is returning in response to the request.
     */
    public List<MemberDetail> memberDetails() {
        return memberDetails;
    }

    /**
     * Returns true if the UnprocessedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The requested member accounts for which Detective was unable to return member details.
     * </p>
     * <p>
     * For each account, provides the reason why the request could not be processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The requested member accounts for which Detective was unable to return member details.</p>
     *         <p>
     *         For each account, provides the reason why the request could not be processed.
     */
    public List<UnprocessedAccount> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberDetails() ? memberDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAccounts() ? unprocessedAccounts() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMembersResponse)) {
            return false;
        }
        GetMembersResponse other = (GetMembersResponse) obj;
        return hasMemberDetails() == other.hasMemberDetails() && Objects.equals(memberDetails(), other.memberDetails())
                && hasUnprocessedAccounts() == other.hasUnprocessedAccounts()
                && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMembersResponse").add("MemberDetails", hasMemberDetails() ? memberDetails() : null)
                .add("UnprocessedAccounts", hasUnprocessedAccounts() ? unprocessedAccounts() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberDetails":
            return Optional.ofNullable(clazz.cast(memberDetails()));
        case "UnprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMembersResponse, T> g) {
        return obj -> g.apply((GetMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMembersResponse> {
        /**
         * <p>
         * The member account details that Detective is returning in response to the request.
         * </p>
         * 
         * @param memberDetails
         *        The member account details that Detective is returning in response to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDetails(Collection<MemberDetail> memberDetails);

        /**
         * <p>
         * The member account details that Detective is returning in response to the request.
         * </p>
         * 
         * @param memberDetails
         *        The member account details that Detective is returning in response to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDetails(MemberDetail... memberDetails);

        /**
         * <p>
         * The member account details that Detective is returning in response to the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberDetail>.Builder} avoiding the need to
         * create one manually via {@link List<MemberDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #memberDetails(List<MemberDetail>)}.
         * 
         * @param memberDetails
         *        a consumer that will call methods on {@link List<MemberDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberDetails(List<MemberDetail>)
         */
        Builder memberDetails(Consumer<MemberDetail.Builder>... memberDetails);

        /**
         * <p>
         * The requested member accounts for which Detective was unable to return member details.
         * </p>
         * <p>
         * For each account, provides the reason why the request could not be processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The requested member accounts for which Detective was unable to return member details.</p>
         *        <p>
         *        For each account, provides the reason why the request could not be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts);

        /**
         * <p>
         * The requested member accounts for which Detective was unable to return member details.
         * </p>
         * <p>
         * For each account, provides the reason why the request could not be processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The requested member accounts for which Detective was unable to return member details.</p>
         *        <p>
         *        For each account, provides the reason why the request could not be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts);

        /**
         * <p>
         * The requested member accounts for which Detective was unable to return member details.
         * </p>
         * <p>
         * For each account, provides the reason why the request could not be processed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedAccount>.Builder} avoiding the
         * need to create one manually via {@link List<UnprocessedAccount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedAccount>.Builder#build()} is called immediately
         * and its result is passed to {@link #unprocessedAccounts(List<UnprocessedAccount>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on {@link List<UnprocessedAccount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(List<UnprocessedAccount>)
         */
        Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private List<MemberDetail> memberDetails = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMembersResponse model) {
            super(model);
            memberDetails(model.memberDetails);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final Collection<MemberDetail.Builder> getMemberDetails() {
            if (memberDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return memberDetails != null ? memberDetails.stream().map(MemberDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder memberDetails(Collection<MemberDetail> memberDetails) {
            this.memberDetails = MemberDetailListCopier.copy(memberDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDetails(MemberDetail... memberDetails) {
            memberDetails(Arrays.asList(memberDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDetails(Consumer<MemberDetail.Builder>... memberDetails) {
            memberDetails(Stream.of(memberDetails).map(c -> MemberDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMemberDetails(Collection<MemberDetail.BuilderImpl> memberDetails) {
            this.memberDetails = MemberDetailListCopier.copyFromBuilder(memberDetails);
        }

        public final Collection<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            if (unprocessedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return unprocessedAccounts != null ? unprocessedAccounts.stream().map(UnprocessedAccount::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> UnprocessedAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public GetMembersResponse build() {
            return new GetMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
