/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMembersResponse extends DetectiveResponse implements
        ToCopyableBuilder<ListMembersResponse.Builder, ListMembersResponse> {
    private static final SdkField<List<MemberDetail>> MEMBER_DETAILS_FIELD = SdkField
            .<List<MemberDetail>> builder(MarshallingType.LIST)
            .memberName("MemberDetails")
            .getter(getter(ListMembersResponse::memberDetails))
            .setter(setter(Builder::memberDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMembersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MemberDetail> memberDetails;

    private final String nextToken;

    private ListMembersResponse(BuilderImpl builder) {
        super(builder);
        this.memberDetails = builder.memberDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberDetails() {
        return memberDetails != null && !(memberDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of member accounts in the behavior graph.
     * </p>
     * <p>
     * For invited accounts, the results include member accounts that did not pass verification and member accounts that
     * have not yet accepted the invitation to the behavior graph. The results do not include member accounts that were
     * removed from the behavior graph.
     * </p>
     * <p>
     * For the organization behavior graph, the results do not include organization accounts that the Detective
     * administrator account has not enabled as member accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberDetails} method.
     * </p>
     * 
     * @return The list of member accounts in the behavior graph.</p>
     *         <p>
     *         For invited accounts, the results include member accounts that did not pass verification and member
     *         accounts that have not yet accepted the invitation to the behavior graph. The results do not include
     *         member accounts that were removed from the behavior graph.
     *         </p>
     *         <p>
     *         For the organization behavior graph, the results do not include organization accounts that the Detective
     *         administrator account has not enabled as member accounts.
     */
    public final List<MemberDetail> memberDetails() {
        return memberDetails;
    }

    /**
     * <p>
     * If there are more member accounts remaining in the results, then use this pagination token to request the next
     * page of member accounts.
     * </p>
     * 
     * @return If there are more member accounts remaining in the results, then use this pagination token to request the
     *         next page of member accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberDetails() ? memberDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersResponse)) {
            return false;
        }
        ListMembersResponse other = (ListMembersResponse) obj;
        return hasMemberDetails() == other.hasMemberDetails() && Objects.equals(memberDetails(), other.memberDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMembersResponse").add("MemberDetails", hasMemberDetails() ? memberDetails() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberDetails":
            return Optional.ofNullable(clazz.cast(memberDetails()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMembersResponse, T> g) {
        return obj -> g.apply((ListMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMembersResponse> {
        /**
         * <p>
         * The list of member accounts in the behavior graph.
         * </p>
         * <p>
         * For invited accounts, the results include member accounts that did not pass verification and member accounts
         * that have not yet accepted the invitation to the behavior graph. The results do not include member accounts
         * that were removed from the behavior graph.
         * </p>
         * <p>
         * For the organization behavior graph, the results do not include organization accounts that the Detective
         * administrator account has not enabled as member accounts.
         * </p>
         * 
         * @param memberDetails
         *        The list of member accounts in the behavior graph.</p>
         *        <p>
         *        For invited accounts, the results include member accounts that did not pass verification and member
         *        accounts that have not yet accepted the invitation to the behavior graph. The results do not include
         *        member accounts that were removed from the behavior graph.
         *        </p>
         *        <p>
         *        For the organization behavior graph, the results do not include organization accounts that the
         *        Detective administrator account has not enabled as member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDetails(Collection<MemberDetail> memberDetails);

        /**
         * <p>
         * The list of member accounts in the behavior graph.
         * </p>
         * <p>
         * For invited accounts, the results include member accounts that did not pass verification and member accounts
         * that have not yet accepted the invitation to the behavior graph. The results do not include member accounts
         * that were removed from the behavior graph.
         * </p>
         * <p>
         * For the organization behavior graph, the results do not include organization accounts that the Detective
         * administrator account has not enabled as member accounts.
         * </p>
         * 
         * @param memberDetails
         *        The list of member accounts in the behavior graph.</p>
         *        <p>
         *        For invited accounts, the results include member accounts that did not pass verification and member
         *        accounts that have not yet accepted the invitation to the behavior graph. The results do not include
         *        member accounts that were removed from the behavior graph.
         *        </p>
         *        <p>
         *        For the organization behavior graph, the results do not include organization accounts that the
         *        Detective administrator account has not enabled as member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDetails(MemberDetail... memberDetails);

        /**
         * <p>
         * The list of member accounts in the behavior graph.
         * </p>
         * <p>
         * For invited accounts, the results include member accounts that did not pass verification and member accounts
         * that have not yet accepted the invitation to the behavior graph. The results do not include member accounts
         * that were removed from the behavior graph.
         * </p>
         * <p>
         * For the organization behavior graph, the results do not include organization accounts that the Detective
         * administrator account has not enabled as member accounts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberDetail>.Builder} avoiding the need to
         * create one manually via {@link List<MemberDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #memberDetails(List<MemberDetail>)}.
         * 
         * @param memberDetails
         *        a consumer that will call methods on {@link List<MemberDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberDetails(List<MemberDetail>)
         */
        Builder memberDetails(Consumer<MemberDetail.Builder>... memberDetails);

        /**
         * <p>
         * If there are more member accounts remaining in the results, then use this pagination token to request the
         * next page of member accounts.
         * </p>
         * 
         * @param nextToken
         *        If there are more member accounts remaining in the results, then use this pagination token to request
         *        the next page of member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private List<MemberDetail> memberDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersResponse model) {
            super(model);
            memberDetails(model.memberDetails);
            nextToken(model.nextToken);
        }

        public final List<MemberDetail.Builder> getMemberDetails() {
            List<MemberDetail.Builder> result = MemberDetailListCopier.copyToBuilder(this.memberDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberDetails(Collection<MemberDetail.BuilderImpl> memberDetails) {
            this.memberDetails = MemberDetailListCopier.copyFromBuilder(memberDetails);
        }

        @Override
        @Transient
        public final Builder memberDetails(Collection<MemberDetail> memberDetails) {
            this.memberDetails = MemberDetailListCopier.copy(memberDetails);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder memberDetails(MemberDetail... memberDetails) {
            memberDetails(Arrays.asList(memberDetails));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder memberDetails(Consumer<MemberDetail.Builder>... memberDetails) {
            memberDetails(Stream.of(memberDetails).map(c -> MemberDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMembersResponse build() {
            return new ListMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
