/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMembersResponse extends DetectiveResponse implements
        ToCopyableBuilder<CreateMembersResponse.Builder, CreateMembersResponse> {
    private static final SdkField<List<MemberDetail>> MEMBERS_FIELD = SdkField
            .<List<MemberDetail>> builder(MarshallingType.LIST)
            .memberName("Members")
            .getter(getter(CreateMembersResponse::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<UnprocessedAccount>> builder(MarshallingType.LIST)
            .memberName("UnprocessedAccounts")
            .getter(getter(CreateMembersResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD,
            UNPROCESSED_ACCOUNTS_FIELD));

    private final List<MemberDetail> members;

    private final List<UnprocessedAccount> unprocessedAccounts;

    private CreateMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * Returns true if the Members property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of member account invitation requests that Detective was able to process. This includes accounts that are
     * being verified, that failed verification, and that passed verification and are being sent an invitation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMembers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The set of member account invitation requests that Detective was able to process. This includes accounts
     *         that are being verified, that failed verification, and that passed verification and are being sent an
     *         invitation.
     */
    public final List<MemberDetail> members() {
        return members;
    }

    /**
     * Returns true if the UnprocessedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of accounts for which Detective was unable to process the invitation request. For each account, the list
     * provides the reason why the request could not be processed. The list includes accounts that are already member
     * accounts in the behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of accounts for which Detective was unable to process the invitation request. For each account,
     *         the list provides the reason why the request could not be processed. The list includes accounts that are
     *         already member accounts in the behavior graph.
     */
    public final List<UnprocessedAccount> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMembers() ? members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAccounts() ? unprocessedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembersResponse)) {
            return false;
        }
        CreateMembersResponse other = (CreateMembersResponse) obj;
        return hasMembers() == other.hasMembers() && Objects.equals(members(), other.members())
                && hasUnprocessedAccounts() == other.hasUnprocessedAccounts()
                && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMembersResponse").add("Members", hasMembers() ? members() : null)
                .add("UnprocessedAccounts", hasUnprocessedAccounts() ? unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Members":
            return Optional.ofNullable(clazz.cast(members()));
        case "UnprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMembersResponse, T> g) {
        return obj -> g.apply((CreateMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateMembersResponse> {
        /**
         * <p>
         * The set of member account invitation requests that Detective was able to process. This includes accounts that
         * are being verified, that failed verification, and that passed verification and are being sent an invitation.
         * </p>
         * 
         * @param members
         *        The set of member account invitation requests that Detective was able to process. This includes
         *        accounts that are being verified, that failed verification, and that passed verification and are being
         *        sent an invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<MemberDetail> members);

        /**
         * <p>
         * The set of member account invitation requests that Detective was able to process. This includes accounts that
         * are being verified, that failed verification, and that passed verification and are being sent an invitation.
         * </p>
         * 
         * @param members
         *        The set of member account invitation requests that Detective was able to process. This includes
         *        accounts that are being verified, that failed verification, and that passed verification and are being
         *        sent an invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(MemberDetail... members);

        /**
         * <p>
         * The set of member account invitation requests that Detective was able to process. This includes accounts that
         * are being verified, that failed verification, and that passed verification and are being sent an invitation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberDetail>.Builder} avoiding the need to
         * create one manually via {@link List<MemberDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #members(List<MemberDetail>)}.
         * 
         * @param members
         *        a consumer that will call methods on {@link List<MemberDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(List<MemberDetail>)
         */
        Builder members(Consumer<MemberDetail.Builder>... members);

        /**
         * <p>
         * The list of accounts for which Detective was unable to process the invitation request. For each account, the
         * list provides the reason why the request could not be processed. The list includes accounts that are already
         * member accounts in the behavior graph.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The list of accounts for which Detective was unable to process the invitation request. For each
         *        account, the list provides the reason why the request could not be processed. The list includes
         *        accounts that are already member accounts in the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts);

        /**
         * <p>
         * The list of accounts for which Detective was unable to process the invitation request. For each account, the
         * list provides the reason why the request could not be processed. The list includes accounts that are already
         * member accounts in the behavior graph.
         * </p>
         * 
         * @param unprocessedAccounts
         *        The list of accounts for which Detective was unable to process the invitation request. For each
         *        account, the list provides the reason why the request could not be processed. The list includes
         *        accounts that are already member accounts in the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts);

        /**
         * <p>
         * The list of accounts for which Detective was unable to process the invitation request. For each account, the
         * list provides the reason why the request could not be processed. The list includes accounts that are already
         * member accounts in the behavior graph.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedAccount>.Builder} avoiding the
         * need to create one manually via {@link List<UnprocessedAccount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedAccount>.Builder#build()} is called immediately
         * and its result is passed to {@link #unprocessedAccounts(List<UnprocessedAccount>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on {@link List<UnprocessedAccount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(List<UnprocessedAccount>)
         */
        Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private List<MemberDetail> members = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembersResponse model) {
            super(model);
            members(model.members);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final List<MemberDetail.Builder> getMembers() {
            List<MemberDetail.Builder> result = MemberDetailListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<MemberDetail.BuilderImpl> members) {
            this.members = MemberDetailListCopier.copyFromBuilder(members);
        }

        @Override
        @Transient
        public final Builder members(Collection<MemberDetail> members) {
            this.members = MemberDetailListCopier.copy(members);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder members(MemberDetail... members) {
            members(Arrays.asList(members));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder members(Consumer<MemberDetail.Builder>... members) {
            members(Stream.of(members).map(c -> MemberDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            List<UnprocessedAccount.Builder> result = UnprocessedAccountListCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        @Transient
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> UnprocessedAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateMembersResponse build() {
            return new CreateMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
