/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetGraphMemberDatasourcesResponse extends DetectiveResponse implements
        ToCopyableBuilder<BatchGetGraphMemberDatasourcesResponse.Builder, BatchGetGraphMemberDatasourcesResponse> {
    private static final SdkField<List<MembershipDatasources>> MEMBER_DATASOURCES_FIELD = SdkField
            .<List<MembershipDatasources>> builder(MarshallingType.LIST)
            .memberName("MemberDatasources")
            .getter(getter(BatchGetGraphMemberDatasourcesResponse::memberDatasources))
            .setter(setter(Builder::memberDatasources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDatasources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MembershipDatasources> builder(MarshallingType.SDK_POJO)
                                            .constructor(MembershipDatasources::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<UnprocessedAccount>> builder(MarshallingType.LIST)
            .memberName("UnprocessedAccounts")
            .getter(getter(BatchGetGraphMemberDatasourcesResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_DATASOURCES_FIELD,
            UNPROCESSED_ACCOUNTS_FIELD));

    private final List<MembershipDatasources> memberDatasources;

    private final List<UnprocessedAccount> unprocessedAccounts;

    private BatchGetGraphMemberDatasourcesResponse(BuilderImpl builder) {
        super(builder);
        this.memberDatasources = builder.memberDatasources;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the MemberDatasources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMemberDatasources() {
        return memberDatasources != null && !(memberDatasources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the status of data source packages for members of the behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMemberDatasources} method.
     * </p>
     * 
     * @return Details on the status of data source packages for members of the behavior graph.
     */
    public final List<MembershipDatasources> memberDatasources() {
        return memberDatasources;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedAccounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Accounts that data source package information could not be retrieved for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedAccounts} method.
     * </p>
     * 
     * @return Accounts that data source package information could not be retrieved for.
     */
    public final List<UnprocessedAccount> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberDatasources() ? memberDatasources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAccounts() ? unprocessedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetGraphMemberDatasourcesResponse)) {
            return false;
        }
        BatchGetGraphMemberDatasourcesResponse other = (BatchGetGraphMemberDatasourcesResponse) obj;
        return hasMemberDatasources() == other.hasMemberDatasources()
                && Objects.equals(memberDatasources(), other.memberDatasources())
                && hasUnprocessedAccounts() == other.hasUnprocessedAccounts()
                && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetGraphMemberDatasourcesResponse")
                .add("MemberDatasources", hasMemberDatasources() ? memberDatasources() : null)
                .add("UnprocessedAccounts", hasUnprocessedAccounts() ? unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberDatasources":
            return Optional.ofNullable(clazz.cast(memberDatasources()));
        case "UnprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetGraphMemberDatasourcesResponse, T> g) {
        return obj -> g.apply((BatchGetGraphMemberDatasourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetGraphMemberDatasourcesResponse> {
        /**
         * <p>
         * Details on the status of data source packages for members of the behavior graph.
         * </p>
         * 
         * @param memberDatasources
         *        Details on the status of data source packages for members of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDatasources(Collection<MembershipDatasources> memberDatasources);

        /**
         * <p>
         * Details on the status of data source packages for members of the behavior graph.
         * </p>
         * 
         * @param memberDatasources
         *        Details on the status of data source packages for members of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDatasources(MembershipDatasources... memberDatasources);

        /**
         * <p>
         * Details on the status of data source packages for members of the behavior graph.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MembershipDatasources>.Builder}
         * avoiding the need to create one manually via {@link List<MembershipDatasources>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MembershipDatasources>.Builder#build()} is called
         * immediately and its result is passed to {@link #memberDatasources(List<MembershipDatasources>)}.
         * 
         * @param memberDatasources
         *        a consumer that will call methods on {@link List<MembershipDatasources>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberDatasources(List<MembershipDatasources>)
         */
        Builder memberDatasources(Consumer<MembershipDatasources.Builder>... memberDatasources);

        /**
         * <p>
         * Accounts that data source package information could not be retrieved for.
         * </p>
         * 
         * @param unprocessedAccounts
         *        Accounts that data source package information could not be retrieved for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts);

        /**
         * <p>
         * Accounts that data source package information could not be retrieved for.
         * </p>
         * 
         * @param unprocessedAccounts
         *        Accounts that data source package information could not be retrieved for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts);

        /**
         * <p>
         * Accounts that data source package information could not be retrieved for.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<UnprocessedAccount>.Builder}
         * avoiding the need to create one manually via {@link List<UnprocessedAccount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedAccount>.Builder#build()} is called immediately
         * and its result is passed to {@link #unprocessedAccounts(List<UnprocessedAccount>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on {@link List<UnprocessedAccount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(List<UnprocessedAccount>)
         */
        Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private List<MembershipDatasources> memberDatasources = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetGraphMemberDatasourcesResponse model) {
            super(model);
            memberDatasources(model.memberDatasources);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final List<MembershipDatasources.Builder> getMemberDatasources() {
            List<MembershipDatasources.Builder> result = MembershipDatasourcesListCopier.copyToBuilder(this.memberDatasources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberDatasources(Collection<MembershipDatasources.BuilderImpl> memberDatasources) {
            this.memberDatasources = MembershipDatasourcesListCopier.copyFromBuilder(memberDatasources);
        }

        @Override
        public final Builder memberDatasources(Collection<MembershipDatasources> memberDatasources) {
            this.memberDatasources = MembershipDatasourcesListCopier.copy(memberDatasources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDatasources(MembershipDatasources... memberDatasources) {
            memberDatasources(Arrays.asList(memberDatasources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDatasources(Consumer<MembershipDatasources.Builder>... memberDatasources) {
            memberDatasources(Stream.of(memberDatasources).map(c -> MembershipDatasources.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            List<UnprocessedAccount.Builder> result = UnprocessedAccountListCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> UnprocessedAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetGraphMemberDatasourcesResponse build() {
            return new BatchGetGraphMemberDatasourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
