/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOrganizationAdminAccountsResponse extends DetectiveResponse implements
        ToCopyableBuilder<ListOrganizationAdminAccountsResponse.Builder, ListOrganizationAdminAccountsResponse> {
    private static final SdkField<List<Administrator>> ADMINISTRATORS_FIELD = SdkField
            .<List<Administrator>> builder(MarshallingType.LIST)
            .memberName("Administrators")
            .getter(getter(ListOrganizationAdminAccountsResponse::administrators))
            .setter(setter(Builder::administrators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Administrators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Administrator> builder(MarshallingType.SDK_POJO)
                                            .constructor(Administrator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOrganizationAdminAccountsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMINISTRATORS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Administrator> administrators;

    private final String nextToken;

    private ListOrganizationAdminAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.administrators = builder.administrators;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Administrators property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdministrators() {
        return administrators != null && !(administrators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Detective administrator accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdministrators} method.
     * </p>
     * 
     * @return The list of Detective administrator accounts.
     */
    public final List<Administrator> administrators() {
        return administrators;
    }

    /**
     * <p>
     * If there are more accounts remaining in the results, then this is the pagination token to use to request the next
     * page of accounts.
     * </p>
     * 
     * @return If there are more accounts remaining in the results, then this is the pagination token to use to request
     *         the next page of accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdministrators() ? administrators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationAdminAccountsResponse)) {
            return false;
        }
        ListOrganizationAdminAccountsResponse other = (ListOrganizationAdminAccountsResponse) obj;
        return hasAdministrators() == other.hasAdministrators() && Objects.equals(administrators(), other.administrators())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOrganizationAdminAccountsResponse")
                .add("Administrators", hasAdministrators() ? administrators() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Administrators":
            return Optional.ofNullable(clazz.cast(administrators()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationAdminAccountsResponse, T> g) {
        return obj -> g.apply((ListOrganizationAdminAccountsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOrganizationAdminAccountsResponse> {
        /**
         * <p>
         * The list of Detective administrator accounts.
         * </p>
         * 
         * @param administrators
         *        The list of Detective administrator accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrators(Collection<Administrator> administrators);

        /**
         * <p>
         * The list of Detective administrator accounts.
         * </p>
         * 
         * @param administrators
         *        The list of Detective administrator accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrators(Administrator... administrators);

        /**
         * <p>
         * The list of Detective administrator accounts.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Administrator>.Builder} avoiding the
         * need to create one manually via {@link List<Administrator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Administrator>.Builder#build()} is called immediately and
         * its result is passed to {@link #administrators(List<Administrator>)}.
         * 
         * @param administrators
         *        a consumer that will call methods on {@link List<Administrator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #administrators(List<Administrator>)
         */
        Builder administrators(Consumer<Administrator.Builder>... administrators);

        /**
         * <p>
         * If there are more accounts remaining in the results, then this is the pagination token to use to request the
         * next page of accounts.
         * </p>
         * 
         * @param nextToken
         *        If there are more accounts remaining in the results, then this is the pagination token to use to
         *        request the next page of accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private List<Administrator> administrators = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationAdminAccountsResponse model) {
            super(model);
            administrators(model.administrators);
            nextToken(model.nextToken);
        }

        public final List<Administrator.Builder> getAdministrators() {
            List<Administrator.Builder> result = AdministratorListCopier.copyToBuilder(this.administrators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdministrators(Collection<Administrator.BuilderImpl> administrators) {
            this.administrators = AdministratorListCopier.copyFromBuilder(administrators);
        }

        @Override
        public final Builder administrators(Collection<Administrator> administrators) {
            this.administrators = AdministratorListCopier.copy(administrators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrators(Administrator... administrators) {
            administrators(Arrays.asList(administrators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder administrators(Consumer<Administrator.Builder>... administrators) {
            administrators(Stream.of(administrators).map(c -> Administrator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOrganizationAdminAccountsResponse build() {
            return new ListOrganizationAdminAccountsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
