/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Detective administrator account for an organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Administrator implements SdkPojo, Serializable, ToCopyableBuilder<Administrator.Builder, Administrator> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Administrator::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GraphArn").getter(getter(Administrator::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()).build();

    private static final SdkField<Instant> DELEGATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DelegationTime")
            .getter(getter(Administrator::delegationTime))
            .setter(setter(Builder::delegationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            GRAPH_ARN_FIELD, DELEGATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String graphArn;

    private final Instant delegationTime;

    private Administrator(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.graphArn = builder.graphArn;
        this.delegationTime = builder.delegationTime;
    }

    /**
     * <p>
     * The Amazon Web Services account identifier of the Detective administrator account for the organization.
     * </p>
     * 
     * @return The Amazon Web Services account identifier of the Detective administrator account for the organization.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ARN of the organization behavior graph.
     * </p>
     * 
     * @return The ARN of the organization behavior graph.
     */
    public final String graphArn() {
        return graphArn;
    }

    /**
     * <p>
     * The date and time when the Detective administrator account was enabled. The value is an ISO8601 formatted string.
     * For example, <code>2021-08-18T16:35:56.284Z</code>.
     * </p>
     * 
     * @return The date and time when the Detective administrator account was enabled. The value is an ISO8601 formatted
     *         string. For example, <code>2021-08-18T16:35:56.284Z</code>.
     */
    public final Instant delegationTime() {
        return delegationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(delegationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Administrator)) {
            return false;
        }
        Administrator other = (Administrator) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(graphArn(), other.graphArn())
                && Objects.equals(delegationTime(), other.delegationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Administrator").add("AccountId", accountId()).add("GraphArn", graphArn())
                .add("DelegationTime", delegationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "GraphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        case "DelegationTime":
            return Optional.ofNullable(clazz.cast(delegationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Administrator, T> g) {
        return obj -> g.apply((Administrator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Administrator> {
        /**
         * <p>
         * The Amazon Web Services account identifier of the Detective administrator account for the organization.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account identifier of the Detective administrator account for the
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ARN of the organization behavior graph.
         * </p>
         * 
         * @param graphArn
         *        The ARN of the organization behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);

        /**
         * <p>
         * The date and time when the Detective administrator account was enabled. The value is an ISO8601 formatted
         * string. For example, <code>2021-08-18T16:35:56.284Z</code>.
         * </p>
         * 
         * @param delegationTime
         *        The date and time when the Detective administrator account was enabled. The value is an ISO8601
         *        formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationTime(Instant delegationTime);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String graphArn;

        private Instant delegationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Administrator model) {
            accountId(model.accountId);
            graphArn(model.graphArn);
            delegationTime(model.delegationTime);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getGraphArn() {
            return graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final Instant getDelegationTime() {
            return delegationTime;
        }

        public final void setDelegationTime(Instant delegationTime) {
            this.delegationTime = delegationTime;
        }

        @Override
        public final Builder delegationTime(Instant delegationTime) {
            this.delegationTime = delegationTime;
            return this;
        }

        @Override
        public Administrator build() {
            return new Administrator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
