/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.services.detective.model.MembershipDatasources;
import software.amazon.awssdk.services.detective.model.MembershipDatasourcesListCopier;
import software.amazon.awssdk.services.detective.model.UnprocessedGraph;
import software.amazon.awssdk.services.detective.model.UnprocessedGraphListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetMembershipDatasourcesResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, BatchGetMembershipDatasourcesResponse> {
    private static final SdkField<List<MembershipDatasources>> MEMBERSHIP_DATASOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MembershipDatasources").getter(BatchGetMembershipDatasourcesResponse.getter(BatchGetMembershipDatasourcesResponse::membershipDatasources)).setter(BatchGetMembershipDatasourcesResponse.setter(Builder::membershipDatasources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipDatasources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MembershipDatasources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedGraph>> UNPROCESSED_GRAPHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedGraphs").getter(BatchGetMembershipDatasourcesResponse.getter(BatchGetMembershipDatasourcesResponse::unprocessedGraphs)).setter(BatchGetMembershipDatasourcesResponse.setter(Builder::unprocessedGraphs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedGraphs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedGraph::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_DATASOURCES_FIELD, UNPROCESSED_GRAPHS_FIELD));
    private final List<MembershipDatasources> membershipDatasources;
    private final List<UnprocessedGraph> unprocessedGraphs;

    private BatchGetMembershipDatasourcesResponse(BuilderImpl builder) {
        super(builder);
        this.membershipDatasources = builder.membershipDatasources;
        this.unprocessedGraphs = builder.unprocessedGraphs;
    }

    public final boolean hasMembershipDatasources() {
        return this.membershipDatasources != null && !(this.membershipDatasources instanceof SdkAutoConstructList);
    }

    public final List<MembershipDatasources> membershipDatasources() {
        return this.membershipDatasources;
    }

    public final boolean hasUnprocessedGraphs() {
        return this.unprocessedGraphs != null && !(this.unprocessedGraphs instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedGraph> unprocessedGraphs() {
        return this.unprocessedGraphs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembershipDatasources() ? this.membershipDatasources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedGraphs() ? this.unprocessedGraphs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMembershipDatasourcesResponse)) {
            return false;
        }
        BatchGetMembershipDatasourcesResponse other = (BatchGetMembershipDatasourcesResponse)((Object)obj);
        return this.hasMembershipDatasources() == other.hasMembershipDatasources() && Objects.equals(this.membershipDatasources(), other.membershipDatasources()) && this.hasUnprocessedGraphs() == other.hasUnprocessedGraphs() && Objects.equals(this.unprocessedGraphs(), other.unprocessedGraphs());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetMembershipDatasourcesResponse").add("MembershipDatasources", this.hasMembershipDatasources() ? this.membershipDatasources() : null).add("UnprocessedGraphs", this.hasUnprocessedGraphs() ? this.unprocessedGraphs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MembershipDatasources": {
                return Optional.ofNullable(clazz.cast(this.membershipDatasources()));
            }
            case "UnprocessedGraphs": {
                return Optional.ofNullable(clazz.cast(this.unprocessedGraphs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMembershipDatasourcesResponse, T> g) {
        return obj -> g.apply((BatchGetMembershipDatasourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private List<MembershipDatasources> membershipDatasources = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedGraph> unprocessedGraphs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMembershipDatasourcesResponse model) {
            super(model);
            this.membershipDatasources(model.membershipDatasources);
            this.unprocessedGraphs(model.unprocessedGraphs);
        }

        public final List<MembershipDatasources.Builder> getMembershipDatasources() {
            List<MembershipDatasources.Builder> result = MembershipDatasourcesListCopier.copyToBuilder(this.membershipDatasources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembershipDatasources(Collection<MembershipDatasources.BuilderImpl> membershipDatasources) {
            this.membershipDatasources = MembershipDatasourcesListCopier.copyFromBuilder(membershipDatasources);
        }

        @Override
        public final Builder membershipDatasources(Collection<MembershipDatasources> membershipDatasources) {
            this.membershipDatasources = MembershipDatasourcesListCopier.copy(membershipDatasources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipDatasources(MembershipDatasources ... membershipDatasources) {
            this.membershipDatasources(Arrays.asList(membershipDatasources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipDatasources(Consumer<MembershipDatasources.Builder> ... membershipDatasources) {
            this.membershipDatasources(Stream.of(membershipDatasources).map(c -> (MembershipDatasources)((MembershipDatasources.Builder)MembershipDatasources.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedGraph.Builder> getUnprocessedGraphs() {
            List<UnprocessedGraph.Builder> result = UnprocessedGraphListCopier.copyToBuilder(this.unprocessedGraphs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedGraphs(Collection<UnprocessedGraph.BuilderImpl> unprocessedGraphs) {
            this.unprocessedGraphs = UnprocessedGraphListCopier.copyFromBuilder(unprocessedGraphs);
        }

        @Override
        public final Builder unprocessedGraphs(Collection<UnprocessedGraph> unprocessedGraphs) {
            this.unprocessedGraphs = UnprocessedGraphListCopier.copy(unprocessedGraphs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedGraphs(UnprocessedGraph ... unprocessedGraphs) {
            this.unprocessedGraphs(Arrays.asList(unprocessedGraphs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedGraphs(Consumer<UnprocessedGraph.Builder> ... unprocessedGraphs) {
            this.unprocessedGraphs(Stream.of(unprocessedGraphs).map(c -> (UnprocessedGraph)((UnprocessedGraph.Builder)UnprocessedGraph.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetMembershipDatasourcesResponse build() {
            return new BatchGetMembershipDatasourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetMembershipDatasourcesResponse> {
        public Builder membershipDatasources(Collection<MembershipDatasources> var1);

        public Builder membershipDatasources(MembershipDatasources ... var1);

        public Builder membershipDatasources(Consumer<MembershipDatasources.Builder> ... var1);

        public Builder unprocessedGraphs(Collection<UnprocessedGraph> var1);

        public Builder unprocessedGraphs(UnprocessedGraph ... var1);

        public Builder unprocessedGraphs(Consumer<UnprocessedGraph.Builder> ... var1);
    }
}

