/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class LastIngestStateChangeDatesCopier {
    static Map<String, TimestampForCollection> copy(Map<String, ? extends TimestampForCollection> lastIngestStateChangeDatesParam) {
        Map<String, TimestampForCollection> map;
        if (lastIngestStateChangeDatesParam == null || lastIngestStateChangeDatesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, TimestampForCollection> modifiableMap = new LinkedHashMap<>();
            lastIngestStateChangeDatesParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, TimestampForCollection> copyFromBuilder(
            Map<String, ? extends TimestampForCollection.Builder> lastIngestStateChangeDatesParam) {
        Map<String, TimestampForCollection> map;
        if (lastIngestStateChangeDatesParam == null || lastIngestStateChangeDatesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, TimestampForCollection> modifiableMap = new LinkedHashMap<>();
            lastIngestStateChangeDatesParam.forEach((key, value) -> {
                TimestampForCollection member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, TimestampForCollection.Builder> copyToBuilder(
            Map<String, ? extends TimestampForCollection> lastIngestStateChangeDatesParam) {
        Map<String, TimestampForCollection.Builder> map;
        if (lastIngestStateChangeDatesParam == null || lastIngestStateChangeDatesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, TimestampForCollection.Builder> modifiableMap = new LinkedHashMap<>();
            lastIngestStateChangeDatesParam.forEach((key, value) -> {
                TimestampForCollection.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, TimestampForCollection> copyEnumToString(
            Map<DatasourcePackageIngestState, ? extends TimestampForCollection> lastIngestStateChangeDatesParam) {
        Map<String, TimestampForCollection> map;
        if (lastIngestStateChangeDatesParam == null || lastIngestStateChangeDatesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, TimestampForCollection> modifiableMap = new LinkedHashMap<>();
            lastIngestStateChangeDatesParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<DatasourcePackageIngestState, TimestampForCollection> copyStringToEnum(
            Map<String, ? extends TimestampForCollection> lastIngestStateChangeDatesParam) {
        Map<DatasourcePackageIngestState, TimestampForCollection> map;
        if (lastIngestStateChangeDatesParam == null || lastIngestStateChangeDatesParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<DatasourcePackageIngestState, TimestampForCollection> modifiableMap = new LinkedHashMap<>();
            lastIngestStateChangeDatesParam.forEach((key, value) -> {
                DatasourcePackageIngestState result = DatasourcePackageIngestState.fromValue(key);
                if (result != DatasourcePackageIngestState.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
