/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.detective.DetectiveClient;
import software.amazon.awssdk.services.detective.internal.UserAgentUtils;
import software.amazon.awssdk.services.detective.model.ListInvitationsRequest;
import software.amazon.awssdk.services.detective.model.ListInvitationsResponse;

public class ListInvitationsIterable
implements SdkIterable<ListInvitationsResponse> {
    private final DetectiveClient client;
    private final ListInvitationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInvitationsIterable(DetectiveClient client, ListInvitationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInvitationsResponseFetcher();
    }

    public Iterator<ListInvitationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListInvitationsResponseFetcher
    implements SyncPageFetcher<ListInvitationsResponse> {
        private ListInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInvitationsResponse nextPage(ListInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvitationsIterable.this.client.listInvitations(ListInvitationsIterable.this.firstRequest);
            }
            return ListInvitationsIterable.this.client.listInvitations((ListInvitationsRequest)((Object)ListInvitationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

