/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Investigations triages indicators of compromises such as a finding and surfaces only the most critical and suspicious
 * issues, so you can focus on high-level investigations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Indicator implements SdkPojo, Serializable, ToCopyableBuilder<Indicator.Builder, Indicator> {
    private static final SdkField<String> INDICATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndicatorType").getter(getter(Indicator::indicatorTypeAsString)).setter(setter(Builder::indicatorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndicatorType").build()).build();

    private static final SdkField<IndicatorDetail> INDICATOR_DETAIL_FIELD = SdkField
            .<IndicatorDetail> builder(MarshallingType.SDK_POJO).memberName("IndicatorDetail")
            .getter(getter(Indicator::indicatorDetail)).setter(setter(Builder::indicatorDetail))
            .constructor(IndicatorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndicatorDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDICATOR_TYPE_FIELD,
            INDICATOR_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indicatorType;

    private final IndicatorDetail indicatorDetail;

    private Indicator(BuilderImpl builder) {
        this.indicatorType = builder.indicatorType;
        this.indicatorDetail = builder.indicatorDetail;
    }

    /**
     * <p>
     * The type of indicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indicatorType}
     * will return {@link IndicatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indicatorTypeAsString}.
     * </p>
     * 
     * @return The type of indicator.
     * @see IndicatorType
     */
    public final IndicatorType indicatorType() {
        return IndicatorType.fromValue(indicatorType);
    }

    /**
     * <p>
     * The type of indicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indicatorType}
     * will return {@link IndicatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indicatorTypeAsString}.
     * </p>
     * 
     * @return The type of indicator.
     * @see IndicatorType
     */
    public final String indicatorTypeAsString() {
        return indicatorType;
    }

    /**
     * <p>
     * Details about the indicator of compromise.
     * </p>
     * 
     * @return Details about the indicator of compromise.
     */
    public final IndicatorDetail indicatorDetail() {
        return indicatorDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indicatorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(indicatorDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Indicator)) {
            return false;
        }
        Indicator other = (Indicator) obj;
        return Objects.equals(indicatorTypeAsString(), other.indicatorTypeAsString())
                && Objects.equals(indicatorDetail(), other.indicatorDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Indicator").add("IndicatorType", indicatorTypeAsString())
                .add("IndicatorDetail", indicatorDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndicatorType":
            return Optional.ofNullable(clazz.cast(indicatorTypeAsString()));
        case "IndicatorDetail":
            return Optional.ofNullable(clazz.cast(indicatorDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Indicator, T> g) {
        return obj -> g.apply((Indicator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Indicator> {
        /**
         * <p>
         * The type of indicator.
         * </p>
         * 
         * @param indicatorType
         *        The type of indicator.
         * @see IndicatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndicatorType
         */
        Builder indicatorType(String indicatorType);

        /**
         * <p>
         * The type of indicator.
         * </p>
         * 
         * @param indicatorType
         *        The type of indicator.
         * @see IndicatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndicatorType
         */
        Builder indicatorType(IndicatorType indicatorType);

        /**
         * <p>
         * Details about the indicator of compromise.
         * </p>
         * 
         * @param indicatorDetail
         *        Details about the indicator of compromise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indicatorDetail(IndicatorDetail indicatorDetail);

        /**
         * <p>
         * Details about the indicator of compromise.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndicatorDetail.Builder} avoiding the
         * need to create one manually via {@link IndicatorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndicatorDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #indicatorDetail(IndicatorDetail)}.
         * 
         * @param indicatorDetail
         *        a consumer that will call methods on {@link IndicatorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indicatorDetail(IndicatorDetail)
         */
        default Builder indicatorDetail(Consumer<IndicatorDetail.Builder> indicatorDetail) {
            return indicatorDetail(IndicatorDetail.builder().applyMutation(indicatorDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indicatorType;

        private IndicatorDetail indicatorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(Indicator model) {
            indicatorType(model.indicatorType);
            indicatorDetail(model.indicatorDetail);
        }

        public final String getIndicatorType() {
            return indicatorType;
        }

        public final void setIndicatorType(String indicatorType) {
            this.indicatorType = indicatorType;
        }

        @Override
        public final Builder indicatorType(String indicatorType) {
            this.indicatorType = indicatorType;
            return this;
        }

        @Override
        public final Builder indicatorType(IndicatorType indicatorType) {
            this.indicatorType(indicatorType == null ? null : indicatorType.toString());
            return this;
        }

        public final IndicatorDetail.Builder getIndicatorDetail() {
            return indicatorDetail != null ? indicatorDetail.toBuilder() : null;
        }

        public final void setIndicatorDetail(IndicatorDetail.BuilderImpl indicatorDetail) {
            this.indicatorDetail = indicatorDetail != null ? indicatorDetail.build() : null;
        }

        @Override
        public final Builder indicatorDetail(IndicatorDetail indicatorDetail) {
            this.indicatorDetail = indicatorDetail;
            return this;
        }

        @Override
        public Indicator build() {
            return new Indicator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
