/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details new geolocations used either at the resource or account level. For example, lists an observed geolocation
 * that is an infrequent or unused location based on previous user activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewGeolocationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<NewGeolocationDetail.Builder, NewGeolocationDetail> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(NewGeolocationDetail::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(NewGeolocationDetail::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<Boolean> IS_NEW_FOR_ENTIRE_ACCOUNT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsNewForEntireAccount").getter(getter(NewGeolocationDetail::isNewForEntireAccount))
            .setter(setter(Builder::isNewForEntireAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNewForEntireAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD,
            IP_ADDRESS_FIELD, IS_NEW_FOR_ENTIRE_ACCOUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String location;

    private final String ipAddress;

    private final Boolean isNewForEntireAccount;

    private NewGeolocationDetail(BuilderImpl builder) {
        this.location = builder.location;
        this.ipAddress = builder.ipAddress;
        this.isNewForEntireAccount = builder.isNewForEntireAccount;
    }

    /**
     * <p>
     * Location where the resource was accessed.
     * </p>
     * 
     * @return Location where the resource was accessed.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * IP address using which the resource was accessed.
     * </p>
     * 
     * @return IP address using which the resource was accessed.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * Checks if the gelocation is new for the entire account.
     * </p>
     * 
     * @return Checks if the gelocation is new for the entire account.
     */
    public final Boolean isNewForEntireAccount() {
        return isNewForEntireAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(isNewForEntireAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewGeolocationDetail)) {
            return false;
        }
        NewGeolocationDetail other = (NewGeolocationDetail) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(isNewForEntireAccount(), other.isNewForEntireAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NewGeolocationDetail").add("Location", location()).add("IpAddress", ipAddress())
                .add("IsNewForEntireAccount", isNewForEntireAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "IsNewForEntireAccount":
            return Optional.ofNullable(clazz.cast(isNewForEntireAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NewGeolocationDetail, T> g) {
        return obj -> g.apply((NewGeolocationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewGeolocationDetail> {
        /**
         * <p>
         * Location where the resource was accessed.
         * </p>
         * 
         * @param location
         *        Location where the resource was accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * IP address using which the resource was accessed.
         * </p>
         * 
         * @param ipAddress
         *        IP address using which the resource was accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * Checks if the gelocation is new for the entire account.
         * </p>
         * 
         * @param isNewForEntireAccount
         *        Checks if the gelocation is new for the entire account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNewForEntireAccount(Boolean isNewForEntireAccount);
    }

    static final class BuilderImpl implements Builder {
        private String location;

        private String ipAddress;

        private Boolean isNewForEntireAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(NewGeolocationDetail model) {
            location(model.location);
            ipAddress(model.ipAddress);
            isNewForEntireAccount(model.isNewForEntireAccount);
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Boolean getIsNewForEntireAccount() {
            return isNewForEntireAccount;
        }

        public final void setIsNewForEntireAccount(Boolean isNewForEntireAccount) {
            this.isNewForEntireAccount = isNewForEntireAccount;
        }

        @Override
        public final Builder isNewForEntireAccount(Boolean isNewForEntireAccount) {
            this.isNewForEntireAccount = isNewForEntireAccount;
            return this;
        }

        @Override
        public NewGeolocationDetail build() {
            return new NewGeolocationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
