/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details new user agents used either at the resource or account level.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NewUserAgentDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<NewUserAgentDetail.Builder, NewUserAgentDetail> {
    private static final SdkField<String> USER_AGENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserAgent").getter(getter(NewUserAgentDetail::userAgent)).setter(setter(Builder::userAgent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAgent").build()).build();

    private static final SdkField<Boolean> IS_NEW_FOR_ENTIRE_ACCOUNT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsNewForEntireAccount").getter(getter(NewUserAgentDetail::isNewForEntireAccount))
            .setter(setter(Builder::isNewForEntireAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNewForEntireAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_AGENT_FIELD,
            IS_NEW_FOR_ENTIRE_ACCOUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userAgent;

    private final Boolean isNewForEntireAccount;

    private NewUserAgentDetail(BuilderImpl builder) {
        this.userAgent = builder.userAgent;
        this.isNewForEntireAccount = builder.isNewForEntireAccount;
    }

    /**
     * <p>
     * New user agent which accessed the resource.
     * </p>
     * 
     * @return New user agent which accessed the resource.
     */
    public final String userAgent() {
        return userAgent;
    }

    /**
     * <p>
     * Checks if the user agent is new for the entire account.
     * </p>
     * 
     * @return Checks if the user agent is new for the entire account.
     */
    public final Boolean isNewForEntireAccount() {
        return isNewForEntireAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(isNewForEntireAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NewUserAgentDetail)) {
            return false;
        }
        NewUserAgentDetail other = (NewUserAgentDetail) obj;
        return Objects.equals(userAgent(), other.userAgent())
                && Objects.equals(isNewForEntireAccount(), other.isNewForEntireAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NewUserAgentDetail").add("UserAgent", userAgent())
                .add("IsNewForEntireAccount", isNewForEntireAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserAgent":
            return Optional.ofNullable(clazz.cast(userAgent()));
        case "IsNewForEntireAccount":
            return Optional.ofNullable(clazz.cast(isNewForEntireAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NewUserAgentDetail, T> g) {
        return obj -> g.apply((NewUserAgentDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NewUserAgentDetail> {
        /**
         * <p>
         * New user agent which accessed the resource.
         * </p>
         * 
         * @param userAgent
         *        New user agent which accessed the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAgent(String userAgent);

        /**
         * <p>
         * Checks if the user agent is new for the entire account.
         * </p>
         * 
         * @param isNewForEntireAccount
         *        Checks if the user agent is new for the entire account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNewForEntireAccount(Boolean isNewForEntireAccount);
    }

    static final class BuilderImpl implements Builder {
        private String userAgent;

        private Boolean isNewForEntireAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(NewUserAgentDetail model) {
            userAgent(model.userAgent);
            isNewForEntireAccount(model.isNewForEntireAccount);
        }

        public final String getUserAgent() {
            return userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final Boolean getIsNewForEntireAccount() {
            return isNewForEntireAccount;
        }

        public final void setIsNewForEntireAccount(Boolean isNewForEntireAccount) {
            this.isNewForEntireAccount = isNewForEntireAccount;
        }

        @Override
        public final Builder isNewForEntireAccount(Boolean isNewForEntireAccount) {
            this.isNewForEntireAccount = isNewForEntireAccount;
            return this;
        }

        @Override
        public NewUserAgentDetail build() {
            return new NewUserAgentDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
