/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request issuer does not have permission to access this resource or perform this operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessDeniedException extends DetectiveException implements
        ToCopyableBuilder<AccessDeniedException.Builder, AccessDeniedException> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(AccessDeniedException::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_CODE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCodeReason").getter(getter(AccessDeniedException::errorCodeReason))
            .setter(setter(Builder::errorCodeReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCodeReason").build()).build();

    private static final SdkField<String> SUB_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubErrorCode").getter(getter(AccessDeniedException::subErrorCodeAsString))
            .setter(setter(Builder::subErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubErrorCode").build()).build();

    private static final SdkField<String> SUB_ERROR_CODE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubErrorCodeReason").getter(getter(AccessDeniedException::subErrorCodeReason))
            .setter(setter(Builder::subErrorCodeReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubErrorCodeReason").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_CODE_REASON_FIELD, SUB_ERROR_CODE_FIELD, SUB_ERROR_CODE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorCodeReason;

    private final String subErrorCode;

    private final String subErrorCodeReason;

    private AccessDeniedException(BuilderImpl builder) {
        super(builder);
        this.errorCode = builder.errorCode;
        this.errorCodeReason = builder.errorCodeReason;
        this.subErrorCode = builder.subErrorCode;
        this.subErrorCodeReason = builder.subErrorCodeReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The SDK default error code associated with the access denied exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The SDK default error code associated with the access denied exception.
     * @see ErrorCode
     */
    public ErrorCode errorCode() {
        return ErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The SDK default error code associated with the access denied exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The SDK default error code associated with the access denied exception.
     * @see ErrorCode
     */
    public String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The SDK default explanation of why access was denied.
     * </p>
     * 
     * @return The SDK default explanation of why access was denied.
     */
    public String errorCodeReason() {
        return errorCodeReason;
    }

    /**
     * <p>
     * The error code associated with the access denied exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subErrorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #subErrorCodeAsString}.
     * </p>
     * 
     * @return The error code associated with the access denied exception.
     * @see ErrorCode
     */
    public ErrorCode subErrorCode() {
        return ErrorCode.fromValue(subErrorCode);
    }

    /**
     * <p>
     * The error code associated with the access denied exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subErrorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #subErrorCodeAsString}.
     * </p>
     * 
     * @return The error code associated with the access denied exception.
     * @see ErrorCode
     */
    public String subErrorCodeAsString() {
        return subErrorCode;
    }

    /**
     * <p>
     * An explanation of why access was denied.
     * </p>
     * 
     * @return An explanation of why access was denied.
     */
    public String subErrorCodeReason() {
        return subErrorCodeReason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessDeniedException, T> g) {
        return obj -> g.apply((AccessDeniedException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessDeniedException>, DetectiveException.Builder {
        /**
         * <p>
         * The SDK default error code associated with the access denied exception.
         * </p>
         * 
         * @param errorCode
         *        The SDK default error code associated with the access denied exception.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The SDK default error code associated with the access denied exception.
         * </p>
         * 
         * @param errorCode
         *        The SDK default error code associated with the access denied exception.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(ErrorCode errorCode);

        /**
         * <p>
         * The SDK default explanation of why access was denied.
         * </p>
         * 
         * @param errorCodeReason
         *        The SDK default explanation of why access was denied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCodeReason(String errorCodeReason);

        /**
         * <p>
         * The error code associated with the access denied exception.
         * </p>
         * 
         * @param subErrorCode
         *        The error code associated with the access denied exception.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder subErrorCode(String subErrorCode);

        /**
         * <p>
         * The error code associated with the access denied exception.
         * </p>
         * 
         * @param subErrorCode
         *        The error code associated with the access denied exception.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder subErrorCode(ErrorCode subErrorCode);

        /**
         * <p>
         * An explanation of why access was denied.
         * </p>
         * 
         * @param subErrorCodeReason
         *        An explanation of why access was denied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subErrorCodeReason(String subErrorCodeReason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends DetectiveException.BuilderImpl implements Builder {
        private String errorCode;

        private String errorCodeReason;

        private String subErrorCode;

        private String subErrorCodeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessDeniedException model) {
            super(model);
            errorCode(model.errorCode);
            errorCodeReason(model.errorCodeReason);
            subErrorCode(model.subErrorCode);
            subErrorCodeReason(model.subErrorCodeReason);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorCodeReason() {
            return errorCodeReason;
        }

        public final void setErrorCodeReason(String errorCodeReason) {
            this.errorCodeReason = errorCodeReason;
        }

        @Override
        public final Builder errorCodeReason(String errorCodeReason) {
            this.errorCodeReason = errorCodeReason;
            return this;
        }

        public final String getSubErrorCode() {
            return subErrorCode;
        }

        public final void setSubErrorCode(String subErrorCode) {
            this.subErrorCode = subErrorCode;
        }

        @Override
        public final Builder subErrorCode(String subErrorCode) {
            this.subErrorCode = subErrorCode;
            return this;
        }

        @Override
        public final Builder subErrorCode(ErrorCode subErrorCode) {
            this.subErrorCode(subErrorCode == null ? null : subErrorCode.toString());
            return this;
        }

        public final String getSubErrorCodeReason() {
            return subErrorCodeReason;
        }

        public final void setSubErrorCodeReason(String subErrorCodeReason) {
            this.subErrorCodeReason = subErrorCodeReason;
        }

        @Override
        public final Builder subErrorCodeReason(String subErrorCodeReason) {
            this.subErrorCodeReason = subErrorCodeReason;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public AccessDeniedException build() {
            return new AccessDeniedException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
