/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIndicatorsResponse extends DetectiveResponse implements
        ToCopyableBuilder<ListIndicatorsResponse.Builder, ListIndicatorsResponse> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GraphArn").getter(getter(ListIndicatorsResponse::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()).build();

    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvestigationId").getter(getter(ListIndicatorsResponse::investigationId))
            .setter(setter(Builder::investigationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIndicatorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<Indicator>> INDICATORS_FIELD = SdkField
            .<List<Indicator>> builder(MarshallingType.LIST)
            .memberName("Indicators")
            .getter(getter(ListIndicatorsResponse::indicators))
            .setter(setter(Builder::indicators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Indicators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Indicator> builder(MarshallingType.SDK_POJO)
                                            .constructor(Indicator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD,
            INVESTIGATION_ID_FIELD, NEXT_TOKEN_FIELD, INDICATORS_FIELD));

    private final String graphArn;

    private final String investigationId;

    private final String nextToken;

    private final List<Indicator> indicators;

    private ListIndicatorsResponse(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.investigationId = builder.investigationId;
        this.nextToken = builder.nextToken;
        this.indicators = builder.indicators;
    }

    /**
     * <p>
     * The ARN of the behavior graph.
     * </p>
     * 
     * @return The ARN of the behavior graph.
     */
    public final String graphArn() {
        return graphArn;
    }

    /**
     * <p>
     * The investigation ID of the investigation report.
     * </p>
     * 
     * @return The investigation ID of the investigation report.
     */
    public final String investigationId() {
        return investigationId;
    }

    /**
     * <p>
     * List if there are more results available. The value of nextToken is a unique pagination token for each page.
     * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * <p>
     * Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation
     * Exception error.
     * </p>
     * 
     * @return List if there are more results available. The value of nextToken is a unique pagination token for each
     *         page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments
     *         unchanged.</p>
     *         <p>
     *         Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation
     *         Exception error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Indicators property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIndicators() {
        return indicators != null && !(indicators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicators of compromise listed based on severity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndicators} method.
     * </p>
     * 
     * @return Indicators of compromise listed based on severity.
     */
    public final List<Indicator> indicators() {
        return indicators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasIndicators() ? indicators() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndicatorsResponse)) {
            return false;
        }
        ListIndicatorsResponse other = (ListIndicatorsResponse) obj;
        return Objects.equals(graphArn(), other.graphArn()) && Objects.equals(investigationId(), other.investigationId())
                && Objects.equals(nextToken(), other.nextToken()) && hasIndicators() == other.hasIndicators()
                && Objects.equals(indicators(), other.indicators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIndicatorsResponse").add("GraphArn", graphArn()).add("InvestigationId", investigationId())
                .add("NextToken", nextToken()).add("Indicators", hasIndicators() ? indicators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GraphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        case "InvestigationId":
            return Optional.ofNullable(clazz.cast(investigationId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Indicators":
            return Optional.ofNullable(clazz.cast(indicators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIndicatorsResponse, T> g) {
        return obj -> g.apply((ListIndicatorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIndicatorsResponse> {
        /**
         * <p>
         * The ARN of the behavior graph.
         * </p>
         * 
         * @param graphArn
         *        The ARN of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);

        /**
         * <p>
         * The investigation ID of the investigation report.
         * </p>
         * 
         * @param investigationId
         *        The investigation ID of the investigation report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder investigationId(String investigationId);

        /**
         * <p>
         * List if there are more results available. The value of nextToken is a unique pagination token for each page.
         * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
         * </p>
         * <p>
         * Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation
         * Exception error.
         * </p>
         * 
         * @param nextToken
         *        List if there are more results available. The value of nextToken is a unique pagination token for each
         *        page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments
         *        unchanged.</p>
         *        <p>
         *        Each pagination token expires after 24 hours. Using an expired pagination token will return a
         *        Validation Exception error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Indicators of compromise listed based on severity.
         * </p>
         * 
         * @param indicators
         *        Indicators of compromise listed based on severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indicators(Collection<Indicator> indicators);

        /**
         * <p>
         * Indicators of compromise listed based on severity.
         * </p>
         * 
         * @param indicators
         *        Indicators of compromise listed based on severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indicators(Indicator... indicators);

        /**
         * <p>
         * Indicators of compromise listed based on severity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.detective.model.Indicator.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.detective.model.Indicator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.detective.model.Indicator.Builder#build()} is called immediately and
         * its result is passed to {@link #indicators(List<Indicator>)}.
         * 
         * @param indicators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.detective.model.Indicator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indicators(java.util.Collection<Indicator>)
         */
        Builder indicators(Consumer<Indicator.Builder>... indicators);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private String graphArn;

        private String investigationId;

        private String nextToken;

        private List<Indicator> indicators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndicatorsResponse model) {
            super(model);
            graphArn(model.graphArn);
            investigationId(model.investigationId);
            nextToken(model.nextToken);
            indicators(model.indicators);
        }

        public final String getGraphArn() {
            return graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getInvestigationId() {
            return investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Indicator.Builder> getIndicators() {
            List<Indicator.Builder> result = IndicatorsCopier.copyToBuilder(this.indicators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndicators(Collection<Indicator.BuilderImpl> indicators) {
            this.indicators = IndicatorsCopier.copyFromBuilder(indicators);
        }

        @Override
        public final Builder indicators(Collection<Indicator> indicators) {
            this.indicators = IndicatorsCopier.copy(indicators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indicators(Indicator... indicators) {
            indicators(Arrays.asList(indicators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indicators(Consumer<Indicator.Builder>... indicators) {
            indicators(Stream.of(indicators).map(c -> Indicator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListIndicatorsResponse build() {
            return new ListIndicatorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
