/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvestigationsRequest extends DetectiveRequest implements
        ToCopyableBuilder<ListInvestigationsRequest.Builder, ListInvestigationsRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GraphArn").getter(getter(ListInvestigationsRequest::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInvestigationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInvestigationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<FilterCriteria> builder(MarshallingType.SDK_POJO).memberName("FilterCriteria")
            .getter(getter(ListInvestigationsRequest::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(FilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()).build();

    private static final SdkField<SortCriteria> SORT_CRITERIA_FIELD = SdkField.<SortCriteria> builder(MarshallingType.SDK_POJO)
            .memberName("SortCriteria").getter(getter(ListInvestigationsRequest::sortCriteria))
            .setter(setter(Builder::sortCriteria)).constructor(SortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_CRITERIA_FIELD, SORT_CRITERIA_FIELD));

    private final String graphArn;

    private final String nextToken;

    private final Integer maxResults;

    private final FilterCriteria filterCriteria;

    private final SortCriteria sortCriteria;

    private ListInvestigationsRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filterCriteria = builder.filterCriteria;
        this.sortCriteria = builder.sortCriteria;
    }

    /**
     * <p>
     * The ARN of the behavior graph.
     * </p>
     * 
     * @return The ARN of the behavior graph.
     */
    public final String graphArn() {
        return graphArn;
    }

    /**
     * <p>
     * List if there are more results available. The value of nextToken is a unique pagination token for each page.
     * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * <p>
     * Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation
     * Exception error.
     * </p>
     * 
     * @return List if there are more results available. The value of nextToken is a unique pagination token for each
     *         page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments
     *         unchanged.</p>
     *         <p>
     *         Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation
     *         Exception error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * List the maximum number of investigations in a page.
     * </p>
     * 
     * @return List the maximum number of investigations in a page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filter the investigation results based on a criteria.
     * </p>
     * 
     * @return Filter the investigation results based on a criteria.
     */
    public final FilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * Sorts the investigation results based on a criteria.
     * </p>
     * 
     * @return Sorts the investigation results based on a criteria.
     */
    public final SortCriteria sortCriteria() {
        return sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvestigationsRequest)) {
            return false;
        }
        ListInvestigationsRequest other = (ListInvestigationsRequest) obj;
        return Objects.equals(graphArn(), other.graphArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(filterCriteria(), other.filterCriteria())
                && Objects.equals(sortCriteria(), other.sortCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvestigationsRequest").add("GraphArn", graphArn()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("FilterCriteria", filterCriteria()).add("SortCriteria", sortCriteria())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GraphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "FilterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "SortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInvestigationsRequest, T> g) {
        return obj -> g.apply((ListInvestigationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListInvestigationsRequest> {
        /**
         * <p>
         * The ARN of the behavior graph.
         * </p>
         * 
         * @param graphArn
         *        The ARN of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);

        /**
         * <p>
         * List if there are more results available. The value of nextToken is a unique pagination token for each page.
         * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
         * </p>
         * <p>
         * Each pagination token expires after 24 hours. Using an expired pagination token will return a Validation
         * Exception error.
         * </p>
         * 
         * @param nextToken
         *        List if there are more results available. The value of nextToken is a unique pagination token for each
         *        page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments
         *        unchanged.</p>
         *        <p>
         *        Each pagination token expires after 24 hours. Using an expired pagination token will return a
         *        Validation Exception error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List the maximum number of investigations in a page.
         * </p>
         * 
         * @param maxResults
         *        List the maximum number of investigations in a page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter the investigation results based on a criteria.
         * </p>
         * 
         * @param filterCriteria
         *        Filter the investigation results based on a criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(FilterCriteria filterCriteria);

        /**
         * <p>
         * Filter the investigation results based on a criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCriteria.Builder} avoiding the need
         * to create one manually via {@link FilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #filterCriteria(FilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link FilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(FilterCriteria)
         */
        default Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return filterCriteria(FilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * Sorts the investigation results based on a criteria.
         * </p>
         * 
         * @param sortCriteria
         *        Sorts the investigation results based on a criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(SortCriteria sortCriteria);

        /**
         * <p>
         * Sorts the investigation results based on a criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortCriteria.Builder} avoiding the need
         * to create one manually via {@link SortCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SortCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #sortCriteria(SortCriteria)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link SortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(SortCriteria)
         */
        default Builder sortCriteria(Consumer<SortCriteria.Builder> sortCriteria) {
            return sortCriteria(SortCriteria.builder().applyMutation(sortCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DetectiveRequest.BuilderImpl implements Builder {
        private String graphArn;

        private String nextToken;

        private Integer maxResults;

        private FilterCriteria filterCriteria;

        private SortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvestigationsRequest model) {
            super(model);
            graphArn(model.graphArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filterCriteria(model.filterCriteria);
            sortCriteria(model.sortCriteria);
        }

        public final String getGraphArn() {
            return graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final SortCriteria.Builder getSortCriteria() {
            return sortCriteria != null ? sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(SortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(SortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInvestigationsRequest build() {
            return new ListInvestigationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
