/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details tactics, techniques, and procedures (TTPs) used in a potential security event. Tactics are based on <a
 * href="https://attack.mitre.org/matrices/enterprise/">MITRE ATT&amp;CK Matrix for Enterprise</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TTPsObservedDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<TTPsObservedDetail.Builder, TTPsObservedDetail> {
    private static final SdkField<String> TACTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tactic")
            .getter(getter(TTPsObservedDetail::tactic)).setter(setter(Builder::tactic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tactic").build()).build();

    private static final SdkField<String> TECHNIQUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Technique").getter(getter(TTPsObservedDetail::technique)).setter(setter(Builder::technique))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Technique").build()).build();

    private static final SdkField<String> PROCEDURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Procedure").getter(getter(TTPsObservedDetail::procedure)).setter(setter(Builder::procedure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Procedure").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(TTPsObservedDetail::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> API_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("APIName").getter(getter(TTPsObservedDetail::apiName)).setter(setter(Builder::apiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APIName").build()).build();

    private static final SdkField<Long> API_SUCCESS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("APISuccessCount").getter(getter(TTPsObservedDetail::apiSuccessCount))
            .setter(setter(Builder::apiSuccessCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APISuccessCount").build()).build();

    private static final SdkField<Long> API_FAILURE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("APIFailureCount").getter(getter(TTPsObservedDetail::apiFailureCount))
            .setter(setter(Builder::apiFailureCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APIFailureCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TACTIC_FIELD, TECHNIQUE_FIELD,
            PROCEDURE_FIELD, IP_ADDRESS_FIELD, API_NAME_FIELD, API_SUCCESS_COUNT_FIELD, API_FAILURE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tactic;

    private final String technique;

    private final String procedure;

    private final String ipAddress;

    private final String apiName;

    private final Long apiSuccessCount;

    private final Long apiFailureCount;

    private TTPsObservedDetail(BuilderImpl builder) {
        this.tactic = builder.tactic;
        this.technique = builder.technique;
        this.procedure = builder.procedure;
        this.ipAddress = builder.ipAddress;
        this.apiName = builder.apiName;
        this.apiSuccessCount = builder.apiSuccessCount;
        this.apiFailureCount = builder.apiFailureCount;
    }

    /**
     * <p>
     * The tactic used, identified by the investigation.
     * </p>
     * 
     * @return The tactic used, identified by the investigation.
     */
    public final String tactic() {
        return tactic;
    }

    /**
     * <p>
     * The technique used, identified by the investigation.
     * </p>
     * 
     * @return The technique used, identified by the investigation.
     */
    public final String technique() {
        return technique;
    }

    /**
     * <p>
     * The procedure used, identified by the investigation.
     * </p>
     * 
     * @return The procedure used, identified by the investigation.
     */
    public final String procedure() {
        return procedure;
    }

    /**
     * <p>
     * The IP address where the TTP was observed.
     * </p>
     * 
     * @return The IP address where the TTP was observed.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The name of the API where the TTP was observed.
     * </p>
     * 
     * @return The name of the API where the TTP was observed.
     */
    public final String apiName() {
        return apiName;
    }

    /**
     * <p>
     * The total number of successful API requests.
     * </p>
     * 
     * @return The total number of successful API requests.
     */
    public final Long apiSuccessCount() {
        return apiSuccessCount;
    }

    /**
     * <p>
     * The total number of failed API requests.
     * </p>
     * 
     * @return The total number of failed API requests.
     */
    public final Long apiFailureCount() {
        return apiFailureCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tactic());
        hashCode = 31 * hashCode + Objects.hashCode(technique());
        hashCode = 31 * hashCode + Objects.hashCode(procedure());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(apiName());
        hashCode = 31 * hashCode + Objects.hashCode(apiSuccessCount());
        hashCode = 31 * hashCode + Objects.hashCode(apiFailureCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TTPsObservedDetail)) {
            return false;
        }
        TTPsObservedDetail other = (TTPsObservedDetail) obj;
        return Objects.equals(tactic(), other.tactic()) && Objects.equals(technique(), other.technique())
                && Objects.equals(procedure(), other.procedure()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(apiName(), other.apiName()) && Objects.equals(apiSuccessCount(), other.apiSuccessCount())
                && Objects.equals(apiFailureCount(), other.apiFailureCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TTPsObservedDetail").add("Tactic", tactic()).add("Technique", technique())
                .add("Procedure", procedure()).add("IpAddress", ipAddress()).add("APIName", apiName())
                .add("APISuccessCount", apiSuccessCount()).add("APIFailureCount", apiFailureCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tactic":
            return Optional.ofNullable(clazz.cast(tactic()));
        case "Technique":
            return Optional.ofNullable(clazz.cast(technique()));
        case "Procedure":
            return Optional.ofNullable(clazz.cast(procedure()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "APIName":
            return Optional.ofNullable(clazz.cast(apiName()));
        case "APISuccessCount":
            return Optional.ofNullable(clazz.cast(apiSuccessCount()));
        case "APIFailureCount":
            return Optional.ofNullable(clazz.cast(apiFailureCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TTPsObservedDetail, T> g) {
        return obj -> g.apply((TTPsObservedDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TTPsObservedDetail> {
        /**
         * <p>
         * The tactic used, identified by the investigation.
         * </p>
         * 
         * @param tactic
         *        The tactic used, identified by the investigation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tactic(String tactic);

        /**
         * <p>
         * The technique used, identified by the investigation.
         * </p>
         * 
         * @param technique
         *        The technique used, identified by the investigation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder technique(String technique);

        /**
         * <p>
         * The procedure used, identified by the investigation.
         * </p>
         * 
         * @param procedure
         *        The procedure used, identified by the investigation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder procedure(String procedure);

        /**
         * <p>
         * The IP address where the TTP was observed.
         * </p>
         * 
         * @param ipAddress
         *        The IP address where the TTP was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The name of the API where the TTP was observed.
         * </p>
         * 
         * @param apiName
         *        The name of the API where the TTP was observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiName(String apiName);

        /**
         * <p>
         * The total number of successful API requests.
         * </p>
         * 
         * @param apiSuccessCount
         *        The total number of successful API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSuccessCount(Long apiSuccessCount);

        /**
         * <p>
         * The total number of failed API requests.
         * </p>
         * 
         * @param apiFailureCount
         *        The total number of failed API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiFailureCount(Long apiFailureCount);
    }

    static final class BuilderImpl implements Builder {
        private String tactic;

        private String technique;

        private String procedure;

        private String ipAddress;

        private String apiName;

        private Long apiSuccessCount;

        private Long apiFailureCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TTPsObservedDetail model) {
            tactic(model.tactic);
            technique(model.technique);
            procedure(model.procedure);
            ipAddress(model.ipAddress);
            apiName(model.apiName);
            apiSuccessCount(model.apiSuccessCount);
            apiFailureCount(model.apiFailureCount);
        }

        public final String getTactic() {
            return tactic;
        }

        public final void setTactic(String tactic) {
            this.tactic = tactic;
        }

        @Override
        public final Builder tactic(String tactic) {
            this.tactic = tactic;
            return this;
        }

        public final String getTechnique() {
            return technique;
        }

        public final void setTechnique(String technique) {
            this.technique = technique;
        }

        @Override
        public final Builder technique(String technique) {
            this.technique = technique;
            return this;
        }

        public final String getProcedure() {
            return procedure;
        }

        public final void setProcedure(String procedure) {
            this.procedure = procedure;
        }

        @Override
        public final Builder procedure(String procedure) {
            this.procedure = procedure;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getApiName() {
            return apiName;
        }

        public final void setApiName(String apiName) {
            this.apiName = apiName;
        }

        @Override
        public final Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public final Long getApiSuccessCount() {
            return apiSuccessCount;
        }

        public final void setApiSuccessCount(Long apiSuccessCount) {
            this.apiSuccessCount = apiSuccessCount;
        }

        @Override
        public final Builder apiSuccessCount(Long apiSuccessCount) {
            this.apiSuccessCount = apiSuccessCount;
            return this;
        }

        public final Long getApiFailureCount() {
            return apiFailureCount;
        }

        public final void setApiFailureCount(Long apiFailureCount) {
            this.apiFailureCount = apiFailureCount;
        }

        @Override
        public final Builder apiFailureCount(Long apiFailureCount) {
            this.apiFailureCount = apiFailureCount;
            return this;
        }

        @Override
        public TTPsObservedDetail build() {
            return new TTPsObservedDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
