/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details on the time range used to filter data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateFilter implements SdkPojo, Serializable, ToCopyableBuilder<DateFilter.Builder, DateFilter> {
    private static final SdkField<Instant> START_INCLUSIVE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartInclusive")
            .getter(getter(DateFilter::startInclusive))
            .setter(setter(Builder::startInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartInclusive").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_INCLUSIVE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndInclusive")
            .getter(getter(DateFilter::endInclusive))
            .setter(setter(Builder::endInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndInclusive").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_INCLUSIVE_FIELD,
            END_INCLUSIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant startInclusive;

    private final Instant endInclusive;

    private DateFilter(BuilderImpl builder) {
        this.startInclusive = builder.startInclusive;
        this.endInclusive = builder.endInclusive;
    }

    /**
     * <p>
     * A timestamp representing the start of the time period from when data is filtered, including the start date.
     * </p>
     * 
     * @return A timestamp representing the start of the time period from when data is filtered, including the start
     *         date.
     */
    public final Instant startInclusive() {
        return startInclusive;
    }

    /**
     * <p>
     * A timestamp representing the end date of the time period until when data is filtered, including the end date.
     * </p>
     * 
     * @return A timestamp representing the end date of the time period until when data is filtered, including the end
     *         date.
     */
    public final Instant endInclusive() {
        return endInclusive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(endInclusive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateFilter)) {
            return false;
        }
        DateFilter other = (DateFilter) obj;
        return Objects.equals(startInclusive(), other.startInclusive()) && Objects.equals(endInclusive(), other.endInclusive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateFilter").add("StartInclusive", startInclusive()).add("EndInclusive", endInclusive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartInclusive":
            return Optional.ofNullable(clazz.cast(startInclusive()));
        case "EndInclusive":
            return Optional.ofNullable(clazz.cast(endInclusive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateFilter, T> g) {
        return obj -> g.apply((DateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateFilter> {
        /**
         * <p>
         * A timestamp representing the start of the time period from when data is filtered, including the start date.
         * </p>
         * 
         * @param startInclusive
         *        A timestamp representing the start of the time period from when data is filtered, including the start
         *        date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startInclusive(Instant startInclusive);

        /**
         * <p>
         * A timestamp representing the end date of the time period until when data is filtered, including the end date.
         * </p>
         * 
         * @param endInclusive
         *        A timestamp representing the end date of the time period until when data is filtered, including the
         *        end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endInclusive(Instant endInclusive);
    }

    static final class BuilderImpl implements Builder {
        private Instant startInclusive;

        private Instant endInclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(DateFilter model) {
            startInclusive(model.startInclusive);
            endInclusive(model.endInclusive);
        }

        public final Instant getStartInclusive() {
            return startInclusive;
        }

        public final void setStartInclusive(Instant startInclusive) {
            this.startInclusive = startInclusive;
        }

        @Override
        public final Builder startInclusive(Instant startInclusive) {
            this.startInclusive = startInclusive;
            return this;
        }

        public final Instant getEndInclusive() {
            return endInclusive;
        }

        public final void setEndInclusive(Instant endInclusive) {
            this.endInclusive = endInclusive;
        }

        @Override
        public final Builder endInclusive(Instant endInclusive) {
            this.endInclusive = endInclusive;
            return this;
        }

        @Override
        public DateFilter build() {
            return new DateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
