/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on suspicious IP addresses identified as indicators of compromise. This indicator is derived
 * from Amazon Web Services threat intelligence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlaggedIpAddressDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<FlaggedIpAddressDetail.Builder, FlaggedIpAddressDetail> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(FlaggedIpAddressDetail::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(FlaggedIpAddressDetail::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IP_ADDRESS_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final String reason;

    private FlaggedIpAddressDetail(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * IP address of the suspicious entity.
     * </p>
     * 
     * @return IP address of the suspicious entity.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * Details the reason the IP address was flagged as suspicious.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link Reason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return Details the reason the IP address was flagged as suspicious.
     * @see Reason
     */
    public final Reason reason() {
        return Reason.fromValue(reason);
    }

    /**
     * <p>
     * Details the reason the IP address was flagged as suspicious.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link Reason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return Details the reason the IP address was flagged as suspicious.
     * @see Reason
     */
    public final String reasonAsString() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlaggedIpAddressDetail)) {
            return false;
        }
        FlaggedIpAddressDetail other = (FlaggedIpAddressDetail) obj;
        return Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(reasonAsString(), other.reasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlaggedIpAddressDetail").add("IpAddress", ipAddress()).add("Reason", reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlaggedIpAddressDetail, T> g) {
        return obj -> g.apply((FlaggedIpAddressDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlaggedIpAddressDetail> {
        /**
         * <p>
         * IP address of the suspicious entity.
         * </p>
         * 
         * @param ipAddress
         *        IP address of the suspicious entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * Details the reason the IP address was flagged as suspicious.
         * </p>
         * 
         * @param reason
         *        Details the reason the IP address was flagged as suspicious.
         * @see Reason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Reason
         */
        Builder reason(String reason);

        /**
         * <p>
         * Details the reason the IP address was flagged as suspicious.
         * </p>
         * 
         * @param reason
         *        Details the reason the IP address was flagged as suspicious.
         * @see Reason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Reason
         */
        Builder reason(Reason reason);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(FlaggedIpAddressDetail model) {
            ipAddress(model.ipAddress);
            reason(model.reason);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(Reason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public FlaggedIpAddressDetail build() {
            return new FlaggedIpAddressDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
