/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInvestigationResponse extends DetectiveResponse implements
        ToCopyableBuilder<GetInvestigationResponse.Builder, GetInvestigationResponse> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GraphArn").getter(getter(GetInvestigationResponse::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()).build();

    private static final SdkField<String> INVESTIGATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvestigationId").getter(getter(GetInvestigationResponse::investigationId))
            .setter(setter(Builder::investigationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationId").build()).build();

    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityArn").getter(getter(GetInvestigationResponse::entityArn)).setter(setter(Builder::entityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityType").getter(getter(GetInvestigationResponse::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime")
            .getter(getter(GetInvestigationResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> SCOPE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScopeStartTime")
            .getter(getter(GetInvestigationResponse::scopeStartTime))
            .setter(setter(Builder::scopeStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> SCOPE_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScopeEndTime")
            .getter(getter(GetInvestigationResponse::scopeEndTime))
            .setter(setter(Builder::scopeEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeEndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetInvestigationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(GetInvestigationResponse::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetInvestigationResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD,
            INVESTIGATION_ID_FIELD, ENTITY_ARN_FIELD, ENTITY_TYPE_FIELD, CREATED_TIME_FIELD, SCOPE_START_TIME_FIELD,
            SCOPE_END_TIME_FIELD, STATUS_FIELD, SEVERITY_FIELD, STATE_FIELD));

    private final String graphArn;

    private final String investigationId;

    private final String entityArn;

    private final String entityType;

    private final Instant createdTime;

    private final Instant scopeStartTime;

    private final Instant scopeEndTime;

    private final String status;

    private final String severity;

    private final String state;

    private GetInvestigationResponse(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.investigationId = builder.investigationId;
        this.entityArn = builder.entityArn;
        this.entityType = builder.entityType;
        this.createdTime = builder.createdTime;
        this.scopeStartTime = builder.scopeStartTime;
        this.scopeEndTime = builder.scopeEndTime;
        this.status = builder.status;
        this.severity = builder.severity;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the behavior graph.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the behavior graph.
     */
    public final String graphArn() {
        return graphArn;
    }

    /**
     * <p>
     * The investigation ID of the investigation report.
     * </p>
     * 
     * @return The investigation ID of the investigation report.
     */
    public final String investigationId() {
        return investigationId;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN). Detective supports IAM user ARNs and IAM role ARNs.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN). Detective supports IAM user ARNs and IAM role ARNs.
     */
    public final String entityArn() {
        return entityArn;
    }

    /**
     * <p>
     * Type of entity. For example, Amazon Web Services accounts, such as an IAM user and/or IAM role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Type of entity. For example, Amazon Web Services accounts, such as an IAM user and/or IAM role.
     * @see EntityType
     */
    public final EntityType entityType() {
        return EntityType.fromValue(entityType);
    }

    /**
     * <p>
     * Type of entity. For example, Amazon Web Services accounts, such as an IAM user and/or IAM role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return Type of entity. For example, Amazon Web Services accounts, such as an IAM user and/or IAM role.
     * @see EntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * The creation time of the investigation report in UTC time stamp format.
     * </p>
     * 
     * @return The creation time of the investigation report in UTC time stamp format.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The start date and time used to set the scope time within which you want to generate the investigation report.
     * The value is an UTC ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.
     * </p>
     * 
     * @return The start date and time used to set the scope time within which you want to generate the investigation
     *         report. The value is an UTC ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.
     */
    public final Instant scopeStartTime() {
        return scopeStartTime;
    }

    /**
     * <p>
     * The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For example,
     * <code>2021-08-18T16:35:56.284Z</code>.
     * </p>
     * 
     * @return The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For
     *         example, <code>2021-08-18T16:35:56.284Z</code>.
     */
    public final Instant scopeEndTime() {
        return scopeEndTime;
    }

    /**
     * <p>
     * The status based on the completion status of the investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status based on the completion status of the investigation.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status based on the completion status of the investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status based on the completion status of the investigation.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The severity assigned is based on the likelihood and impact of the indicators of compromise discovered in the
     * investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity assigned is based on the likelihood and impact of the indicators of compromise discovered in
     *         the investigation.
     * @see Severity
     */
    public final Severity severity() {
        return Severity.fromValue(severity);
    }

    /**
     * <p>
     * The severity assigned is based on the likelihood and impact of the indicators of compromise discovered in the
     * investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity assigned is based on the likelihood and impact of the indicators of compromise discovered in
     *         the investigation.
     * @see Severity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The current state of the investigation. An archived investigation indicates that you have completed reviewing the
     * investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the investigation. An archived investigation indicates that you have completed
     *         reviewing the investigation.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The current state of the investigation. An archived investigation indicates that you have completed reviewing the
     * investigation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the investigation. An archived investigation indicates that you have completed
     *         reviewing the investigation.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(investigationId());
        hashCode = 31 * hashCode + Objects.hashCode(entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(scopeStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(scopeEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvestigationResponse)) {
            return false;
        }
        GetInvestigationResponse other = (GetInvestigationResponse) obj;
        return Objects.equals(graphArn(), other.graphArn()) && Objects.equals(investigationId(), other.investigationId())
                && Objects.equals(entityArn(), other.entityArn())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(scopeStartTime(), other.scopeStartTime())
                && Objects.equals(scopeEndTime(), other.scopeEndTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInvestigationResponse").add("GraphArn", graphArn()).add("InvestigationId", investigationId())
                .add("EntityArn", entityArn()).add("EntityType", entityTypeAsString()).add("CreatedTime", createdTime())
                .add("ScopeStartTime", scopeStartTime()).add("ScopeEndTime", scopeEndTime()).add("Status", statusAsString())
                .add("Severity", severityAsString()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GraphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        case "InvestigationId":
            return Optional.ofNullable(clazz.cast(investigationId()));
        case "EntityArn":
            return Optional.ofNullable(clazz.cast(entityArn()));
        case "EntityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "ScopeStartTime":
            return Optional.ofNullable(clazz.cast(scopeStartTime()));
        case "ScopeEndTime":
            return Optional.ofNullable(clazz.cast(scopeEndTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInvestigationResponse, T> g) {
        return obj -> g.apply((GetInvestigationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInvestigationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the behavior graph.
         * </p>
         * 
         * @param graphArn
         *        The Amazon Resource Name (ARN) of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);

        /**
         * <p>
         * The investigation ID of the investigation report.
         * </p>
         * 
         * @param investigationId
         *        The investigation ID of the investigation report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder investigationId(String investigationId);

        /**
         * <p>
         * The unique Amazon Resource Name (ARN). Detective supports IAM user ARNs and IAM role ARNs.
         * </p>
         * 
         * @param entityArn
         *        The unique Amazon Resource Name (ARN). Detective supports IAM user ARNs and IAM role ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArn(String entityArn);

        /**
         * <p>
         * Type of entity. For example, Amazon Web Services accounts, such as an IAM user and/or IAM role.
         * </p>
         * 
         * @param entityType
         *        Type of entity. For example, Amazon Web Services accounts, such as an IAM user and/or IAM role.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * Type of entity. For example, Amazon Web Services accounts, such as an IAM user and/or IAM role.
         * </p>
         * 
         * @param entityType
         *        Type of entity. For example, Amazon Web Services accounts, such as an IAM user and/or IAM role.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder entityType(EntityType entityType);

        /**
         * <p>
         * The creation time of the investigation report in UTC time stamp format.
         * </p>
         * 
         * @param createdTime
         *        The creation time of the investigation report in UTC time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The start date and time used to set the scope time within which you want to generate the investigation
         * report. The value is an UTC ISO8601 formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.
         * </p>
         * 
         * @param scopeStartTime
         *        The start date and time used to set the scope time within which you want to generate the investigation
         *        report. The value is an UTC ISO8601 formatted string. For example,
         *        <code>2021-08-18T16:35:56.284Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeStartTime(Instant scopeStartTime);

        /**
         * <p>
         * The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For example,
         * <code>2021-08-18T16:35:56.284Z</code>.
         * </p>
         * 
         * @param scopeEndTime
         *        The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For
         *        example, <code>2021-08-18T16:35:56.284Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeEndTime(Instant scopeEndTime);

        /**
         * <p>
         * The status based on the completion status of the investigation.
         * </p>
         * 
         * @param status
         *        The status based on the completion status of the investigation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status based on the completion status of the investigation.
         * </p>
         * 
         * @param status
         *        The status based on the completion status of the investigation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The severity assigned is based on the likelihood and impact of the indicators of compromise discovered in the
         * investigation.
         * </p>
         * 
         * @param severity
         *        The severity assigned is based on the likelihood and impact of the indicators of compromise discovered
         *        in the investigation.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity assigned is based on the likelihood and impact of the indicators of compromise discovered in the
         * investigation.
         * </p>
         * 
         * @param severity
         *        The severity assigned is based on the likelihood and impact of the indicators of compromise discovered
         *        in the investigation.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(Severity severity);

        /**
         * <p>
         * The current state of the investigation. An archived investigation indicates that you have completed reviewing
         * the investigation.
         * </p>
         * 
         * @param state
         *        The current state of the investigation. An archived investigation indicates that you have completed
         *        reviewing the investigation.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the investigation. An archived investigation indicates that you have completed reviewing
         * the investigation.
         * </p>
         * 
         * @param state
         *        The current state of the investigation. An archived investigation indicates that you have completed
         *        reviewing the investigation.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private String graphArn;

        private String investigationId;

        private String entityArn;

        private String entityType;

        private Instant createdTime;

        private Instant scopeStartTime;

        private Instant scopeEndTime;

        private String status;

        private String severity;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvestigationResponse model) {
            super(model);
            graphArn(model.graphArn);
            investigationId(model.investigationId);
            entityArn(model.entityArn);
            entityType(model.entityType);
            createdTime(model.createdTime);
            scopeStartTime(model.scopeStartTime);
            scopeEndTime(model.scopeEndTime);
            status(model.status);
            severity(model.severity);
            state(model.state);
        }

        public final String getGraphArn() {
            return graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getInvestigationId() {
            return investigationId;
        }

        public final void setInvestigationId(String investigationId) {
            this.investigationId = investigationId;
        }

        @Override
        public final Builder investigationId(String investigationId) {
            this.investigationId = investigationId;
            return this;
        }

        public final String getEntityArn() {
            return entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getScopeStartTime() {
            return scopeStartTime;
        }

        public final void setScopeStartTime(Instant scopeStartTime) {
            this.scopeStartTime = scopeStartTime;
        }

        @Override
        public final Builder scopeStartTime(Instant scopeStartTime) {
            this.scopeStartTime = scopeStartTime;
            return this;
        }

        public final Instant getScopeEndTime() {
            return scopeEndTime;
        }

        public final void setScopeEndTime(Instant scopeEndTime) {
            this.scopeEndTime = scopeEndTime;
        }

        @Override
        public final Builder scopeEndTime(Instant scopeEndTime) {
            this.scopeEndTime = scopeEndTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public GetInvestigationResponse build() {
            return new GetInvestigationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
