/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInvestigationsResponse extends DetectiveResponse implements
        ToCopyableBuilder<ListInvestigationsResponse.Builder, ListInvestigationsResponse> {
    private static final SdkField<List<InvestigationDetail>> INVESTIGATION_DETAILS_FIELD = SdkField
            .<List<InvestigationDetail>> builder(MarshallingType.LIST)
            .memberName("InvestigationDetails")
            .getter(getter(ListInvestigationsResponse::investigationDetails))
            .setter(setter(Builder::investigationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvestigationDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvestigationDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvestigationDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInvestigationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVESTIGATION_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<InvestigationDetail> investigationDetails;

    private final String nextToken;

    private ListInvestigationsResponse(BuilderImpl builder) {
        super(builder);
        this.investigationDetails = builder.investigationDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvestigationDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvestigationDetails() {
        return investigationDetails != null && !(investigationDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the summary of uncommon behavior or malicious activity which indicates a compromise.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvestigationDetails} method.
     * </p>
     * 
     * @return Lists the summary of uncommon behavior or malicious activity which indicates a compromise.
     */
    public final List<InvestigationDetail> investigationDetails() {
        return investigationDetails;
    }

    /**
     * <p>
     * Lists if there are more results available. The value of nextToken is a unique pagination token for each page.
     * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * <p>
     * Each pagination token expires after 24 hours.
     * </p>
     * 
     * @return Lists if there are more results available. The value of nextToken is a unique pagination token for each
     *         page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments
     *         unchanged.</p>
     *         <p>
     *         Each pagination token expires after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInvestigationDetails() ? investigationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvestigationsResponse)) {
            return false;
        }
        ListInvestigationsResponse other = (ListInvestigationsResponse) obj;
        return hasInvestigationDetails() == other.hasInvestigationDetails()
                && Objects.equals(investigationDetails(), other.investigationDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInvestigationsResponse")
                .add("InvestigationDetails", hasInvestigationDetails() ? investigationDetails() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvestigationDetails":
            return Optional.ofNullable(clazz.cast(investigationDetails()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInvestigationsResponse, T> g) {
        return obj -> g.apply((ListInvestigationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInvestigationsResponse> {
        /**
         * <p>
         * Lists the summary of uncommon behavior or malicious activity which indicates a compromise.
         * </p>
         * 
         * @param investigationDetails
         *        Lists the summary of uncommon behavior or malicious activity which indicates a compromise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder investigationDetails(Collection<InvestigationDetail> investigationDetails);

        /**
         * <p>
         * Lists the summary of uncommon behavior or malicious activity which indicates a compromise.
         * </p>
         * 
         * @param investigationDetails
         *        Lists the summary of uncommon behavior or malicious activity which indicates a compromise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder investigationDetails(InvestigationDetail... investigationDetails);

        /**
         * <p>
         * Lists the summary of uncommon behavior or malicious activity which indicates a compromise.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.detective.model.InvestigationDetail.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.detective.model.InvestigationDetail#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.detective.model.InvestigationDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #investigationDetails(List<InvestigationDetail>)}.
         * 
         * @param investigationDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.detective.model.InvestigationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #investigationDetails(java.util.Collection<InvestigationDetail>)
         */
        Builder investigationDetails(Consumer<InvestigationDetail.Builder>... investigationDetails);

        /**
         * <p>
         * Lists if there are more results available. The value of nextToken is a unique pagination token for each page.
         * Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
         * </p>
         * <p>
         * Each pagination token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        Lists if there are more results available. The value of nextToken is a unique pagination token for
         *        each page. Repeat the call using the returned token to retrieve the next page. Keep all other
         *        arguments unchanged.</p>
         *        <p>
         *        Each pagination token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private List<InvestigationDetail> investigationDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvestigationsResponse model) {
            super(model);
            investigationDetails(model.investigationDetails);
            nextToken(model.nextToken);
        }

        public final List<InvestigationDetail.Builder> getInvestigationDetails() {
            List<InvestigationDetail.Builder> result = InvestigationDetailsCopier.copyToBuilder(this.investigationDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvestigationDetails(Collection<InvestigationDetail.BuilderImpl> investigationDetails) {
            this.investigationDetails = InvestigationDetailsCopier.copyFromBuilder(investigationDetails);
        }

        @Override
        public final Builder investigationDetails(Collection<InvestigationDetail> investigationDetails) {
            this.investigationDetails = InvestigationDetailsCopier.copy(investigationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationDetails(InvestigationDetail... investigationDetails) {
            investigationDetails(Arrays.asList(investigationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder investigationDetails(Consumer<InvestigationDetail.Builder>... investigationDetails) {
            investigationDetails(Stream.of(investigationDetails).map(c -> InvestigationDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInvestigationsResponse build() {
            return new ListInvestigationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
