/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartInvestigationRequest extends DetectiveRequest implements
        ToCopyableBuilder<StartInvestigationRequest.Builder, StartInvestigationRequest> {
    private static final SdkField<String> GRAPH_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GraphArn").getter(getter(StartInvestigationRequest::graphArn)).setter(setter(Builder::graphArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GraphArn").build()).build();

    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityArn").getter(getter(StartInvestigationRequest::entityArn)).setter(setter(Builder::entityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()).build();

    private static final SdkField<Instant> SCOPE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScopeStartTime")
            .getter(getter(StartInvestigationRequest::scopeStartTime))
            .setter(setter(Builder::scopeStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> SCOPE_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScopeEndTime")
            .getter(getter(StartInvestigationRequest::scopeEndTime))
            .setter(setter(Builder::scopeEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScopeEndTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ARN_FIELD,
            ENTITY_ARN_FIELD, SCOPE_START_TIME_FIELD, SCOPE_END_TIME_FIELD));

    private final String graphArn;

    private final String entityArn;

    private final Instant scopeStartTime;

    private final Instant scopeEndTime;

    private StartInvestigationRequest(BuilderImpl builder) {
        super(builder);
        this.graphArn = builder.graphArn;
        this.entityArn = builder.entityArn;
        this.scopeStartTime = builder.scopeStartTime;
        this.scopeEndTime = builder.scopeEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the behavior graph.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the behavior graph.
     */
    public final String graphArn() {
        return graphArn;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
     */
    public final String entityArn() {
        return entityArn;
    }

    /**
     * <p>
     * The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For example,
     * <code>2021-08-18T16:35:56.284Z</code>.
     * </p>
     * 
     * @return The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For
     *         example, <code>2021-08-18T16:35:56.284Z</code>.
     */
    public final Instant scopeStartTime() {
        return scopeStartTime;
    }

    /**
     * <p>
     * The data and time when the investigation ended. The value is an UTC ISO8601 formatted string. For example,
     * <code>2021-08-18T16:35:56.284Z</code>.
     * </p>
     * 
     * @return The data and time when the investigation ended. The value is an UTC ISO8601 formatted string. For
     *         example, <code>2021-08-18T16:35:56.284Z</code>.
     */
    public final Instant scopeEndTime() {
        return scopeEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphArn());
        hashCode = 31 * hashCode + Objects.hashCode(entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(scopeStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(scopeEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInvestigationRequest)) {
            return false;
        }
        StartInvestigationRequest other = (StartInvestigationRequest) obj;
        return Objects.equals(graphArn(), other.graphArn()) && Objects.equals(entityArn(), other.entityArn())
                && Objects.equals(scopeStartTime(), other.scopeStartTime())
                && Objects.equals(scopeEndTime(), other.scopeEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartInvestigationRequest").add("GraphArn", graphArn()).add("EntityArn", entityArn())
                .add("ScopeStartTime", scopeStartTime()).add("ScopeEndTime", scopeEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GraphArn":
            return Optional.ofNullable(clazz.cast(graphArn()));
        case "EntityArn":
            return Optional.ofNullable(clazz.cast(entityArn()));
        case "ScopeStartTime":
            return Optional.ofNullable(clazz.cast(scopeStartTime()));
        case "ScopeEndTime":
            return Optional.ofNullable(clazz.cast(scopeEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartInvestigationRequest, T> g) {
        return obj -> g.apply((StartInvestigationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartInvestigationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the behavior graph.
         * </p>
         * 
         * @param graphArn
         *        The Amazon Resource Name (ARN) of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphArn(String graphArn);

        /**
         * <p>
         * The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
         * </p>
         * 
         * @param entityArn
         *        The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityArn(String entityArn);

        /**
         * <p>
         * The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For example,
         * <code>2021-08-18T16:35:56.284Z</code>.
         * </p>
         * 
         * @param scopeStartTime
         *        The data and time when the investigation began. The value is an UTC ISO8601 formatted string. For
         *        example, <code>2021-08-18T16:35:56.284Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeStartTime(Instant scopeStartTime);

        /**
         * <p>
         * The data and time when the investigation ended. The value is an UTC ISO8601 formatted string. For example,
         * <code>2021-08-18T16:35:56.284Z</code>.
         * </p>
         * 
         * @param scopeEndTime
         *        The data and time when the investigation ended. The value is an UTC ISO8601 formatted string. For
         *        example, <code>2021-08-18T16:35:56.284Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeEndTime(Instant scopeEndTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DetectiveRequest.BuilderImpl implements Builder {
        private String graphArn;

        private String entityArn;

        private Instant scopeStartTime;

        private Instant scopeEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartInvestigationRequest model) {
            super(model);
            graphArn(model.graphArn);
            entityArn(model.entityArn);
            scopeStartTime(model.scopeStartTime);
            scopeEndTime(model.scopeEndTime);
        }

        public final String getGraphArn() {
            return graphArn;
        }

        public final void setGraphArn(String graphArn) {
            this.graphArn = graphArn;
        }

        @Override
        public final Builder graphArn(String graphArn) {
            this.graphArn = graphArn;
            return this;
        }

        public final String getEntityArn() {
            return entityArn;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final Instant getScopeStartTime() {
            return scopeStartTime;
        }

        public final void setScopeStartTime(Instant scopeStartTime) {
            this.scopeStartTime = scopeStartTime;
        }

        @Override
        public final Builder scopeStartTime(Instant scopeStartTime) {
            this.scopeStartTime = scopeStartTime;
            return this;
        }

        public final Instant getScopeEndTime() {
            return scopeEndTime;
        }

        public final void setScopeEndTime(Instant scopeEndTime) {
            this.scopeEndTime = scopeEndTime;
        }

        @Override
        public final Builder scopeEndTime(Instant scopeEndTime) {
            this.scopeEndTime = scopeEndTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartInvestigationRequest build() {
            return new StartInvestigationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
