/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on unusual and impossible travel in an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImpossibleTravelDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ImpossibleTravelDetail.Builder, ImpossibleTravelDetail> {
    private static final SdkField<String> STARTING_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartingIpAddress").getter(getter(ImpossibleTravelDetail::startingIpAddress))
            .setter(setter(Builder::startingIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingIpAddress").build()).build();

    private static final SdkField<String> ENDING_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndingIpAddress").getter(getter(ImpossibleTravelDetail::endingIpAddress))
            .setter(setter(Builder::endingIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndingIpAddress").build()).build();

    private static final SdkField<String> STARTING_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartingLocation").getter(getter(ImpossibleTravelDetail::startingLocation))
            .setter(setter(Builder::startingLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingLocation").build()).build();

    private static final SdkField<String> ENDING_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndingLocation").getter(getter(ImpossibleTravelDetail::endingLocation))
            .setter(setter(Builder::endingLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndingLocation").build()).build();

    private static final SdkField<Integer> HOURLY_TIME_DELTA_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HourlyTimeDelta").getter(getter(ImpossibleTravelDetail::hourlyTimeDelta))
            .setter(setter(Builder::hourlyTimeDelta))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyTimeDelta").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTING_IP_ADDRESS_FIELD,
            ENDING_IP_ADDRESS_FIELD, STARTING_LOCATION_FIELD, ENDING_LOCATION_FIELD, HOURLY_TIME_DELTA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startingIpAddress;

    private final String endingIpAddress;

    private final String startingLocation;

    private final String endingLocation;

    private final Integer hourlyTimeDelta;

    private ImpossibleTravelDetail(BuilderImpl builder) {
        this.startingIpAddress = builder.startingIpAddress;
        this.endingIpAddress = builder.endingIpAddress;
        this.startingLocation = builder.startingLocation;
        this.endingLocation = builder.endingLocation;
        this.hourlyTimeDelta = builder.hourlyTimeDelta;
    }

    /**
     * <p>
     * IP address where the resource was first used in the impossible travel.
     * </p>
     * 
     * @return IP address where the resource was first used in the impossible travel.
     */
    public final String startingIpAddress() {
        return startingIpAddress;
    }

    /**
     * <p>
     * IP address where the resource was last used in the impossible travel.
     * </p>
     * 
     * @return IP address where the resource was last used in the impossible travel.
     */
    public final String endingIpAddress() {
        return endingIpAddress;
    }

    /**
     * <p>
     * Location where the resource was first used in the impossible travel.
     * </p>
     * 
     * @return Location where the resource was first used in the impossible travel.
     */
    public final String startingLocation() {
        return startingLocation;
    }

    /**
     * <p>
     * Location where the resource was last used in the impossible travel.
     * </p>
     * 
     * @return Location where the resource was last used in the impossible travel.
     */
    public final String endingLocation() {
        return endingLocation;
    }

    /**
     * <p>
     * Returns the time difference between the first and last timestamp the resource was used.
     * </p>
     * 
     * @return Returns the time difference between the first and last timestamp the resource was used.
     */
    public final Integer hourlyTimeDelta() {
        return hourlyTimeDelta;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startingIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(endingIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(startingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(endingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyTimeDelta());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImpossibleTravelDetail)) {
            return false;
        }
        ImpossibleTravelDetail other = (ImpossibleTravelDetail) obj;
        return Objects.equals(startingIpAddress(), other.startingIpAddress())
                && Objects.equals(endingIpAddress(), other.endingIpAddress())
                && Objects.equals(startingLocation(), other.startingLocation())
                && Objects.equals(endingLocation(), other.endingLocation())
                && Objects.equals(hourlyTimeDelta(), other.hourlyTimeDelta());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImpossibleTravelDetail").add("StartingIpAddress", startingIpAddress())
                .add("EndingIpAddress", endingIpAddress()).add("StartingLocation", startingLocation())
                .add("EndingLocation", endingLocation()).add("HourlyTimeDelta", hourlyTimeDelta()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartingIpAddress":
            return Optional.ofNullable(clazz.cast(startingIpAddress()));
        case "EndingIpAddress":
            return Optional.ofNullable(clazz.cast(endingIpAddress()));
        case "StartingLocation":
            return Optional.ofNullable(clazz.cast(startingLocation()));
        case "EndingLocation":
            return Optional.ofNullable(clazz.cast(endingLocation()));
        case "HourlyTimeDelta":
            return Optional.ofNullable(clazz.cast(hourlyTimeDelta()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImpossibleTravelDetail, T> g) {
        return obj -> g.apply((ImpossibleTravelDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImpossibleTravelDetail> {
        /**
         * <p>
         * IP address where the resource was first used in the impossible travel.
         * </p>
         * 
         * @param startingIpAddress
         *        IP address where the resource was first used in the impossible travel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingIpAddress(String startingIpAddress);

        /**
         * <p>
         * IP address where the resource was last used in the impossible travel.
         * </p>
         * 
         * @param endingIpAddress
         *        IP address where the resource was last used in the impossible travel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endingIpAddress(String endingIpAddress);

        /**
         * <p>
         * Location where the resource was first used in the impossible travel.
         * </p>
         * 
         * @param startingLocation
         *        Location where the resource was first used in the impossible travel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingLocation(String startingLocation);

        /**
         * <p>
         * Location where the resource was last used in the impossible travel.
         * </p>
         * 
         * @param endingLocation
         *        Location where the resource was last used in the impossible travel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endingLocation(String endingLocation);

        /**
         * <p>
         * Returns the time difference between the first and last timestamp the resource was used.
         * </p>
         * 
         * @param hourlyTimeDelta
         *        Returns the time difference between the first and last timestamp the resource was used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyTimeDelta(Integer hourlyTimeDelta);
    }

    static final class BuilderImpl implements Builder {
        private String startingIpAddress;

        private String endingIpAddress;

        private String startingLocation;

        private String endingLocation;

        private Integer hourlyTimeDelta;

        private BuilderImpl() {
        }

        private BuilderImpl(ImpossibleTravelDetail model) {
            startingIpAddress(model.startingIpAddress);
            endingIpAddress(model.endingIpAddress);
            startingLocation(model.startingLocation);
            endingLocation(model.endingLocation);
            hourlyTimeDelta(model.hourlyTimeDelta);
        }

        public final String getStartingIpAddress() {
            return startingIpAddress;
        }

        public final void setStartingIpAddress(String startingIpAddress) {
            this.startingIpAddress = startingIpAddress;
        }

        @Override
        public final Builder startingIpAddress(String startingIpAddress) {
            this.startingIpAddress = startingIpAddress;
            return this;
        }

        public final String getEndingIpAddress() {
            return endingIpAddress;
        }

        public final void setEndingIpAddress(String endingIpAddress) {
            this.endingIpAddress = endingIpAddress;
        }

        @Override
        public final Builder endingIpAddress(String endingIpAddress) {
            this.endingIpAddress = endingIpAddress;
            return this;
        }

        public final String getStartingLocation() {
            return startingLocation;
        }

        public final void setStartingLocation(String startingLocation) {
            this.startingLocation = startingLocation;
        }

        @Override
        public final Builder startingLocation(String startingLocation) {
            this.startingLocation = startingLocation;
            return this;
        }

        public final String getEndingLocation() {
            return endingLocation;
        }

        public final void setEndingLocation(String endingLocation) {
            this.endingLocation = endingLocation;
        }

        @Override
        public final Builder endingLocation(String endingLocation) {
            this.endingLocation = endingLocation;
            return this;
        }

        public final Integer getHourlyTimeDelta() {
            return hourlyTimeDelta;
        }

        public final void setHourlyTimeDelta(Integer hourlyTimeDelta) {
            this.hourlyTimeDelta = hourlyTimeDelta;
        }

        @Override
        public final Builder hourlyTimeDelta(Integer hourlyTimeDelta) {
            this.hourlyTimeDelta = hourlyTimeDelta;
            return this;
        }

        @Override
        public ImpossibleTravelDetail build() {
            return new ImpossibleTravelDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
