/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.detective.model.DateFilter;
import software.amazon.awssdk.services.detective.model.StringFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterCriteria> {
    private static final SdkField<StringFilter> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Severity").getter(FilterCriteria.getter(FilterCriteria::severity)).setter(FilterCriteria.setter(Builder::severity)).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<StringFilter> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(FilterCriteria.getter(FilterCriteria::status)).setter(FilterCriteria.setter(Builder::status)).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<StringFilter> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("State").getter(FilterCriteria.getter(FilterCriteria::state)).setter(FilterCriteria.setter(Builder::state)).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<StringFilter> ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityArn").getter(FilterCriteria.getter(FilterCriteria::entityArn)).setter(FilterCriteria.setter(Builder::entityArn)).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()}).build();
    private static final SdkField<DateFilter> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedTime").getter(FilterCriteria.getter(FilterCriteria::createdTime)).setter(FilterCriteria.setter(Builder::createdTime)).constructor(DateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITY_FIELD, STATUS_FIELD, STATE_FIELD, ENTITY_ARN_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final StringFilter severity;
    private final StringFilter status;
    private final StringFilter state;
    private final StringFilter entityArn;
    private final DateFilter createdTime;

    private FilterCriteria(BuilderImpl builder) {
        this.severity = builder.severity;
        this.status = builder.status;
        this.state = builder.state;
        this.entityArn = builder.entityArn;
        this.createdTime = builder.createdTime;
    }

    public final StringFilter severity() {
        return this.severity;
    }

    public final StringFilter status() {
        return this.status;
    }

    public final StringFilter state() {
        return this.state;
    }

    public final StringFilter entityArn() {
        return this.entityArn;
    }

    public final DateFilter createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterCriteria)) {
            return false;
        }
        FilterCriteria other = (FilterCriteria)obj;
        return Objects.equals(this.severity(), other.severity()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.entityArn(), other.entityArn()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public final String toString() {
        return ToString.builder((String)"FilterCriteria").add("Severity", (Object)this.severity()).add("Status", (Object)this.status()).add("State", (Object)this.state()).add("EntityArn", (Object)this.entityArn()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "EntityArn": {
                return Optional.ofNullable(clazz.cast(this.entityArn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterCriteria, T> g) {
        return obj -> g.apply((FilterCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StringFilter severity;
        private StringFilter status;
        private StringFilter state;
        private StringFilter entityArn;
        private DateFilter createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterCriteria model) {
            this.severity(model.severity);
            this.status(model.status);
            this.state(model.state);
            this.entityArn(model.entityArn);
            this.createdTime(model.createdTime);
        }

        public final StringFilter.Builder getSeverity() {
            return this.severity != null ? this.severity.toBuilder() : null;
        }

        public final void setSeverity(StringFilter.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        @Override
        public final Builder severity(StringFilter severity) {
            this.severity = severity;
            return this;
        }

        public final StringFilter.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(StringFilter.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(StringFilter status) {
            this.status = status;
            return this;
        }

        public final StringFilter.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(StringFilter.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(StringFilter state) {
            this.state = state;
            return this;
        }

        public final StringFilter.Builder getEntityArn() {
            return this.entityArn != null ? this.entityArn.toBuilder() : null;
        }

        public final void setEntityArn(StringFilter.BuilderImpl entityArn) {
            this.entityArn = entityArn != null ? entityArn.build() : null;
        }

        @Override
        public final Builder entityArn(StringFilter entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final DateFilter.Builder getCreatedTime() {
            return this.createdTime != null ? this.createdTime.toBuilder() : null;
        }

        public final void setCreatedTime(DateFilter.BuilderImpl createdTime) {
            this.createdTime = createdTime != null ? createdTime.build() : null;
        }

        @Override
        public final Builder createdTime(DateFilter createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public FilterCriteria build() {
            return new FilterCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterCriteria> {
        public Builder severity(StringFilter var1);

        default public Builder severity(Consumer<StringFilter.Builder> severity) {
            return this.severity((StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation(severity)).build());
        }

        public Builder status(StringFilter var1);

        default public Builder status(Consumer<StringFilter.Builder> status) {
            return this.status((StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation(status)).build());
        }

        public Builder state(StringFilter var1);

        default public Builder state(Consumer<StringFilter.Builder> state) {
            return this.state((StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation(state)).build());
        }

        public Builder entityArn(StringFilter var1);

        default public Builder entityArn(Consumer<StringFilter.Builder> entityArn) {
            return this.entityArn((StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation(entityArn)).build());
        }

        public Builder createdTime(DateFilter var1);

        default public Builder createdTime(Consumer<DateFilter.Builder> createdTime) {
            return this.createdTime((DateFilter)((DateFilter.Builder)DateFilter.builder().applyMutation(createdTime)).build());
        }
    }
}

