/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class DatasourcePackageIngestDetailsCopier {
    static Map<String, DatasourcePackageIngestDetail> copy(
            Map<String, ? extends DatasourcePackageIngestDetail> datasourcePackageIngestDetailsParam) {
        Map<String, DatasourcePackageIngestDetail> map;
        if (datasourcePackageIngestDetailsParam == null || datasourcePackageIngestDetailsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DatasourcePackageIngestDetail> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestDetailsParam.size());
            datasourcePackageIngestDetailsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DatasourcePackageIngestDetail> copyFromBuilder(
            Map<String, ? extends DatasourcePackageIngestDetail.Builder> datasourcePackageIngestDetailsParam) {
        Map<String, DatasourcePackageIngestDetail> map;
        if (datasourcePackageIngestDetailsParam == null || datasourcePackageIngestDetailsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DatasourcePackageIngestDetail> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestDetailsParam.size());
            datasourcePackageIngestDetailsParam.forEach((key, value) -> {
                DatasourcePackageIngestDetail member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DatasourcePackageIngestDetail.Builder> copyToBuilder(
            Map<String, ? extends DatasourcePackageIngestDetail> datasourcePackageIngestDetailsParam) {
        Map<String, DatasourcePackageIngestDetail.Builder> map;
        if (datasourcePackageIngestDetailsParam == null || datasourcePackageIngestDetailsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DatasourcePackageIngestDetail.Builder> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestDetailsParam.size());
            datasourcePackageIngestDetailsParam.forEach((key, value) -> {
                DatasourcePackageIngestDetail.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, DatasourcePackageIngestDetail> copyEnumToString(
            Map<DatasourcePackage, ? extends DatasourcePackageIngestDetail> datasourcePackageIngestDetailsParam) {
        Map<String, DatasourcePackageIngestDetail> map;
        if (datasourcePackageIngestDetailsParam == null || datasourcePackageIngestDetailsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, DatasourcePackageIngestDetail> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestDetailsParam.size());
            datasourcePackageIngestDetailsParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<DatasourcePackage, DatasourcePackageIngestDetail> copyStringToEnum(
            Map<String, ? extends DatasourcePackageIngestDetail> datasourcePackageIngestDetailsParam) {
        Map<DatasourcePackage, DatasourcePackageIngestDetail> map;
        if (datasourcePackageIngestDetailsParam == null || datasourcePackageIngestDetailsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<DatasourcePackage, DatasourcePackageIngestDetail> modifiableMap = new LinkedHashMap<>(
                    datasourcePackageIngestDetailsParam.size());
            datasourcePackageIngestDetailsParam.forEach((key, value) -> {
                DatasourcePackage result = DatasourcePackage.fromValue(key);
                if (result != DatasourcePackage.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
