/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.detective.model.DetectiveResponse;
import software.amazon.awssdk.services.detective.model.MembershipDatasources;
import software.amazon.awssdk.services.detective.model.MembershipDatasourcesListCopier;
import software.amazon.awssdk.services.detective.model.UnprocessedAccount;
import software.amazon.awssdk.services.detective.model.UnprocessedAccountListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetGraphMemberDatasourcesResponse
extends DetectiveResponse
implements ToCopyableBuilder<Builder, BatchGetGraphMemberDatasourcesResponse> {
    private static final SdkField<List<MembershipDatasources>> MEMBER_DATASOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberDatasources").getter(BatchGetGraphMemberDatasourcesResponse.getter(BatchGetGraphMemberDatasourcesResponse::memberDatasources)).setter(BatchGetGraphMemberDatasourcesResponse.setter(Builder::memberDatasources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDatasources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MembershipDatasources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedAccounts").getter(BatchGetGraphMemberDatasourcesResponse.getter(BatchGetGraphMemberDatasourcesResponse::unprocessedAccounts)).setter(BatchGetGraphMemberDatasourcesResponse.setter(Builder::unprocessedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_DATASOURCES_FIELD, UNPROCESSED_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MemberDatasources", MEMBER_DATASOURCES_FIELD);
            this.put("UnprocessedAccounts", UNPROCESSED_ACCOUNTS_FIELD);
        }
    });
    private final List<MembershipDatasources> memberDatasources;
    private final List<UnprocessedAccount> unprocessedAccounts;

    private BatchGetGraphMemberDatasourcesResponse(BuilderImpl builder) {
        super(builder);
        this.memberDatasources = builder.memberDatasources;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    public final boolean hasMemberDatasources() {
        return this.memberDatasources != null && !(this.memberDatasources instanceof SdkAutoConstructList);
    }

    public final List<MembershipDatasources> memberDatasources() {
        return this.memberDatasources;
    }

    public final boolean hasUnprocessedAccounts() {
        return this.unprocessedAccounts != null && !(this.unprocessedAccounts instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedAccount> unprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberDatasources() ? this.memberDatasources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetGraphMemberDatasourcesResponse)) {
            return false;
        }
        BatchGetGraphMemberDatasourcesResponse other = (BatchGetGraphMemberDatasourcesResponse)((Object)obj);
        return this.hasMemberDatasources() == other.hasMemberDatasources() && Objects.equals(this.memberDatasources(), other.memberDatasources()) && this.hasUnprocessedAccounts() == other.hasUnprocessedAccounts() && Objects.equals(this.unprocessedAccounts(), other.unprocessedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetGraphMemberDatasourcesResponse").add("MemberDatasources", this.hasMemberDatasources() ? this.memberDatasources() : null).add("UnprocessedAccounts", this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberDatasources": {
                return Optional.ofNullable(clazz.cast(this.memberDatasources()));
            }
            case "UnprocessedAccounts": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetGraphMemberDatasourcesResponse, T> g) {
        return obj -> g.apply((BatchGetGraphMemberDatasourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DetectiveResponse.BuilderImpl
    implements Builder {
        private List<MembershipDatasources> memberDatasources = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetGraphMemberDatasourcesResponse model) {
            super(model);
            this.memberDatasources(model.memberDatasources);
            this.unprocessedAccounts(model.unprocessedAccounts);
        }

        public final List<MembershipDatasources.Builder> getMemberDatasources() {
            List<MembershipDatasources.Builder> result = MembershipDatasourcesListCopier.copyToBuilder(this.memberDatasources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberDatasources(Collection<MembershipDatasources.BuilderImpl> memberDatasources) {
            this.memberDatasources = MembershipDatasourcesListCopier.copyFromBuilder(memberDatasources);
        }

        @Override
        public final Builder memberDatasources(Collection<MembershipDatasources> memberDatasources) {
            this.memberDatasources = MembershipDatasourcesListCopier.copy(memberDatasources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDatasources(MembershipDatasources ... memberDatasources) {
            this.memberDatasources(Arrays.asList(memberDatasources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDatasources(Consumer<MembershipDatasources.Builder> ... memberDatasources) {
            this.memberDatasources(Stream.of(memberDatasources).map(c -> (MembershipDatasources)((MembershipDatasources.Builder)MembershipDatasources.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            List<UnprocessedAccount.Builder> result = UnprocessedAccountListCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount ... unprocessedAccounts) {
            this.unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... unprocessedAccounts) {
            this.unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> (UnprocessedAccount)((UnprocessedAccount.Builder)UnprocessedAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetGraphMemberDatasourcesResponse build() {
            return new BatchGetGraphMemberDatasourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DetectiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetGraphMemberDatasourcesResponse> {
        public Builder memberDatasources(Collection<MembershipDatasources> var1);

        public Builder memberDatasources(MembershipDatasources ... var1);

        public Builder memberDatasources(Consumer<MembershipDatasources.Builder> ... var1);

        public Builder unprocessedAccounts(Collection<UnprocessedAccount> var1);

        public Builder unprocessedAccounts(UnprocessedAccount ... var1);

        public Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder> ... var1);
    }
}

