/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the indicators of compromise which are used to determine if a resource is involved in a security
 * incident. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that
 * can (with a high level of confidence) identify malicious activity or a security incident. For the list of indicators
 * of compromise that are generated by Detective investigations, see <a
 * href="https://docs.aws.amazon.com/detective/latest/userguide/detective-investigations.html">Detective
 * investigations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndicatorDetail implements SdkPojo, Serializable, ToCopyableBuilder<IndicatorDetail.Builder, IndicatorDetail> {
    private static final SdkField<TTPsObservedDetail> TT_PS_OBSERVED_DETAIL_FIELD = SdkField
            .<TTPsObservedDetail> builder(MarshallingType.SDK_POJO).memberName("TTPsObservedDetail")
            .getter(getter(IndicatorDetail::ttPsObservedDetail)).setter(setter(Builder::ttPsObservedDetail))
            .constructor(TTPsObservedDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TTPsObservedDetail").build())
            .build();

    private static final SdkField<ImpossibleTravelDetail> IMPOSSIBLE_TRAVEL_DETAIL_FIELD = SdkField
            .<ImpossibleTravelDetail> builder(MarshallingType.SDK_POJO).memberName("ImpossibleTravelDetail")
            .getter(getter(IndicatorDetail::impossibleTravelDetail)).setter(setter(Builder::impossibleTravelDetail))
            .constructor(ImpossibleTravelDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpossibleTravelDetail").build())
            .build();

    private static final SdkField<FlaggedIpAddressDetail> FLAGGED_IP_ADDRESS_DETAIL_FIELD = SdkField
            .<FlaggedIpAddressDetail> builder(MarshallingType.SDK_POJO).memberName("FlaggedIpAddressDetail")
            .getter(getter(IndicatorDetail::flaggedIpAddressDetail)).setter(setter(Builder::flaggedIpAddressDetail))
            .constructor(FlaggedIpAddressDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlaggedIpAddressDetail").build())
            .build();

    private static final SdkField<NewGeolocationDetail> NEW_GEOLOCATION_DETAIL_FIELD = SdkField
            .<NewGeolocationDetail> builder(MarshallingType.SDK_POJO).memberName("NewGeolocationDetail")
            .getter(getter(IndicatorDetail::newGeolocationDetail)).setter(setter(Builder::newGeolocationDetail))
            .constructor(NewGeolocationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGeolocationDetail").build())
            .build();

    private static final SdkField<NewAsoDetail> NEW_ASO_DETAIL_FIELD = SdkField.<NewAsoDetail> builder(MarshallingType.SDK_POJO)
            .memberName("NewAsoDetail").getter(getter(IndicatorDetail::newAsoDetail)).setter(setter(Builder::newAsoDetail))
            .constructor(NewAsoDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewAsoDetail").build()).build();

    private static final SdkField<NewUserAgentDetail> NEW_USER_AGENT_DETAIL_FIELD = SdkField
            .<NewUserAgentDetail> builder(MarshallingType.SDK_POJO).memberName("NewUserAgentDetail")
            .getter(getter(IndicatorDetail::newUserAgentDetail)).setter(setter(Builder::newUserAgentDetail))
            .constructor(NewUserAgentDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewUserAgentDetail").build())
            .build();

    private static final SdkField<RelatedFindingDetail> RELATED_FINDING_DETAIL_FIELD = SdkField
            .<RelatedFindingDetail> builder(MarshallingType.SDK_POJO).memberName("RelatedFindingDetail")
            .getter(getter(IndicatorDetail::relatedFindingDetail)).setter(setter(Builder::relatedFindingDetail))
            .constructor(RelatedFindingDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindingDetail").build())
            .build();

    private static final SdkField<RelatedFindingGroupDetail> RELATED_FINDING_GROUP_DETAIL_FIELD = SdkField
            .<RelatedFindingGroupDetail> builder(MarshallingType.SDK_POJO).memberName("RelatedFindingGroupDetail")
            .getter(getter(IndicatorDetail::relatedFindingGroupDetail)).setter(setter(Builder::relatedFindingGroupDetail))
            .constructor(RelatedFindingGroupDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindingGroupDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TT_PS_OBSERVED_DETAIL_FIELD,
            IMPOSSIBLE_TRAVEL_DETAIL_FIELD, FLAGGED_IP_ADDRESS_DETAIL_FIELD, NEW_GEOLOCATION_DETAIL_FIELD, NEW_ASO_DETAIL_FIELD,
            NEW_USER_AGENT_DETAIL_FIELD, RELATED_FINDING_DETAIL_FIELD, RELATED_FINDING_GROUP_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TTPsObservedDetail ttPsObservedDetail;

    private final ImpossibleTravelDetail impossibleTravelDetail;

    private final FlaggedIpAddressDetail flaggedIpAddressDetail;

    private final NewGeolocationDetail newGeolocationDetail;

    private final NewAsoDetail newAsoDetail;

    private final NewUserAgentDetail newUserAgentDetail;

    private final RelatedFindingDetail relatedFindingDetail;

    private final RelatedFindingGroupDetail relatedFindingGroupDetail;

    private IndicatorDetail(BuilderImpl builder) {
        this.ttPsObservedDetail = builder.ttPsObservedDetail;
        this.impossibleTravelDetail = builder.impossibleTravelDetail;
        this.flaggedIpAddressDetail = builder.flaggedIpAddressDetail;
        this.newGeolocationDetail = builder.newGeolocationDetail;
        this.newAsoDetail = builder.newAsoDetail;
        this.newUserAgentDetail = builder.newUserAgentDetail;
        this.relatedFindingDetail = builder.relatedFindingDetail;
        this.relatedFindingGroupDetail = builder.relatedFindingGroupDetail;
    }

    /**
     * <p>
     * Details about the indicator of compromise.
     * </p>
     * 
     * @return Details about the indicator of compromise.
     */
    public final TTPsObservedDetail ttPsObservedDetail() {
        return ttPsObservedDetail;
    }

    /**
     * <p>
     * Identifies unusual and impossible user activity for an account.
     * </p>
     * 
     * @return Identifies unusual and impossible user activity for an account.
     */
    public final ImpossibleTravelDetail impossibleTravelDetail() {
        return impossibleTravelDetail;
    }

    /**
     * <p>
     * Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat intelligence
     * by Detective. This indicator is derived from Amazon Web Services threat intelligence.
     * </p>
     * 
     * @return Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat
     *         intelligence by Detective. This indicator is derived from Amazon Web Services threat intelligence.
     */
    public final FlaggedIpAddressDetail flaggedIpAddressDetail() {
        return flaggedIpAddressDetail;
    }

    /**
     * <p>
     * Contains details about the new geographic location.
     * </p>
     * 
     * @return Contains details about the new geographic location.
     */
    public final NewGeolocationDetail newGeolocationDetail() {
        return newGeolocationDetail;
    }

    /**
     * <p>
     * Contains details about the new Autonomous System Organization (ASO).
     * </p>
     * 
     * @return Contains details about the new Autonomous System Organization (ASO).
     */
    public final NewAsoDetail newAsoDetail() {
        return newAsoDetail;
    }

    /**
     * <p>
     * Contains details about the new user agent.
     * </p>
     * 
     * @return Contains details about the new user agent.
     */
    public final NewUserAgentDetail newUserAgentDetail() {
        return newUserAgentDetail;
    }

    /**
     * <p>
     * Contains details about related findings.
     * </p>
     * 
     * @return Contains details about related findings.
     */
    public final RelatedFindingDetail relatedFindingDetail() {
        return relatedFindingDetail;
    }

    /**
     * <p>
     * Contains details about related finding groups.
     * </p>
     * 
     * @return Contains details about related finding groups.
     */
    public final RelatedFindingGroupDetail relatedFindingGroupDetail() {
        return relatedFindingGroupDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ttPsObservedDetail());
        hashCode = 31 * hashCode + Objects.hashCode(impossibleTravelDetail());
        hashCode = 31 * hashCode + Objects.hashCode(flaggedIpAddressDetail());
        hashCode = 31 * hashCode + Objects.hashCode(newGeolocationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(newAsoDetail());
        hashCode = 31 * hashCode + Objects.hashCode(newUserAgentDetail());
        hashCode = 31 * hashCode + Objects.hashCode(relatedFindingDetail());
        hashCode = 31 * hashCode + Objects.hashCode(relatedFindingGroupDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndicatorDetail)) {
            return false;
        }
        IndicatorDetail other = (IndicatorDetail) obj;
        return Objects.equals(ttPsObservedDetail(), other.ttPsObservedDetail())
                && Objects.equals(impossibleTravelDetail(), other.impossibleTravelDetail())
                && Objects.equals(flaggedIpAddressDetail(), other.flaggedIpAddressDetail())
                && Objects.equals(newGeolocationDetail(), other.newGeolocationDetail())
                && Objects.equals(newAsoDetail(), other.newAsoDetail())
                && Objects.equals(newUserAgentDetail(), other.newUserAgentDetail())
                && Objects.equals(relatedFindingDetail(), other.relatedFindingDetail())
                && Objects.equals(relatedFindingGroupDetail(), other.relatedFindingGroupDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndicatorDetail").add("TTPsObservedDetail", ttPsObservedDetail())
                .add("ImpossibleTravelDetail", impossibleTravelDetail()).add("FlaggedIpAddressDetail", flaggedIpAddressDetail())
                .add("NewGeolocationDetail", newGeolocationDetail()).add("NewAsoDetail", newAsoDetail())
                .add("NewUserAgentDetail", newUserAgentDetail()).add("RelatedFindingDetail", relatedFindingDetail())
                .add("RelatedFindingGroupDetail", relatedFindingGroupDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TTPsObservedDetail":
            return Optional.ofNullable(clazz.cast(ttPsObservedDetail()));
        case "ImpossibleTravelDetail":
            return Optional.ofNullable(clazz.cast(impossibleTravelDetail()));
        case "FlaggedIpAddressDetail":
            return Optional.ofNullable(clazz.cast(flaggedIpAddressDetail()));
        case "NewGeolocationDetail":
            return Optional.ofNullable(clazz.cast(newGeolocationDetail()));
        case "NewAsoDetail":
            return Optional.ofNullable(clazz.cast(newAsoDetail()));
        case "NewUserAgentDetail":
            return Optional.ofNullable(clazz.cast(newUserAgentDetail()));
        case "RelatedFindingDetail":
            return Optional.ofNullable(clazz.cast(relatedFindingDetail()));
        case "RelatedFindingGroupDetail":
            return Optional.ofNullable(clazz.cast(relatedFindingGroupDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TTPsObservedDetail", TT_PS_OBSERVED_DETAIL_FIELD);
        map.put("ImpossibleTravelDetail", IMPOSSIBLE_TRAVEL_DETAIL_FIELD);
        map.put("FlaggedIpAddressDetail", FLAGGED_IP_ADDRESS_DETAIL_FIELD);
        map.put("NewGeolocationDetail", NEW_GEOLOCATION_DETAIL_FIELD);
        map.put("NewAsoDetail", NEW_ASO_DETAIL_FIELD);
        map.put("NewUserAgentDetail", NEW_USER_AGENT_DETAIL_FIELD);
        map.put("RelatedFindingDetail", RELATED_FINDING_DETAIL_FIELD);
        map.put("RelatedFindingGroupDetail", RELATED_FINDING_GROUP_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndicatorDetail, T> g) {
        return obj -> g.apply((IndicatorDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndicatorDetail> {
        /**
         * <p>
         * Details about the indicator of compromise.
         * </p>
         * 
         * @param ttPsObservedDetail
         *        Details about the indicator of compromise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttPsObservedDetail(TTPsObservedDetail ttPsObservedDetail);

        /**
         * <p>
         * Details about the indicator of compromise.
         * </p>
         * This is a convenience method that creates an instance of the {@link TTPsObservedDetail.Builder} avoiding the
         * need to create one manually via {@link TTPsObservedDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TTPsObservedDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #ttPsObservedDetail(TTPsObservedDetail)}.
         * 
         * @param ttPsObservedDetail
         *        a consumer that will call methods on {@link TTPsObservedDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ttPsObservedDetail(TTPsObservedDetail)
         */
        default Builder ttPsObservedDetail(Consumer<TTPsObservedDetail.Builder> ttPsObservedDetail) {
            return ttPsObservedDetail(TTPsObservedDetail.builder().applyMutation(ttPsObservedDetail).build());
        }

        /**
         * <p>
         * Identifies unusual and impossible user activity for an account.
         * </p>
         * 
         * @param impossibleTravelDetail
         *        Identifies unusual and impossible user activity for an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impossibleTravelDetail(ImpossibleTravelDetail impossibleTravelDetail);

        /**
         * <p>
         * Identifies unusual and impossible user activity for an account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImpossibleTravelDetail.Builder} avoiding
         * the need to create one manually via {@link ImpossibleTravelDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImpossibleTravelDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #impossibleTravelDetail(ImpossibleTravelDetail)}.
         * 
         * @param impossibleTravelDetail
         *        a consumer that will call methods on {@link ImpossibleTravelDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #impossibleTravelDetail(ImpossibleTravelDetail)
         */
        default Builder impossibleTravelDetail(Consumer<ImpossibleTravelDetail.Builder> impossibleTravelDetail) {
            return impossibleTravelDetail(ImpossibleTravelDetail.builder().applyMutation(impossibleTravelDetail).build());
        }

        /**
         * <p>
         * Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat
         * intelligence by Detective. This indicator is derived from Amazon Web Services threat intelligence.
         * </p>
         * 
         * @param flaggedIpAddressDetail
         *        Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat
         *        intelligence by Detective. This indicator is derived from Amazon Web Services threat intelligence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flaggedIpAddressDetail(FlaggedIpAddressDetail flaggedIpAddressDetail);

        /**
         * <p>
         * Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat
         * intelligence by Detective. This indicator is derived from Amazon Web Services threat intelligence.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlaggedIpAddressDetail.Builder} avoiding
         * the need to create one manually via {@link FlaggedIpAddressDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlaggedIpAddressDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #flaggedIpAddressDetail(FlaggedIpAddressDetail)}.
         * 
         * @param flaggedIpAddressDetail
         *        a consumer that will call methods on {@link FlaggedIpAddressDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flaggedIpAddressDetail(FlaggedIpAddressDetail)
         */
        default Builder flaggedIpAddressDetail(Consumer<FlaggedIpAddressDetail.Builder> flaggedIpAddressDetail) {
            return flaggedIpAddressDetail(FlaggedIpAddressDetail.builder().applyMutation(flaggedIpAddressDetail).build());
        }

        /**
         * <p>
         * Contains details about the new geographic location.
         * </p>
         * 
         * @param newGeolocationDetail
         *        Contains details about the new geographic location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newGeolocationDetail(NewGeolocationDetail newGeolocationDetail);

        /**
         * <p>
         * Contains details about the new geographic location.
         * </p>
         * This is a convenience method that creates an instance of the {@link NewGeolocationDetail.Builder} avoiding
         * the need to create one manually via {@link NewGeolocationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NewGeolocationDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #newGeolocationDetail(NewGeolocationDetail)}.
         * 
         * @param newGeolocationDetail
         *        a consumer that will call methods on {@link NewGeolocationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newGeolocationDetail(NewGeolocationDetail)
         */
        default Builder newGeolocationDetail(Consumer<NewGeolocationDetail.Builder> newGeolocationDetail) {
            return newGeolocationDetail(NewGeolocationDetail.builder().applyMutation(newGeolocationDetail).build());
        }

        /**
         * <p>
         * Contains details about the new Autonomous System Organization (ASO).
         * </p>
         * 
         * @param newAsoDetail
         *        Contains details about the new Autonomous System Organization (ASO).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newAsoDetail(NewAsoDetail newAsoDetail);

        /**
         * <p>
         * Contains details about the new Autonomous System Organization (ASO).
         * </p>
         * This is a convenience method that creates an instance of the {@link NewAsoDetail.Builder} avoiding the need
         * to create one manually via {@link NewAsoDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NewAsoDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #newAsoDetail(NewAsoDetail)}.
         * 
         * @param newAsoDetail
         *        a consumer that will call methods on {@link NewAsoDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newAsoDetail(NewAsoDetail)
         */
        default Builder newAsoDetail(Consumer<NewAsoDetail.Builder> newAsoDetail) {
            return newAsoDetail(NewAsoDetail.builder().applyMutation(newAsoDetail).build());
        }

        /**
         * <p>
         * Contains details about the new user agent.
         * </p>
         * 
         * @param newUserAgentDetail
         *        Contains details about the new user agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newUserAgentDetail(NewUserAgentDetail newUserAgentDetail);

        /**
         * <p>
         * Contains details about the new user agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link NewUserAgentDetail.Builder} avoiding the
         * need to create one manually via {@link NewUserAgentDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NewUserAgentDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #newUserAgentDetail(NewUserAgentDetail)}.
         * 
         * @param newUserAgentDetail
         *        a consumer that will call methods on {@link NewUserAgentDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newUserAgentDetail(NewUserAgentDetail)
         */
        default Builder newUserAgentDetail(Consumer<NewUserAgentDetail.Builder> newUserAgentDetail) {
            return newUserAgentDetail(NewUserAgentDetail.builder().applyMutation(newUserAgentDetail).build());
        }

        /**
         * <p>
         * Contains details about related findings.
         * </p>
         * 
         * @param relatedFindingDetail
         *        Contains details about related findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingDetail(RelatedFindingDetail relatedFindingDetail);

        /**
         * <p>
         * Contains details about related findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedFindingDetail.Builder} avoiding
         * the need to create one manually via {@link RelatedFindingDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedFindingDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #relatedFindingDetail(RelatedFindingDetail)}.
         * 
         * @param relatedFindingDetail
         *        a consumer that will call methods on {@link RelatedFindingDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindingDetail(RelatedFindingDetail)
         */
        default Builder relatedFindingDetail(Consumer<RelatedFindingDetail.Builder> relatedFindingDetail) {
            return relatedFindingDetail(RelatedFindingDetail.builder().applyMutation(relatedFindingDetail).build());
        }

        /**
         * <p>
         * Contains details about related finding groups.
         * </p>
         * 
         * @param relatedFindingGroupDetail
         *        Contains details about related finding groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindingGroupDetail(RelatedFindingGroupDetail relatedFindingGroupDetail);

        /**
         * <p>
         * Contains details about related finding groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedFindingGroupDetail.Builder}
         * avoiding the need to create one manually via {@link RelatedFindingGroupDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedFindingGroupDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #relatedFindingGroupDetail(RelatedFindingGroupDetail)}.
         * 
         * @param relatedFindingGroupDetail
         *        a consumer that will call methods on {@link RelatedFindingGroupDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindingGroupDetail(RelatedFindingGroupDetail)
         */
        default Builder relatedFindingGroupDetail(Consumer<RelatedFindingGroupDetail.Builder> relatedFindingGroupDetail) {
            return relatedFindingGroupDetail(RelatedFindingGroupDetail.builder().applyMutation(relatedFindingGroupDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TTPsObservedDetail ttPsObservedDetail;

        private ImpossibleTravelDetail impossibleTravelDetail;

        private FlaggedIpAddressDetail flaggedIpAddressDetail;

        private NewGeolocationDetail newGeolocationDetail;

        private NewAsoDetail newAsoDetail;

        private NewUserAgentDetail newUserAgentDetail;

        private RelatedFindingDetail relatedFindingDetail;

        private RelatedFindingGroupDetail relatedFindingGroupDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(IndicatorDetail model) {
            ttPsObservedDetail(model.ttPsObservedDetail);
            impossibleTravelDetail(model.impossibleTravelDetail);
            flaggedIpAddressDetail(model.flaggedIpAddressDetail);
            newGeolocationDetail(model.newGeolocationDetail);
            newAsoDetail(model.newAsoDetail);
            newUserAgentDetail(model.newUserAgentDetail);
            relatedFindingDetail(model.relatedFindingDetail);
            relatedFindingGroupDetail(model.relatedFindingGroupDetail);
        }

        public final TTPsObservedDetail.Builder getTtPsObservedDetail() {
            return ttPsObservedDetail != null ? ttPsObservedDetail.toBuilder() : null;
        }

        public final void setTtPsObservedDetail(TTPsObservedDetail.BuilderImpl ttPsObservedDetail) {
            this.ttPsObservedDetail = ttPsObservedDetail != null ? ttPsObservedDetail.build() : null;
        }

        @Override
        public final Builder ttPsObservedDetail(TTPsObservedDetail ttPsObservedDetail) {
            this.ttPsObservedDetail = ttPsObservedDetail;
            return this;
        }

        public final ImpossibleTravelDetail.Builder getImpossibleTravelDetail() {
            return impossibleTravelDetail != null ? impossibleTravelDetail.toBuilder() : null;
        }

        public final void setImpossibleTravelDetail(ImpossibleTravelDetail.BuilderImpl impossibleTravelDetail) {
            this.impossibleTravelDetail = impossibleTravelDetail != null ? impossibleTravelDetail.build() : null;
        }

        @Override
        public final Builder impossibleTravelDetail(ImpossibleTravelDetail impossibleTravelDetail) {
            this.impossibleTravelDetail = impossibleTravelDetail;
            return this;
        }

        public final FlaggedIpAddressDetail.Builder getFlaggedIpAddressDetail() {
            return flaggedIpAddressDetail != null ? flaggedIpAddressDetail.toBuilder() : null;
        }

        public final void setFlaggedIpAddressDetail(FlaggedIpAddressDetail.BuilderImpl flaggedIpAddressDetail) {
            this.flaggedIpAddressDetail = flaggedIpAddressDetail != null ? flaggedIpAddressDetail.build() : null;
        }

        @Override
        public final Builder flaggedIpAddressDetail(FlaggedIpAddressDetail flaggedIpAddressDetail) {
            this.flaggedIpAddressDetail = flaggedIpAddressDetail;
            return this;
        }

        public final NewGeolocationDetail.Builder getNewGeolocationDetail() {
            return newGeolocationDetail != null ? newGeolocationDetail.toBuilder() : null;
        }

        public final void setNewGeolocationDetail(NewGeolocationDetail.BuilderImpl newGeolocationDetail) {
            this.newGeolocationDetail = newGeolocationDetail != null ? newGeolocationDetail.build() : null;
        }

        @Override
        public final Builder newGeolocationDetail(NewGeolocationDetail newGeolocationDetail) {
            this.newGeolocationDetail = newGeolocationDetail;
            return this;
        }

        public final NewAsoDetail.Builder getNewAsoDetail() {
            return newAsoDetail != null ? newAsoDetail.toBuilder() : null;
        }

        public final void setNewAsoDetail(NewAsoDetail.BuilderImpl newAsoDetail) {
            this.newAsoDetail = newAsoDetail != null ? newAsoDetail.build() : null;
        }

        @Override
        public final Builder newAsoDetail(NewAsoDetail newAsoDetail) {
            this.newAsoDetail = newAsoDetail;
            return this;
        }

        public final NewUserAgentDetail.Builder getNewUserAgentDetail() {
            return newUserAgentDetail != null ? newUserAgentDetail.toBuilder() : null;
        }

        public final void setNewUserAgentDetail(NewUserAgentDetail.BuilderImpl newUserAgentDetail) {
            this.newUserAgentDetail = newUserAgentDetail != null ? newUserAgentDetail.build() : null;
        }

        @Override
        public final Builder newUserAgentDetail(NewUserAgentDetail newUserAgentDetail) {
            this.newUserAgentDetail = newUserAgentDetail;
            return this;
        }

        public final RelatedFindingDetail.Builder getRelatedFindingDetail() {
            return relatedFindingDetail != null ? relatedFindingDetail.toBuilder() : null;
        }

        public final void setRelatedFindingDetail(RelatedFindingDetail.BuilderImpl relatedFindingDetail) {
            this.relatedFindingDetail = relatedFindingDetail != null ? relatedFindingDetail.build() : null;
        }

        @Override
        public final Builder relatedFindingDetail(RelatedFindingDetail relatedFindingDetail) {
            this.relatedFindingDetail = relatedFindingDetail;
            return this;
        }

        public final RelatedFindingGroupDetail.Builder getRelatedFindingGroupDetail() {
            return relatedFindingGroupDetail != null ? relatedFindingGroupDetail.toBuilder() : null;
        }

        public final void setRelatedFindingGroupDetail(RelatedFindingGroupDetail.BuilderImpl relatedFindingGroupDetail) {
            this.relatedFindingGroupDetail = relatedFindingGroupDetail != null ? relatedFindingGroupDetail.build() : null;
        }

        @Override
        public final Builder relatedFindingGroupDetail(RelatedFindingGroupDetail relatedFindingGroupDetail) {
            this.relatedFindingGroupDetail = relatedFindingGroupDetail;
            return this;
        }

        @Override
        public IndicatorDetail build() {
            return new IndicatorDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
