/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetMembershipDatasourcesResponse extends DetectiveResponse implements
        ToCopyableBuilder<BatchGetMembershipDatasourcesResponse.Builder, BatchGetMembershipDatasourcesResponse> {
    private static final SdkField<List<MembershipDatasources>> MEMBERSHIP_DATASOURCES_FIELD = SdkField
            .<List<MembershipDatasources>> builder(MarshallingType.LIST)
            .memberName("MembershipDatasources")
            .getter(getter(BatchGetMembershipDatasourcesResponse::membershipDatasources))
            .setter(setter(Builder::membershipDatasources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MembershipDatasources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MembershipDatasources> builder(MarshallingType.SDK_POJO)
                                            .constructor(MembershipDatasources::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedGraph>> UNPROCESSED_GRAPHS_FIELD = SdkField
            .<List<UnprocessedGraph>> builder(MarshallingType.LIST)
            .memberName("UnprocessedGraphs")
            .getter(getter(BatchGetMembershipDatasourcesResponse::unprocessedGraphs))
            .setter(setter(Builder::unprocessedGraphs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedGraphs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedGraph> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedGraph::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_DATASOURCES_FIELD,
            UNPROCESSED_GRAPHS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MembershipDatasources> membershipDatasources;

    private final List<UnprocessedGraph> unprocessedGraphs;

    private BatchGetMembershipDatasourcesResponse(BuilderImpl builder) {
        super(builder);
        this.membershipDatasources = builder.membershipDatasources;
        this.unprocessedGraphs = builder.unprocessedGraphs;
    }

    /**
     * For responses, this returns true if the service returned a value for the MembershipDatasources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMembershipDatasources() {
        return membershipDatasources != null && !(membershipDatasources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details on the data source package history for an member of the behavior graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembershipDatasources} method.
     * </p>
     * 
     * @return Details on the data source package history for an member of the behavior graph.
     */
    public final List<MembershipDatasources> membershipDatasources() {
        return membershipDatasources;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedGraphs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedGraphs() {
        return unprocessedGraphs != null && !(unprocessedGraphs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Graphs that data source package information could not be retrieved for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedGraphs} method.
     * </p>
     * 
     * @return Graphs that data source package information could not be retrieved for.
     */
    public final List<UnprocessedGraph> unprocessedGraphs() {
        return unprocessedGraphs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMembershipDatasources() ? membershipDatasources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedGraphs() ? unprocessedGraphs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMembershipDatasourcesResponse)) {
            return false;
        }
        BatchGetMembershipDatasourcesResponse other = (BatchGetMembershipDatasourcesResponse) obj;
        return hasMembershipDatasources() == other.hasMembershipDatasources()
                && Objects.equals(membershipDatasources(), other.membershipDatasources())
                && hasUnprocessedGraphs() == other.hasUnprocessedGraphs()
                && Objects.equals(unprocessedGraphs(), other.unprocessedGraphs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetMembershipDatasourcesResponse")
                .add("MembershipDatasources", hasMembershipDatasources() ? membershipDatasources() : null)
                .add("UnprocessedGraphs", hasUnprocessedGraphs() ? unprocessedGraphs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MembershipDatasources":
            return Optional.ofNullable(clazz.cast(membershipDatasources()));
        case "UnprocessedGraphs":
            return Optional.ofNullable(clazz.cast(unprocessedGraphs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MembershipDatasources", MEMBERSHIP_DATASOURCES_FIELD);
        map.put("UnprocessedGraphs", UNPROCESSED_GRAPHS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMembershipDatasourcesResponse, T> g) {
        return obj -> g.apply((BatchGetMembershipDatasourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DetectiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetMembershipDatasourcesResponse> {
        /**
         * <p>
         * Details on the data source package history for an member of the behavior graph.
         * </p>
         * 
         * @param membershipDatasources
         *        Details on the data source package history for an member of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipDatasources(Collection<MembershipDatasources> membershipDatasources);

        /**
         * <p>
         * Details on the data source package history for an member of the behavior graph.
         * </p>
         * 
         * @param membershipDatasources
         *        Details on the data source package history for an member of the behavior graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipDatasources(MembershipDatasources... membershipDatasources);

        /**
         * <p>
         * Details on the data source package history for an member of the behavior graph.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.detective.model.MembershipDatasources.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.detective.model.MembershipDatasources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.detective.model.MembershipDatasources.Builder#build()} is called
         * immediately and its result is passed to {@link #membershipDatasources(List<MembershipDatasources>)}.
         * 
         * @param membershipDatasources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.detective.model.MembershipDatasources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #membershipDatasources(java.util.Collection<MembershipDatasources>)
         */
        Builder membershipDatasources(Consumer<MembershipDatasources.Builder>... membershipDatasources);

        /**
         * <p>
         * Graphs that data source package information could not be retrieved for.
         * </p>
         * 
         * @param unprocessedGraphs
         *        Graphs that data source package information could not be retrieved for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedGraphs(Collection<UnprocessedGraph> unprocessedGraphs);

        /**
         * <p>
         * Graphs that data source package information could not be retrieved for.
         * </p>
         * 
         * @param unprocessedGraphs
         *        Graphs that data source package information could not be retrieved for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedGraphs(UnprocessedGraph... unprocessedGraphs);

        /**
         * <p>
         * Graphs that data source package information could not be retrieved for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.detective.model.UnprocessedGraph.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.detective.model.UnprocessedGraph#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.detective.model.UnprocessedGraph.Builder#build()} is called
         * immediately and its result is passed to {@link #unprocessedGraphs(List<UnprocessedGraph>)}.
         * 
         * @param unprocessedGraphs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.detective.model.UnprocessedGraph.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedGraphs(java.util.Collection<UnprocessedGraph>)
         */
        Builder unprocessedGraphs(Consumer<UnprocessedGraph.Builder>... unprocessedGraphs);
    }

    static final class BuilderImpl extends DetectiveResponse.BuilderImpl implements Builder {
        private List<MembershipDatasources> membershipDatasources = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedGraph> unprocessedGraphs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMembershipDatasourcesResponse model) {
            super(model);
            membershipDatasources(model.membershipDatasources);
            unprocessedGraphs(model.unprocessedGraphs);
        }

        public final List<MembershipDatasources.Builder> getMembershipDatasources() {
            List<MembershipDatasources.Builder> result = MembershipDatasourcesListCopier
                    .copyToBuilder(this.membershipDatasources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembershipDatasources(Collection<MembershipDatasources.BuilderImpl> membershipDatasources) {
            this.membershipDatasources = MembershipDatasourcesListCopier.copyFromBuilder(membershipDatasources);
        }

        @Override
        public final Builder membershipDatasources(Collection<MembershipDatasources> membershipDatasources) {
            this.membershipDatasources = MembershipDatasourcesListCopier.copy(membershipDatasources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipDatasources(MembershipDatasources... membershipDatasources) {
            membershipDatasources(Arrays.asList(membershipDatasources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder membershipDatasources(Consumer<MembershipDatasources.Builder>... membershipDatasources) {
            membershipDatasources(Stream.of(membershipDatasources)
                    .map(c -> MembershipDatasources.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedGraph.Builder> getUnprocessedGraphs() {
            List<UnprocessedGraph.Builder> result = UnprocessedGraphListCopier.copyToBuilder(this.unprocessedGraphs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedGraphs(Collection<UnprocessedGraph.BuilderImpl> unprocessedGraphs) {
            this.unprocessedGraphs = UnprocessedGraphListCopier.copyFromBuilder(unprocessedGraphs);
        }

        @Override
        public final Builder unprocessedGraphs(Collection<UnprocessedGraph> unprocessedGraphs) {
            this.unprocessedGraphs = UnprocessedGraphListCopier.copy(unprocessedGraphs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedGraphs(UnprocessedGraph... unprocessedGraphs) {
            unprocessedGraphs(Arrays.asList(unprocessedGraphs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedGraphs(Consumer<UnprocessedGraph.Builder>... unprocessedGraphs) {
            unprocessedGraphs(Stream.of(unprocessedGraphs).map(c -> UnprocessedGraph.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetMembershipDatasourcesResponse build() {
            return new BatchGetMembershipDatasourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
